/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Verify;
import java.util.List;
import java.util.Optional;

public final class TypeNameClassifier {
    private TypeNameClassifier() {
    }

    static Optional<Integer> typePrefixLength(List<String> nameParts) {
        TyParseState state = TyParseState.START;
        Optional<Integer> typeLength = Optional.empty();
        for (int i2 = 0; i2 < nameParts.size() && (state = state.next(JavaCaseFormat.from(nameParts.get(i2)))) != TyParseState.REJECT; ++i2) {
            if (!state.isSingleUnit()) continue;
            typeLength = Optional.of(i2);
        }
        return typeLength;
    }

    private static enum TyParseState {
        START(false){

            @Override
            public TyParseState next(JavaCaseFormat n2) {
                switch (n2) {
                    case UPPERCASE: {
                        return AMBIGUOUS;
                    }
                    case LOWER_CAMEL: {
                        return REJECT;
                    }
                    case LOWERCASE: {
                        return START;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        TYPE(true){

            @Override
            public TyParseState next(JavaCaseFormat n2) {
                switch (n2) {
                    case UPPERCASE: 
                    case LOWER_CAMEL: 
                    case LOWERCASE: {
                        return FIRST_STATIC_MEMBER;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        FIRST_STATIC_MEMBER(true){

            @Override
            public TyParseState next(JavaCaseFormat n2) {
                return REJECT;
            }
        }
        ,
        REJECT(false){

            @Override
            public TyParseState next(JavaCaseFormat n2) {
                return REJECT;
            }
        }
        ,
        AMBIGUOUS(false){

            @Override
            public TyParseState next(JavaCaseFormat n2) {
                switch (n2) {
                    case UPPERCASE: {
                        return AMBIGUOUS;
                    }
                    case LOWER_CAMEL: 
                    case LOWERCASE: {
                        return REJECT;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        };

        private final boolean isSingleUnit;

        private TyParseState(boolean isSingleUnit) {
            this.isSingleUnit = isSingleUnit;
        }

        public boolean isSingleUnit() {
            return this.isSingleUnit;
        }

        public abstract TyParseState next(JavaCaseFormat var1);
    }

    public static enum JavaCaseFormat {
        UPPERCASE,
        LOWERCASE,
        UPPER_CAMEL,
        LOWER_CAMEL;


        static JavaCaseFormat from(String name) {
            Verify.verify(!name.isEmpty());
            boolean firstUppercase = false;
            boolean hasUppercase = false;
            boolean hasLowercase = false;
            boolean first = true;
            for (int i2 = 0; i2 < name.length(); ++i2) {
                char c2 = name.charAt(i2);
                if (!Character.isAlphabetic(c2)) continue;
                if (first) {
                    firstUppercase = Character.isUpperCase(c2);
                    first = false;
                }
                hasUppercase |= Character.isUpperCase(c2);
                hasLowercase |= Character.isLowerCase(c2);
            }
            if (firstUppercase) {
                return hasLowercase || name.length() == 1 ? UPPER_CAMEL : UPPERCASE;
            }
            return hasUppercase ? LOWER_CAMEL : LOWERCASE;
        }
    }
}

