/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.Replacement;
import java.util.ArrayList;
import java.util.List;

public class SnippetFormatter {
    private static final int INDENTATION_SIZE = 2;
    private final Formatter formatter = new Formatter();
    private static final CharMatcher NOT_WHITESPACE = CharMatcher.whitespace().negate();

    public String createIndentationString(int indentationLevel) {
        Preconditions.checkArgument(indentationLevel >= 0, "Indentation level cannot be less than zero. Given: %s", indentationLevel);
        int spaces = indentationLevel * 2;
        StringBuilder buf = new StringBuilder(spaces);
        for (int i2 = 0; i2 < spaces; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static Range<Integer> offsetRange(Range<Integer> range, int offset) {
        range = range.canonical(DiscreteDomain.integers());
        return Range.closedOpen(range.lowerEndpoint() + offset, range.upperEndpoint() + offset);
    }

    private static List<Range<Integer>> offsetRanges(List<Range<Integer>> ranges, int offset) {
        ArrayList<Range<Integer>> result = new ArrayList<Range<Integer>>();
        for (Range<Integer> range : ranges) {
            result.add(SnippetFormatter.offsetRange(range, offset));
        }
        return result;
    }

    public ImmutableList<Replacement> format(SnippetKind kind, String source, List<Range<Integer>> ranges, int initialIndent, boolean includeComments) throws FormatterException {
        TreeRangeSet<Integer> rangeSet = TreeRangeSet.create();
        for (Range<Integer> range : ranges) {
            rangeSet.add(range);
        }
        if (includeComments) {
            if (kind != SnippetKind.COMPILATION_UNIT) {
                throw new IllegalArgumentException("comment formatting is only supported for compilation units");
            }
            return this.formatter.getFormatReplacements(source, ranges);
        }
        SnippetWrapper wrapper = this.snippetWrapper(kind, source, initialIndent);
        ranges = SnippetFormatter.offsetRanges(ranges, wrapper.offset);
        String replacement = this.formatter.formatSource(wrapper.contents.toString(), ranges);
        replacement = replacement.substring(wrapper.offset, replacement.length() - (wrapper.contents.length() - wrapper.offset - source.length()));
        return SnippetFormatter.toReplacements(source, replacement).stream().filter(r2 -> rangeSet.encloses(r2.getReplaceRange())).collect(ImmutableList.toImmutableList());
    }

    private static List<Replacement> toReplacements(String source, String replacement) {
        if (!NOT_WHITESPACE.retainFrom(source).equals(NOT_WHITESPACE.retainFrom(replacement))) {
            throw new IllegalArgumentException("source = \"" + source + "\", replacement = \"" + replacement + "\"");
        }
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        int i2 = NOT_WHITESPACE.indexIn(source);
        int j2 = NOT_WHITESPACE.indexIn(replacement);
        if (i2 != 0 || j2 != 0) {
            replacements.add(Replacement.create(0, i2, replacement.substring(0, j2)));
        }
        while (i2 != -1 && j2 != -1) {
            int i22 = NOT_WHITESPACE.indexIn(source, i2 + 1);
            int j22 = NOT_WHITESPACE.indexIn(replacement, j2 + 1);
            if (i22 == -1 || j22 == -1) break;
            if (i22 - i2 != j22 - j2 || !source.substring(i2 + 1, i22).equals(replacement.substring(j2 + 1, j22))) {
                replacements.add(Replacement.create(i2 + 1, i22, replacement.substring(j2 + 1, j22)));
            }
            i2 = i22;
            j2 = j22;
        }
        return replacements;
    }

    private SnippetWrapper snippetWrapper(SnippetKind kind, String source, int initialIndent) {
        switch (kind) {
            case COMPILATION_UNIT: {
                SnippetWrapper wrapper = new SnippetWrapper();
                for (int i2 = 1; i2 <= initialIndent; ++i2) {
                    wrapper.append("class Dummy {\n").append(this.createIndentationString(i2));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case CLASS_BODY_DECLARATIONS: {
                SnippetWrapper wrapper = new SnippetWrapper();
                for (int i3 = 1; i3 <= initialIndent; ++i3) {
                    wrapper.append("class Dummy {\n").append(this.createIndentationString(i3));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case STATEMENTS: {
                SnippetWrapper wrapper = new SnippetWrapper();
                wrapper.append("class Dummy {\n").append(this.createIndentationString(1));
                for (int i4 = 2; i4 <= initialIndent; ++i4) {
                    wrapper.append("{\n").append(this.createIndentationString(i4));
                }
                wrapper.appendSource(source);
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
            case EXPRESSION: {
                SnippetWrapper wrapper = new SnippetWrapper();
                wrapper.append("class Dummy {\n").append(this.createIndentationString(1));
                for (int i5 = 2; i5 <= initialIndent; ++i5) {
                    wrapper.append("{\n").append(this.createIndentationString(i5));
                }
                wrapper.append("Object o = ");
                wrapper.appendSource(source);
                wrapper.append(";");
                wrapper.closeBraces(initialIndent);
                return wrapper;
            }
        }
        throw new IllegalArgumentException("Unknown snippet kind: " + kind);
    }

    public static enum SnippetKind {
        COMPILATION_UNIT,
        CLASS_BODY_DECLARATIONS,
        STATEMENTS,
        EXPRESSION;

    }

    private class SnippetWrapper {
        int offset;
        final StringBuilder contents = new StringBuilder();

        private SnippetWrapper() {
        }

        public SnippetWrapper append(String str) {
            this.contents.append(str);
            return this;
        }

        public SnippetWrapper appendSource(String source) {
            this.offset = this.contents.length();
            this.contents.append(source);
            return this;
        }

        public void closeBraces(int initialIndent) {
            int i2 = initialIndent;
            while (--i2 >= 0) {
                this.contents.append("\n").append(SnippetFormatter.this.createIndentationString(i2)).append("}");
            }
        }
    }
}

