/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.AutoValue_FormatFileCallable_Result;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.StringWrapper;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

class FormatFileCallable
implements Callable<Result> {
    private final Path path;
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    public FormatFileCallable(CommandLineOptions parameters, Path path, String input, JavaFormatterOptions options) {
        this.path = path;
        this.input = input;
        this.parameters = parameters;
        this.options = options;
    }

    @Override
    public Result call() {
        try {
            if (this.parameters.fixImportsOnly()) {
                return Result.create(this.path, this.input, this.fixImports(this.input), null);
            }
            Formatter formatter = new Formatter(this.options);
            String formatted = formatter.formatSource(this.input, this.characterRanges(this.input).asRanges());
            formatted = this.fixImports(formatted);
            if (this.parameters.reflowLongStrings()) {
                formatted = StringWrapper.wrap(100, formatted, formatter);
            }
            return Result.create(this.path, this.input, formatted, null);
        }
        catch (FormatterException e2) {
            return Result.create(this.path, this.input, null, e2);
        }
    }

    private String fixImports(String input) throws FormatterException {
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input, this.options.style());
        }
        return input;
    }

    private RangeSet<Integer> characterRanges(String input) {
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen(0, input.length()));
            return characterRanges;
        }
        characterRanges.addAll(Formatter.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i2 = 0; i2 < this.parameters.offsets().size(); ++i2) {
            Integer length = (Integer)this.parameters.lengths().get(i2);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Integer)this.parameters.offsets().get(i2), (Integer)this.parameters.offsets().get(i2) + length));
        }
        return characterRanges;
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        abstract @Nullable Path path();

        abstract String input();

        abstract @Nullable String output();

        boolean changed() {
            return !this.input().equals(this.output());
        }

        abstract @Nullable FormatterException exception();

        static Result create(@Nullable Path path, String input, @Nullable String output, @Nullable FormatterException exception) {
            return new AutoValue_FormatFileCallable_Result(path, input, output, exception);
        }
    }
}

