/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.CloseOp;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpenOp;
import com.google.googlejavaformat.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class OpsBuilder {
    private final Input input;
    private final List<Op> ops = new ArrayList<Op>();
    private final Output output;
    private static final Indent.Const ZERO = Indent.Const.ZERO;
    private int tokenI = 0;
    private int inputPosition = Integer.MIN_VALUE;
    int depth = 0;
    private int lastPartialFormatBoundary = -1;
    private static final Doc.Space SPACE = Doc.Space.make();

    public int actualSize(int position, int length) {
        int n2;
        Input.Token startToken = this.input.getPositionTokenMap().get(position);
        int start = startToken.getTok().getPosition();
        for (Input.Tok tok : startToken.getToksBefore()) {
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        Input.Token endToken = this.input.getPositionTokenMap().get(position + length - 1);
        int n3 = endToken.getTok().getPosition() + endToken.getTok().length();
        for (Input.Tok tok : endToken.getToksAfter()) {
            if (!tok.isComment()) continue;
            n2 = Math.max(n2, tok.getPosition() + tok.length());
        }
        return (int)(n2 - start);
    }

    public Integer actualStartColumn(int position) {
        Input.Token startToken = this.input.getPositionTokenMap().get(position);
        int start = startToken.getTok().getPosition();
        int line0 = this.input.getLineNumber(start);
        for (Input.Tok tok : startToken.getToksBefore()) {
            if (line0 != this.input.getLineNumber(tok.getPosition())) {
                return start;
            }
            if (!tok.isComment()) continue;
            start = Math.min(start, tok.getPosition());
        }
        return start;
    }

    public final void add(Op op) {
        if (op instanceof OpenOp) {
            ++this.depth;
        } else if (op instanceof CloseOp) {
            --this.depth;
            if (this.depth < 0) {
                throw new AssertionError();
            }
        }
        this.ops.add(op);
    }

    public final void addAll(List<Op> ops) {
        for (Op op : ops) {
            this.add(op);
        }
    }

    public OpsBuilder(Input input, Output output) {
        this.input = input;
        this.output = output;
    }

    public final Input getInput() {
        return this.input;
    }

    public int depth() {
        return this.depth;
    }

    public void checkClosed(int previous) {
        if (this.depth != previous) {
            throw new FormattingError(this.diagnostic(String.format("saw %d unclosed ops", this.depth)));
        }
    }

    public FormatterDiagnostic diagnostic(String message) {
        return this.input.createDiagnostic(this.inputPosition, message);
    }

    public final void sync(int inputPosition) {
        if (inputPosition > this.inputPosition) {
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            this.inputPosition = inputPosition;
            if (this.tokenI < tokensN && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                Input.Token token = (Input.Token)tokens.get(this.tokenI++);
                throw new FormattingError(this.diagnostic(String.format("did not generate token \"%s\"", token.getTok().getText())));
            }
        }
    }

    public final void drain() {
        int inputPosition = this.input.getText().length() + 1;
        if (inputPosition > this.inputPosition) {
            ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
            int tokensN = tokens.size();
            while (this.tokenI < tokensN && inputPosition > ((Input.Token)tokens.get(this.tokenI)).getTok().getPosition()) {
                Input.Token token = (Input.Token)tokens.get(this.tokenI++);
                this.add(Doc.Token.make(token, Doc.Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty()));
            }
        }
        this.inputPosition = inputPosition;
        this.checkClosed(0);
    }

    public final void open(Indent plusIndent) {
        this.add(OpenOp.make(plusIndent));
    }

    public final void close() {
        this.add(CloseOp.make());
    }

    public final Optional<String> peekToken() {
        return this.peekToken(0);
    }

    public final Optional<String> peekToken(int skip) {
        int idx = this.tokenI + skip;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        return idx < tokens.size() ? Optional.of(((Input.Token)tokens.get(idx)).getTok().getOriginalText()) : Optional.empty();
    }

    public ImmutableList<Input.Tok> peekTokens(int startPosition, Predicate<Input.Tok> predicate) {
        Input.Tok tok;
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        Preconditions.checkState(((Input.Token)tokens.get(this.tokenI)).getTok().getPosition() == startPosition, "Expected the current token to be at position %s, found: %s", startPosition, tokens.get(this.tokenI));
        ImmutableList.Builder result = ImmutableList.builder();
        for (int idx = this.tokenI; idx < tokens.size() && predicate.apply(tok = ((Input.Token)tokens.get(idx)).getTok()); ++idx) {
            result.add(tok);
        }
        return result.build();
    }

    public final void guessToken(String token) {
        this.token(token, Doc.Token.RealOrImaginary.IMAGINARY, ZERO, Optional.empty());
    }

    public final void token(String token, Doc.Token.RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
        ImmutableList<? extends Input.Token> tokens = this.input.getTokens();
        if (token.equals(this.peekToken().orElse(null))) {
            this.add(Doc.Token.make((Input.Token)tokens.get(this.tokenI++), Doc.Token.RealOrImaginary.REAL, plusIndentCommentsBefore, breakAndIndentTrailingComment));
        } else if (realOrImaginary.isReal()) {
            throw new FormattingError(this.diagnostic(String.format("expected token: '%s'; generated %s instead", this.peekToken().orElse(null), token)));
        }
    }

    public final void op(String op) {
        int opN = op.length();
        for (int i2 = 0; i2 < opN; ++i2) {
            this.token(op.substring(i2, i2 + 1), Doc.Token.RealOrImaginary.REAL, ZERO, Optional.empty());
        }
    }

    public final void space() {
        this.add(Doc.Space.make());
    }

    public final void breakOp() {
        this.breakOp(Doc.FillMode.UNIFIED, "", ZERO);
    }

    public final void breakOp(Indent plusIndent) {
        this.breakOp(Doc.FillMode.UNIFIED, "", plusIndent);
    }

    public final void breakToFill() {
        this.breakOp(Doc.FillMode.INDEPENDENT, "", ZERO);
    }

    public final void forcedBreak() {
        this.breakOp(Doc.FillMode.FORCED, "", ZERO);
    }

    public final void forcedBreak(Indent plusIndent) {
        this.breakOp(Doc.FillMode.FORCED, "", plusIndent);
    }

    public final void breakOp(String flat) {
        this.breakOp(Doc.FillMode.UNIFIED, flat, ZERO);
    }

    public final void breakToFill(String flat) {
        this.breakOp(Doc.FillMode.INDEPENDENT, flat, ZERO);
    }

    public final void breakOp(Doc.FillMode fillMode, String flat, Indent plusIndent) {
        this.breakOp(fillMode, flat, plusIndent, Optional.empty());
    }

    public final void breakOp(Doc.FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optionalTag) {
        this.add(Doc.Break.make(fillMode, flat, plusIndent, optionalTag));
    }

    public void markForPartialFormat() {
        if (this.lastPartialFormatBoundary == -1) {
            this.lastPartialFormatBoundary = this.tokenI;
            return;
        }
        if (this.tokenI == this.lastPartialFormatBoundary) {
            return;
        }
        Input.Token start = (Input.Token)this.input.getTokens().get(this.lastPartialFormatBoundary);
        Input.Token end = (Input.Token)this.input.getTokens().get(this.tokenI - 1);
        this.output.markForPartialFormat(start, end);
        this.lastPartialFormatBoundary = this.tokenI;
    }

    public final void blankLineWanted(BlankLineWanted wanted) {
        this.output.blankLine(OpsBuilder.getI((Input.Token)this.input.getTokens().get(this.tokenI)), wanted);
    }

    private static int getI(Input.Token token) {
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok.getIndex();
        }
        return token.getTok().getIndex();
    }

    public final ImmutableList<Op> build() {
        this.markForPartialFormat();
        ArrayListMultimap<Integer, Op> tokOps = ArrayListMultimap.create();
        int opsN = this.ops.size();
        for (int i2 = 0; i2 < opsN; ++i2) {
            int newlines;
            int j2;
            Op op = this.ops.get(i2);
            if (!(op instanceof Doc.Token)) continue;
            Doc.Token tokenOp = (Doc.Token)op;
            Input.Token token = tokenOp.getToken();
            for (j2 = i2; 0 < j2 && this.ops.get(j2 - 1) instanceof OpenOp; --j2) {
            }
            int k2 = i2;
            while (k2 + 1 < opsN && this.ops.get(k2 + 1) instanceof CloseOp) {
                ++k2;
            }
            if (tokenOp.realOrImaginary().isReal()) {
                boolean bl;
                newlines = 0;
                boolean space = false;
                boolean lastWasComment = false;
                boolean bl2 = false;
                for (Input.Tok tok : token.getToksBefore()) {
                    if (tok.isNewline()) {
                        ++newlines;
                        continue;
                    }
                    if (!tok.isComment()) continue;
                    tokOps.put(j2, Doc.Break.make(tok.isSlashSlashComment() ? Doc.FillMode.FORCED : Doc.FillMode.UNIFIED, "", tokenOp.getPlusIndentCommentsBefore()));
                    tokOps.putAll(j2, OpsBuilder.makeComment(tok));
                    space = tok.isSlashStarComment();
                    newlines = 0;
                    lastWasComment = true;
                    if (tok.isJavadocComment()) {
                        tokOps.put(j2, Doc.Break.makeForced());
                    }
                    bl = tok.isSlashSlashComment() || tok.isSlashStarComment() && !tok.isJavadocComment();
                }
                if (bl && newlines > 1) {
                    this.output.blankLine(token.getTok().getIndex(), BlankLineWanted.YES);
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put(j2, Doc.Break.makeForced());
                } else if (space) {
                    tokOps.put(j2, SPACE);
                }
                for (Input.Tok tok : token.getToksAfter()) {
                    boolean breakAfter;
                    if (!tok.isComment()) continue;
                    boolean bl3 = breakAfter = tok.isJavadocComment() || tok.isSlashStarComment() && tokenOp.breakAndIndentTrailingComment().isPresent();
                    if (breakAfter) {
                        tokOps.put(k2 + 1, Doc.Break.make(Doc.FillMode.FORCED, "", tokenOp.breakAndIndentTrailingComment().orElse(Indent.Const.ZERO)));
                    } else {
                        tokOps.put(k2 + 1, SPACE);
                    }
                    tokOps.putAll(k2 + 1, OpsBuilder.makeComment(tok));
                    if (!breakAfter) continue;
                    tokOps.put(k2 + 1, Doc.Break.make(Doc.FillMode.FORCED, "", ZERO));
                }
                continue;
            }
            newlines = 0;
            boolean lastWasComment = false;
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.isNewline()) {
                    ++newlines;
                } else if (tok.isComment()) {
                    newlines = 0;
                    lastWasComment = tok.isComment();
                }
                if (lastWasComment && newlines > 0) {
                    tokOps.put(j2, Doc.Break.makeForced());
                }
                tokOps.put(j2, Doc.Tok.make(tok));
            }
            for (Input.Tok tok : token.getToksAfter()) {
                tokOps.put(k2 + 1, Doc.Tok.make(tok));
            }
        }
        ImmutableList.Builder newOps = ImmutableList.builder();
        boolean afterForcedBreak = false;
        for (int i3 = 0; i3 < opsN; ++i3) {
            for (Op op : tokOps.get(i3)) {
                if (afterForcedBreak && op instanceof Doc.Space) continue;
                newOps.add(op);
                afterForcedBreak = OpsBuilder.isForcedBreak(op);
            }
            Op op = this.ops.get(i3);
            if (afterForcedBreak && (op instanceof Doc.Space || op instanceof Doc.Break && ((Doc.Break)op).getPlusIndent() == 0 && " ".equals(((Doc)((Object)op)).getFlat()))) continue;
            newOps.add(op);
            if (op instanceof OpenOp) continue;
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        for (Op op : tokOps.get(opsN)) {
            if (afterForcedBreak && op instanceof Doc.Space) continue;
            newOps.add(op);
            afterForcedBreak = OpsBuilder.isForcedBreak(op);
        }
        return newOps.build();
    }

    private static boolean isForcedBreak(Op op) {
        return op instanceof Doc.Break && ((Doc.Break)op).isForced();
    }

    private static List<Op> makeComment(Input.Tok comment) {
        return comment.isSlashStarComment() ? ImmutableList.of(Doc.Tok.make(comment)) : ImmutableList.of(Doc.Tok.make(comment), Doc.Break.makeForced());
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("input", this.input).add("ops", this.ops).add("output", this.output).add("tokenI", this.tokenI).add("inputPosition", this.inputPosition).toString();
    }

    public static abstract class BlankLineWanted {
        public static final BlankLineWanted YES = new SimpleBlankLine(Optional.of(true));
        public static final BlankLineWanted NO = new SimpleBlankLine(Optional.of(false));
        public static final BlankLineWanted PRESERVE = new SimpleBlankLine(Optional.empty());

        public abstract Optional<Boolean> wanted();

        public abstract BlankLineWanted merge(BlankLineWanted var1);

        public static BlankLineWanted conditional(Output.BreakTag breakTag) {
            return new ConditionalBlankLine(ImmutableList.of(breakTag));
        }

        private static final class ConditionalBlankLine
        extends BlankLineWanted {
            private final ImmutableList<Output.BreakTag> tags;

            ConditionalBlankLine(Iterable<Output.BreakTag> tags) {
                this.tags = ImmutableList.copyOf(tags);
            }

            @Override
            public Optional<Boolean> wanted() {
                for (Output.BreakTag tag : this.tags) {
                    if (!tag.wasBreakTaken()) continue;
                    return Optional.of(true);
                }
                return Optional.empty();
            }

            @Override
            public BlankLineWanted merge(BlankLineWanted other) {
                if (!(other instanceof ConditionalBlankLine)) {
                    return other;
                }
                return new ConditionalBlankLine(Iterables.concat(this.tags, ((ConditionalBlankLine)other).tags));
            }
        }

        private static final class SimpleBlankLine
        extends BlankLineWanted {
            private final Optional<Boolean> wanted;

            SimpleBlankLine(Optional<Boolean> wanted) {
                this.wanted = wanted;
            }

            @Override
            public Optional<Boolean> wanted() {
                return this.wanted;
            }

            @Override
            public BlankLineWanted merge(BlankLineWanted other) {
                return this;
            }
        }
    }
}

