/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InputOutput {
    private ImmutableList<String> lines = ImmutableList.of();
    protected static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers();
    protected final List<Range<Integer>> ranges = new ArrayList<Range<Integer>>();

    protected final void setLines(ImmutableList<String> lines) {
        this.lines = lines;
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    public final String getLine(int lineI) {
        return (String)this.lines.get(lineI);
    }

    private static void addToRanges(List<Range<Integer>> ranges, int i2, int k2) {
        while (ranges.size() <= i2) {
            ranges.add(EMPTY_RANGE);
        }
        Range<Integer> oldValue = ranges.get(i2);
        ranges.set(i2, Range.closedOpen(oldValue.isEmpty() ? k2 : oldValue.lowerEndpoint(), k2 + 1));
    }

    protected final void computeRanges(List<? extends Input.Tok> toks) {
        int lineI = 0;
        for (Input.Tok tok : toks) {
            String txt = tok.getOriginalText();
            int lineI0 = lineI;
            lineI += Newlines.count(txt);
            int k2 = tok.getIndex();
            if (k2 < 0) continue;
            for (int i2 = lineI0; i2 <= lineI; ++i2) {
                InputOutput.addToRanges(this.ranges, i2, k2);
            }
        }
    }

    public static Map<Integer, Range<Integer>> makeKToIJ(InputOutput put) {
        HashMap<Integer, Range<Integer>> map = new HashMap<Integer, Range<Integer>>();
        int ijN = put.getLineCount();
        for (int ij = 0; ij <= ijN; ++ij) {
            Range<Integer> range = put.getRanges(ij).canonical(INTEGERS);
            for (int k2 = range.lowerEndpoint().intValue(); k2 < range.upperEndpoint(); ++k2) {
                if (map.containsKey(k2)) {
                    map.put(k2, Range.closedOpen((Integer)((Range)map.get(k2)).lowerEndpoint(), ij + 1));
                    continue;
                }
                map.put(k2, Range.closedOpen(ij, ij + 1));
            }
        }
        return map;
    }

    public final Range<Integer> getRanges(int lineI) {
        return 0 <= lineI && lineI < this.ranges.size() ? this.ranges.get(lineI) : EMPTY_RANGE;
    }

    public String toString() {
        return "InputOutput{lines=" + this.lines + ", ranges=" + this.ranges + "}";
    }
}

