/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.MoreObjects;
import com.google.googlejavaformat.Output;

public abstract class Indent {
    abstract int eval();

    public static final class If
    extends Indent {
        private final Output.BreakTag condition;
        private final Indent thenIndent;
        private final Indent elseIndent;

        private If(Output.BreakTag condition, Indent thenIndent, Indent elseIndent) {
            this.condition = condition;
            this.thenIndent = thenIndent;
            this.elseIndent = elseIndent;
        }

        public static If make(Output.BreakTag condition, Indent thenIndent, Indent elseIndent) {
            return new If(condition, thenIndent, elseIndent);
        }

        @Override
        int eval() {
            return (this.condition.wasBreakTaken() ? this.thenIndent : this.elseIndent).eval();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("condition", this.condition).add("thenIndent", this.thenIndent).add("elseIndent", this.elseIndent).toString();
        }
    }

    public static final class Const
    extends Indent {
        private final int n;
        public static final Const ZERO = new Const(0);

        private Const(int n2) {
            this.n = n2;
        }

        public static Const make(int n2, int indentMultiplier) {
            return new Const(n2 * indentMultiplier);
        }

        @Override
        int eval() {
            return this.n;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("n", this.n).toString();
        }
    }
}

