/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.text;

import java.util.List;
import java.util.stream.Collectors;

final class StringUtils {
    public static String htmlEntites(String str) {
        return str.replace("<", "&lt;").replace(">", "&gt;");
    }

    public static String normalize(String str) {
        return StringUtils.htmlEntites(str).replace("\t", "    ");
    }

    public static List<String> wrapText(List<String> list, int columnWidth) {
        return list.stream().map(line -> StringUtils.wrapText(line, columnWidth)).collect(Collectors.toList());
    }

    public static String wrapText(String line, int columnWidth) {
        if (columnWidth < 0) {
            throw new IllegalArgumentException("columnWidth may not be less 0");
        }
        if (columnWidth == 0) {
            return line;
        }
        int length = line.length();
        int delimiter = "<br/>".length();
        int widthIndex = columnWidth;
        StringBuilder b2 = new StringBuilder(line);
        int count = 0;
        while (length > widthIndex) {
            int breakPoint = widthIndex + delimiter * count;
            if (Character.isHighSurrogate(b2.charAt(breakPoint - 1)) && Character.isLowSurrogate(b2.charAt(breakPoint)) && ++breakPoint == b2.length()) {
                breakPoint -= 2;
            }
            b2.insert(breakPoint, "<br/>");
            widthIndex += columnWidth;
            ++count;
        }
        return b2.toString();
    }

    private StringUtils() {
    }
}

