/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.myers;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithmFactory;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.patch.DeltaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

public class MeyersDiffWithLinearSpace<T>
implements DiffAlgorithmI<T> {
    private final BiPredicate<T, T> equalizer;

    public MeyersDiffWithLinearSpace() {
        this.equalizer = Object::equals;
    }

    public MeyersDiffWithLinearSpace(BiPredicate<T, T> equalizer) {
        Objects.requireNonNull(equalizer, "equalizer must not be null");
        this.equalizer = equalizer;
    }

    @Override
    public List<Change> computeDiff(List<T> source, List<T> target, DiffAlgorithmListener progress) {
        Objects.requireNonNull(source, "source list must not be null");
        Objects.requireNonNull(target, "target list must not be null");
        if (progress != null) {
            progress.diffStart();
        }
        DiffData data = new DiffData(source, target);
        int maxIdx = source.size() + target.size();
        this.buildScript(data, 0, source.size(), 0, target.size(), idx -> {
            if (progress != null) {
                progress.diffStep((int)idx, maxIdx);
            }
        });
        if (progress != null) {
            progress.diffEnd();
        }
        return data.script;
    }

    private void buildScript(DiffData data, int start1, int end1, int start2, int end2, Consumer<Integer> progress) {
        Snake middle;
        if (progress != null) {
            progress.accept((end1 - start1) / 2 + (end2 - start2) / 2);
        }
        if ((middle = this.getMiddleSnake(data, start1, end1, start2, end2)) == null || middle.start == end1 && middle.diag == end1 - end2 || middle.end == start1 && middle.diag == start1 - start2) {
            int i2 = start1;
            int j2 = start2;
            while (i2 < end1 || j2 < end2) {
                if (i2 < end1 && j2 < end2 && this.equalizer.test(data.source.get(i2), data.target.get(j2))) {
                    ++i2;
                    ++j2;
                    continue;
                }
                if (end1 - start1 > end2 - start2) {
                    if (data.script.isEmpty() || data.script.get((int)(data.script.size() - 1)).endOriginal != i2 || data.script.get((int)(data.script.size() - 1)).deltaType != DeltaType.DELETE) {
                        data.script.add(new Change(DeltaType.DELETE, i2, i2 + 1, j2, j2));
                    } else {
                        data.script.set(data.script.size() - 1, data.script.get(data.script.size() - 1).withEndOriginal(i2 + 1));
                    }
                    ++i2;
                    continue;
                }
                if (data.script.isEmpty() || data.script.get((int)(data.script.size() - 1)).endRevised != j2 || data.script.get((int)(data.script.size() - 1)).deltaType != DeltaType.INSERT) {
                    data.script.add(new Change(DeltaType.INSERT, i2, i2, j2, j2 + 1));
                } else {
                    data.script.set(data.script.size() - 1, data.script.get(data.script.size() - 1).withEndRevised(j2 + 1));
                }
                ++j2;
            }
        } else {
            this.buildScript(data, start1, middle.start, start2, middle.start - middle.diag, progress);
            this.buildScript(data, middle.end, end1, middle.end - middle.diag, end2, progress);
        }
    }

    private Snake getMiddleSnake(DiffData data, int start1, int end1, int start2, int end2) {
        int m3 = end1 - start1;
        int n2 = end2 - start2;
        if (m3 == 0 || n2 == 0) {
            return null;
        }
        int delta = m3 - n2;
        int sum = n2 + m3;
        int offset = (sum % 2 == 0 ? sum : sum + 1) / 2;
        data.vDown[1 + offset] = start1;
        data.vUp[1 + offset] = end1 + 1;
        for (int d2 = 0; d2 <= offset; ++d2) {
            int y;
            int x;
            int i2;
            int k2;
            for (k2 = -d2; k2 <= d2; k2 += 2) {
                i2 = k2 + offset;
                data.vDown[i2] = k2 == -d2 || k2 != d2 && data.vDown[i2 - 1] < data.vDown[i2 + 1] ? data.vDown[i2 + 1] : data.vDown[i2 - 1] + 1;
                x = data.vDown[i2];
                for (y = x - start1 + start2 - k2; x < end1 && y < end2 && this.equalizer.test(data.source.get(x), data.target.get(y)); ++y) {
                    data.vDown[i2] = ++x;
                }
                if (delta % 2 == 0 || delta - d2 > k2 || k2 > delta + d2 || data.vUp[i2 - delta] > data.vDown[i2]) continue;
                return this.buildSnake(data, data.vUp[i2 - delta], k2 + start1 - start2, end1, end2);
            }
            for (k2 = delta - d2; k2 <= delta + d2; k2 += 2) {
                i2 = k2 + offset - delta;
                data.vUp[i2] = k2 == delta - d2 || k2 != delta + d2 && data.vUp[i2 + 1] <= data.vUp[i2 - 1] ? data.vUp[i2 + 1] - 1 : data.vUp[i2 - 1];
                x = data.vUp[i2] - 1;
                for (y = x - start1 + start2 - k2; x >= start1 && y >= start2 && this.equalizer.test(data.source.get(x), data.target.get(y)); --y) {
                    data.vUp[i2] = x--;
                }
                if (delta % 2 != 0 || -d2 > k2 || k2 > d2 || data.vUp[i2] > data.vDown[i2 + delta]) continue;
                return this.buildSnake(data, data.vUp[i2], k2 + start1 - start2, end1, end2);
            }
        }
        throw new IllegalStateException("could not find a diff path");
    }

    private Snake buildSnake(DiffData data, int start, int diag, int end1, int end2) {
        int end;
        for (end = start; end - diag < end2 && end < end1 && this.equalizer.test(data.source.get(end), data.target.get(end - diag)); ++end) {
        }
        return new Snake(start, end, diag);
    }

    public static DiffAlgorithmFactory factory() {
        return new DiffAlgorithmFactory(){

            @Override
            public <T> DiffAlgorithmI<T> create() {
                return new MeyersDiffWithLinearSpace();
            }

            @Override
            public <T> DiffAlgorithmI<T> create(BiPredicate<T, T> equalizer) {
                return new MeyersDiffWithLinearSpace<T>(equalizer);
            }
        };
    }

    private class Snake {
        final int start;
        final int end;
        final int diag;

        public Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }
    }

    private class DiffData {
        final int size;
        final int[] vDown;
        final int[] vUp;
        final List<Change> script;
        final List<T> source;
        final List<T> target;

        public DiffData(List<T> source, List<T> target) {
            this.source = source;
            this.target = target;
            this.size = source.size() + target.size() + 2;
            this.vDown = new int[this.size];
            this.vUp = new int[this.size];
            this.script = new ArrayList<Change>();
        }
    }
}

