/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.algorithm.myers;

import com.github.difflib.algorithm.Change;
import com.github.difflib.algorithm.DiffAlgorithmFactory;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.myers.PathNode;
import com.github.difflib.patch.DeltaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public final class MeyersDiff<T>
implements DiffAlgorithmI<T> {
    private final BiPredicate<T, T> equalizer;

    public MeyersDiff() {
        this.equalizer = Object::equals;
    }

    public MeyersDiff(BiPredicate<T, T> equalizer) {
        Objects.requireNonNull(equalizer, "equalizer must not be null");
        this.equalizer = equalizer;
    }

    @Override
    public List<Change> computeDiff(List<T> source, List<T> target, DiffAlgorithmListener progress) {
        Objects.requireNonNull(source, "source list must not be null");
        Objects.requireNonNull(target, "target list must not be null");
        if (progress != null) {
            progress.diffStart();
        }
        PathNode path = this.buildPath(source, target, progress);
        List<Change> result = this.buildRevision(path, source, target);
        if (progress != null) {
            progress.diffEnd();
        }
        return result;
    }

    private PathNode buildPath(List<T> orig, List<T> rev, DiffAlgorithmListener progress) {
        Objects.requireNonNull(orig, "original sequence is null");
        Objects.requireNonNull(rev, "revised sequence is null");
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new PathNode(0, -1, true, true, null);
        for (int d2 = 0; d2 < MAX; ++d2) {
            if (progress != null) {
                progress.diffStep(d2, MAX);
            }
            for (int k2 = -d2; k2 <= d2; k2 += 2) {
                int j2;
                PathNode prev;
                int i2;
                int kmiddle = middle + k2;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                if (k2 == -d2 || k2 != d2 && diagonal[kminus].i < diagonal[kplus].i) {
                    i2 = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i2 = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new PathNode(i2, j2, false, false, prev);
                for (j2 = i2 - k2; i2 < N && j2 < M && this.equalizer.test(orig.get(i2), rev.get(j2)); ++i2, ++j2) {
                }
                if (i2 != node.i) {
                    node = new PathNode(i2, j2, true, false, node);
                }
                diagonal[kmiddle] = node;
                if (i2 < N || j2 < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d2 - 1] = null;
        }
        throw new IllegalStateException("could not find a diff path");
    }

    private List<Change> buildRevision(PathNode actualPath, List<T> orig, List<T> rev) {
        Objects.requireNonNull(actualPath, "path is null");
        Objects.requireNonNull(orig, "original sequence is null");
        Objects.requireNonNull(rev, "revised sequence is null");
        PathNode path = actualPath;
        ArrayList<Change> changes = new ArrayList<Change>();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i2 = path.i;
            int j2 = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            if (ianchor == i2 && janchor != j2) {
                changes.add(new Change(DeltaType.INSERT, ianchor, i2, janchor, j2));
            } else if (ianchor != i2 && janchor == j2) {
                changes.add(new Change(DeltaType.DELETE, ianchor, i2, janchor, j2));
            } else {
                changes.add(new Change(DeltaType.CHANGE, ianchor, i2, janchor, j2));
            }
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return changes;
    }

    public static DiffAlgorithmFactory factory() {
        return new DiffAlgorithmFactory(){

            @Override
            public <T> DiffAlgorithmI<T> create() {
                return new MeyersDiff();
            }

            @Override
            public <T> DiffAlgorithmI<T> create(BiPredicate<T, T> equalizer) {
                return new MeyersDiff<T>(equalizer);
            }
        };
    }
}

