/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib;

import com.github.difflib.algorithm.DiffAlgorithmFactory;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.algorithm.myers.MeyersDiff;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public final class DiffUtils {
    static DiffAlgorithmFactory DEFAULT_DIFF = MeyersDiff.factory();

    public static void withDefaultDiffAlgorithmFactory(DiffAlgorithmFactory factory) {
        DEFAULT_DIFF = factory;
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmListener progress) {
        return DiffUtils.diff(original, revised, DEFAULT_DIFF.create(), progress);
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised) {
        return DiffUtils.diff(original, revised, DEFAULT_DIFF.create(), null);
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, boolean includeEqualParts) {
        return DiffUtils.diff(original, revised, DEFAULT_DIFF.create(), null, includeEqualParts);
    }

    public static Patch<String> diff(String sourceText, String targetText, DiffAlgorithmListener progress) {
        return DiffUtils.diff(Arrays.asList(sourceText.split("\n")), Arrays.asList(targetText.split("\n")), progress);
    }

    public static <T> Patch<T> diff(List<T> source, List<T> target, BiPredicate<T, T> equalizer) {
        if (equalizer != null) {
            return DiffUtils.diff(source, target, DEFAULT_DIFF.create(equalizer));
        }
        return DiffUtils.diff(source, target, new MeyersDiff());
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmI<T> algorithm, DiffAlgorithmListener progress) {
        return DiffUtils.diff(original, revised, algorithm, progress, false);
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmI<T> algorithm, DiffAlgorithmListener progress, boolean includeEqualParts) {
        Objects.requireNonNull(original, "original must not be null");
        Objects.requireNonNull(revised, "revised must not be null");
        Objects.requireNonNull(algorithm, "algorithm must not be null");
        return Patch.generate(original, revised, algorithm.computeDiff(original, revised, progress), includeEqualParts);
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithmI<T> algorithm) {
        return DiffUtils.diff(original, revised, algorithm, null);
    }

    public static Patch<String> diffInline(String original, String revised) {
        Character character;
        int n2;
        ArrayList<String> origList = new ArrayList<String>();
        ArrayList<String> revList = new ArrayList<String>();
        char[] cArray = original.toCharArray();
        int n3 = cArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            character = Character.valueOf(cArray[n2]);
            origList.add(character.toString());
        }
        cArray = revised.toCharArray();
        n3 = cArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            character = Character.valueOf(cArray[n2]);
            revList.add(character.toString());
        }
        Patch<String> patch = DiffUtils.diff(origList, revList);
        for (AbstractDelta delta : patch.getDeltas()) {
            delta.getSource().setLines(DiffUtils.compressLines(delta.getSource().getLines(), ""));
            delta.getTarget().setLines(DiffUtils.compressLines(delta.getTarget().getLines(), ""));
        }
        return patch;
    }

    private static List<String> compressLines(List<String> lines, String delimiter) {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(String.join((CharSequence)delimiter, lines));
    }

    public static <T> List<T> patch(List<T> original, Patch<T> patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static <T> List<T> unpatch(List<T> revised, Patch<T> patch) {
        return patch.restore(revised);
    }

    private DiffUtils() {
    }
}

