/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Color;

public class HSLColor {
    private final Color rgb;
    private final float[] hsl;
    private final float alpha;

    public HSLColor(Color rgb) {
        this.rgb = rgb;
        this.hsl = HSLColor.fromRGB(rgb);
        this.alpha = (float)rgb.getAlpha() / 255.0f;
    }

    public HSLColor(float h2, float s2, float l2) {
        this(h2, s2, l2, 1.0f);
    }

    public HSLColor(float h2, float s2, float l2, float alpha) {
        this.hsl = new float[]{h2, s2, l2};
        this.alpha = alpha;
        this.rgb = HSLColor.toRGB(this.hsl, alpha);
    }

    public HSLColor(float[] hsl) {
        this(hsl, 1.0f);
    }

    public HSLColor(float[] hsl, float alpha) {
        this.hsl = hsl;
        this.alpha = alpha;
        this.rgb = HSLColor.toRGB(hsl, alpha);
    }

    public Color adjustHue(float degrees2) {
        return HSLColor.toRGB(degrees2, this.hsl[1], this.hsl[2], this.alpha);
    }

    public Color adjustLuminance(float percent) {
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], percent, this.alpha);
    }

    public Color adjustSaturation(float percent) {
        return HSLColor.toRGB(this.hsl[0], percent, this.hsl[2], this.alpha);
    }

    public Color adjustShade(float percent) {
        float multiplier = (100.0f - percent) / 100.0f;
        float l2 = Math.max(0.0f, this.hsl[2] * multiplier);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], l2, this.alpha);
    }

    public Color adjustTone(float percent) {
        float multiplier = (100.0f + percent) / 100.0f;
        float l2 = Math.min(100.0f, this.hsl[2] * multiplier);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], l2, this.alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getComplementary() {
        float hue = (this.hsl[0] + 180.0f) % 360.0f;
        return HSLColor.toRGB(hue, this.hsl[1], this.hsl[2]);
    }

    public float getHue() {
        return this.hsl[0];
    }

    public float[] getHSL() {
        return this.hsl;
    }

    public float getLuminance() {
        return this.hsl[2];
    }

    public Color getRGB() {
        return this.rgb;
    }

    public float getSaturation() {
        return this.hsl[1];
    }

    public String toString() {
        String toString = "HSLColor[h=" + this.hsl[0] + ",s=" + this.hsl[1] + ",l=" + this.hsl[2] + ",alpha=" + this.alpha + "]";
        return toString;
    }

    public static float[] fromRGB(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        float r2 = rgb[0];
        float g2 = rgb[1];
        float b2 = rgb[2];
        float min2 = Math.min(r2, Math.min(g2, b2));
        float max = Math.max(r2, Math.max(g2, b2));
        float h2 = 0.0f;
        if (max == min2) {
            h2 = 0.0f;
        } else if (max == r2) {
            h2 = (60.0f * (g2 - b2) / (max - min2) + 360.0f) % 360.0f;
        } else if (max == g2) {
            h2 = 60.0f * (b2 - r2) / (max - min2) + 120.0f;
        } else if (max == b2) {
            h2 = 60.0f * (r2 - g2) / (max - min2) + 240.0f;
        }
        float l2 = (max + min2) / 2.0f;
        float s2 = max == min2 ? 0.0f : (l2 <= 0.5f ? (max - min2) / (max + min2) : (max - min2) / (2.0f - max - min2));
        return new float[]{h2, s2 * 100.0f, l2 * 100.0f};
    }

    public static Color toRGB(float[] hsl) {
        return HSLColor.toRGB(hsl, 1.0f);
    }

    public static Color toRGB(float[] hsl, float alpha) {
        return HSLColor.toRGB(hsl[0], hsl[1], hsl[2], alpha);
    }

    public static Color toRGB(float h2, float s2, float l2) {
        return HSLColor.toRGB(h2, s2, l2, 1.0f);
    }

    public static Color toRGB(float h2, float s2, float l2, float alpha) {
        if (s2 < 0.0f || s2 > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l2 < 0.0f || l2 > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha < 0.0f || alpha > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h2 %= 360.0f;
        float q2 = (double)(l2 /= 100.0f) < 0.5 ? l2 * (1.0f + s2) : l2 + (s2 /= 100.0f) - s2 * l2;
        float p2 = 2.0f * l2 - q2;
        float r2 = Math.max(0.0f, HSLColor.HueToRGB(p2, q2, (h2 /= 360.0f) + 0.33333334f));
        float g2 = Math.max(0.0f, HSLColor.HueToRGB(p2, q2, h2));
        float b2 = Math.max(0.0f, HSLColor.HueToRGB(p2, q2, h2 - 0.33333334f));
        r2 = Math.min(r2, 1.0f);
        g2 = Math.min(g2, 1.0f);
        b2 = Math.min(b2, 1.0f);
        return new Color(r2, g2, b2, alpha);
    }

    private static float HueToRGB(float p2, float q2, float h2) {
        if (h2 < 0.0f) {
            h2 += 1.0f;
        }
        if (h2 > 1.0f) {
            h2 -= 1.0f;
        }
        if (6.0f * h2 < 1.0f) {
            return p2 + (q2 - p2) * 6.0f * h2;
        }
        if (2.0f * h2 < 1.0f) {
            return q2;
        }
        if (3.0f * h2 < 2.0f) {
            return p2 + (q2 - p2) * 6.0f * (0.6666667f - h2);
        }
        return p2;
    }
}

