/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class FlatToolBarBorder
extends FlatMarginBorder {
    private static final int DOT_COUNT = 4;
    private static final int DOT_SIZE = 2;
    private static final int GRIP_SIZE = 6;
    protected Color gripColor = UIManager.getColor("ToolBar.gripColor");

    public FlatToolBarBorder() {
        super(UIManager.getInsets("ToolBar.borderMargins"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
        if (c2 instanceof JToolBar && ((JToolBar)c2).isFloatable()) {
            Graphics2D g22 = (Graphics2D)g2.create();
            try {
                FlatUIUtils.setRenderingHints(g22);
                Color color = FlatToolBarBorder.getStyleFromToolBarUI(c2, ui -> ui.gripColor);
                g22.setColor(color != null ? color : this.gripColor);
                this.paintGrip(c2, g22, x, y, width, height);
            }
            finally {
                g22.dispose();
            }
        }
    }

    protected void paintGrip(Component c2, Graphics g2, int x, int y, int width, int height) {
        Rectangle r2 = this.calculateGripBounds(c2, x, y, width, height);
        FlatUIUtils.paintGrip(g2, r2.x, r2.y, r2.width, r2.height, ((JToolBar)c2).getOrientation() == 1, 4, 2, 2, false);
    }

    protected Rectangle calculateGripBounds(Component c2, int x, int y, int width, int height) {
        Insets insets = super.getBorderInsets(c2, new Insets(0, 0, 0, 0));
        Rectangle r2 = FlatUIUtils.subtractInsets(new Rectangle(x, y, width, height), insets);
        int gripSize = UIScale.scale(6);
        if (((JToolBar)c2).getOrientation() == 0) {
            if (!c2.getComponentOrientation().isLeftToRight()) {
                r2.x = r2.x + r2.width - gripSize;
            }
            r2.width = gripSize;
        } else {
            r2.height = gripSize;
        }
        return r2;
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets m3 = FlatToolBarBorder.getStyleFromToolBarUI(c2, ui -> ui.borderMargins);
        if (m3 != null) {
            int t = this.top;
            int l2 = this.left;
            int b2 = this.bottom;
            int r2 = this.right;
            this.top = m3.top;
            this.left = m3.left;
            this.bottom = m3.bottom;
            this.right = m3.right;
            insets = super.getBorderInsets(c2, insets);
            this.top = t;
            this.left = l2;
            this.bottom = b2;
            this.right = r2;
        } else {
            insets = super.getBorderInsets(c2, insets);
        }
        if (c2 instanceof JToolBar && ((JToolBar)c2).isFloatable()) {
            int gripInset = UIScale.scale(6);
            if (((JToolBar)c2).getOrientation() == 0) {
                if (c2.getComponentOrientation().isLeftToRight()) {
                    insets.left += gripInset;
                } else {
                    insets.right += gripInset;
                }
            } else {
                insets.top += gripInset;
            }
        }
        return insets;
    }

    static <T> T getStyleFromToolBarUI(Component c2, Function<FlatToolBarUI, T> f2) {
        ToolBarUI ui;
        if (c2 instanceof JToolBar && (ui = ((JToolBar)c2).getUI()) instanceof FlatToolBarUI) {
            return f2.apply((FlatToolBarUI)ui);
        }
        return null;
    }
}

