/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatCheckBoxIcon;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class FlatRadioButtonUI
extends BasicRadioButtonUI
implements FlatStylingSupport.StyleableUI {
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    private Color defaultBackground;
    private final boolean shared;
    private boolean iconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private static final Insets tempInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.canUseSharedUI(c2) && !FlatUIUtils.needsLightAWTPeer(c2) ? FlatUIUtils.createSharedUI(FlatRadioButtonUI.class, () -> new FlatRadioButtonUI(true)) : new FlatRadioButtonUI(false);
    }

    protected FlatRadioButtonUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c2) {
        if (FlatUIUtils.needsLightAWTPeer(c2)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c2));
        } else {
            this.installUIImpl(c2);
        }
    }

    private void installUIImpl(JComponent c2) {
        super.installUI(c2);
        if (FlatUIUtils.isAWTPeer(c2)) {
            AWTPeerMouseExitedFix.install(c2);
        }
        this.installStyle((AbstractButton)c2);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        if (FlatUIUtils.isAWTPeer(c2)) {
            AWTPeerMouseExitedFix.uninstall(c2);
        }
    }

    @Override
    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        if (!this.defaults_initialized) {
            String prefix = this.getPropertyPrefix();
            this.iconTextGap = FlatUIUtils.getUIInt(prefix + "iconTextGap", 4);
            this.disabledText = UIManager.getColor(prefix + "disabledText");
            this.defaultBackground = UIManager.getColor(prefix + "background");
            this.iconShared = true;
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(b2, "opaque", false);
        LookAndFeel.installProperty(b2, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install(b2, null);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(b2);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new FlatRadioButtonListener(b2);
    }

    protected void propertyChange(AbstractButton b2, PropertyChangeEvent e2) {
        switch (e2.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(b2)) {
                    b2.updateUI();
                } else {
                    this.installStyle(b2);
                }
                b2.revalidate();
                b2.repaint();
            }
        }
    }

    protected void installStyle(AbstractButton b2) {
        try {
            this.applyStyle(b2, FlatStylingSupport.getResolvedStyle(b2, this.getStyleType()));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    String getStyleType() {
        return "RadioButton";
    }

    protected void applyStyle(AbstractButton b2, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(b2, (String)key, value));
    }

    protected Object applyStyleProperty(AbstractButton b2, String key, Object value) {
        if (key.startsWith("icon.")) {
            if (!(this.icon instanceof FlatCheckBoxIcon)) {
                return new FlatStylingSupport.UnknownStyleException(key);
            }
            if (this.iconShared) {
                this.icon = FlatStylingSupport.cloneIcon(this.icon);
                this.iconShared = false;
            }
            key = key.substring("icon.".length());
            return ((FlatCheckBoxIcon)this.icon).applyStyleProperty(key, value);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, b2, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        Map<String, Class<?>> infos = FlatStylingSupport.getAnnotatedStyleableInfos(this);
        if (this.icon instanceof FlatCheckBoxIcon) {
            for (Map.Entry<String, Class<?>> e2 : ((FlatCheckBoxIcon)this.icon).getStyleableInfos().entrySet()) {
                infos.put("icon.".concat(e2.getKey()), e2.getValue());
            }
        }
        return infos;
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        if (key.startsWith("icon.")) {
            return this.icon instanceof FlatCheckBoxIcon ? ((FlatCheckBoxIcon)this.icon).getStyleableValue(key.substring("icon.".length())) : null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        Dimension size = super.getPreferredSize(c2);
        if (size == null) {
            return null;
        }
        int focusWidth = this.getIconFocusWidth(c2);
        if (focusWidth > 0) {
            Insets insets = c2.getInsets(tempInsets);
            size.width += Math.max(focusWidth - insets.left, 0) + Math.max(focusWidth - insets.right, 0);
            size.height += Math.max(focusWidth - insets.top, 0) + Math.max(focusWidth - insets.bottom, 0);
        }
        return size;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        int focusWidth;
        if (!c2.isOpaque() && ((AbstractButton)c2).isContentAreaFilled() && !Objects.equals(c2.getBackground(), this.getDefaultBackground(c2))) {
            g2.setColor(c2.getBackground());
            g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
        }
        if ((focusWidth = this.getIconFocusWidth(c2)) > 0) {
            int leftOrRightInset;
            boolean ltr = c2.getComponentOrientation().isLeftToRight();
            Insets insets = c2.getInsets(tempInsets);
            int n2 = leftOrRightInset = ltr ? insets.left : insets.right;
            if (focusWidth > leftOrRightInset) {
                int offset = focusWidth - leftOrRightInset;
                if (!ltr) {
                    offset = -offset;
                }
                g2.translate(offset, 0);
                super.paint(g2, c2);
                g2.translate(-offset, 0);
                return;
            }
        }
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(g2, c2), c2);
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        FlatButtonUI.paintText(g2, b2, textRect, text, b2.isEnabled() ? b2.getForeground() : this.disabledText);
    }

    private Color getDefaultBackground(JComponent c2) {
        Container parent = c2.getParent();
        return parent instanceof CellRendererPane && parent.getParent() != null ? parent.getParent().getBackground() : this.defaultBackground;
    }

    private int getIconFocusWidth(JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        Icon icon = b2.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        return icon instanceof FlatCheckBoxIcon ? Math.round(UIScale.scale(((FlatCheckBoxIcon)icon).getFocusWidth())) : 0;
    }

    private static class AWTPeerMouseExitedFix
    extends MouseAdapter
    implements PropertyChangeListener {
        private final JComponent button;

        static void install(JComponent button) {
            AWTPeerMouseExitedFix l2 = new AWTPeerMouseExitedFix(button);
            button.addPropertyChangeListener("ancestor", l2);
            Container parent = button.getParent();
            if (parent != null) {
                parent.addMouseListener(l2);
            }
        }

        static void uninstall(JComponent button) {
            for (PropertyChangeListener l2 : button.getPropertyChangeListeners("ancestor")) {
                if (!(l2 instanceof AWTPeerMouseExitedFix)) continue;
                button.removePropertyChangeListener("ancestor", l2);
                Container parent = button.getParent();
                if (parent == null) break;
                parent.removeMouseListener((AWTPeerMouseExitedFix)l2);
                break;
            }
        }

        AWTPeerMouseExitedFix(JComponent button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            if (e2.getOldValue() instanceof Component) {
                ((Component)e2.getOldValue()).removeMouseListener(this);
            }
            if (e2.getNewValue() instanceof Component) {
                ((Component)e2.getNewValue()).removeMouseListener(this);
                ((Component)e2.getNewValue()).addMouseListener(this);
            }
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.button.dispatchEvent(SwingUtilities.convertMouseEvent(e2.getComponent(), e2, this.button));
        }
    }

    protected class FlatRadioButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatRadioButtonListener(AbstractButton b2) {
            super(b2);
            this.b = b2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            super.propertyChange(e2);
            FlatRadioButtonUI.this.propertyChange(this.b, e2);
        }
    }
}

