/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatListUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ListUI;

public class FlatListCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("List.showCellFocusIndicator");
    private Component c;

    protected FlatListCellBorder() {
        super(UIManager.getInsets("List.cellMargins"), UIManager.getColor("List.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        Insets m3 = FlatListCellBorder.getStyleFromListUI(c2, ui -> ui.cellMargins);
        if (m3 != null) {
            return FlatListCellBorder.scaleInsets(c2, insets, m3.top, m3.left, m3.bottom, m3.right);
        }
        return super.getBorderInsets(c2, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatListCellBorder.getStyleFromListUI(this.c, ui -> ui.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
        this.c = c2;
        super.paintBorder(c2, g2, x, y, width, height);
        this.c = null;
    }

    static <T> T getStyleFromListUI(Component c2, Function<FlatListUI, T> f2) {
        ListUI ui;
        JList list = (JList)SwingUtilities.getAncestorOfClass(JList.class, c2);
        if (list != null && (ui = list.getUI()) instanceof FlatListUI) {
            return f2.apply((FlatListUI)ui);
        }
        return null;
    }

    public static class Selected
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
            boolean showCellFocusIndicator;
            Boolean b2 = Selected.getStyleFromListUI(c2, ui -> ui.showCellFocusIndicator);
            boolean bl = showCellFocusIndicator = b2 != null ? b2 : this.showCellFocusIndicator;
            if (!showCellFocusIndicator) {
                return;
            }
            JList list = (JList)SwingUtilities.getAncestorOfClass(JList.class, c2);
            if (list != null && list.getMinSelectionIndex() == list.getMaxSelectionIndex()) {
                return;
            }
            super.paintBorder(c2, g2, x, y, width, height);
        }
    }

    public static class Focused
    extends FlatListCellBorder {
    }

    public static class Default
    extends FlatListCellBorder {
        @Override
        public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
        }
    }
}

