/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatComboBoxUI;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatSpinnerUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicBorders;

public class FlatBorder
extends BasicBorders.MarginBorder
implements FlatStylingSupport.StyleableBorder {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float innerOutlineWidth = FlatUIUtils.getUIFloat("Component.innerOutlineWidth", 0.0f);
    @FlatStylingSupport.Styleable
    protected float borderWidth = FlatUIUtils.getUIFloat("Component.borderWidth", 1.0f);
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("Component.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("Component.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("Component.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorBorderColor = UIManager.getColor("Component.error.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color errorFocusedBorderColor = UIManager.getColor("Component.error.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningBorderColor = UIManager.getColor("Component.warning.borderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color warningFocusedBorderColor = UIManager.getColor("Component.warning.focusedBorderColor");
    @FlatStylingSupport.Styleable(dot=true)
    protected Color customBorderColor = UIManager.getColor("Component.custom.borderColor");
    @FlatStylingSupport.Styleable
    protected String outline;
    @FlatStylingSupport.Styleable
    protected Color outlineColor;
    @FlatStylingSupport.Styleable
    protected Color outlineFocusedColor;

    @Override
    public Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g2, int x, int y, int width, int height) {
        Graphics2D g22 = (Graphics2D)g2.create();
        try {
            FlatUIUtils.setRenderingHints(g22);
            float focusWidth = UIScale.scale((float)this.getFocusWidth(c2));
            float focusInnerWidth = 0.0f;
            float borderWidth = UIScale.scale(this.getBorderWidth(c2));
            float arc = UIScale.scale((float)this.getArc(c2));
            Color outlineColor = this.getOutlineColor(c2);
            Color focusColor = null;
            if (outlineColor != null || this.isFocused(c2)) {
                float innerWidth;
                float f2 = !this.isCellEditor(c2) && !(c2 instanceof JScrollPane) ? (outlineColor != null ? this.innerOutlineWidth : this.getInnerFocusWidth(c2)) : (innerWidth = 0.0f);
                if (focusWidth > 0.0f || innerWidth > 0.0f) {
                    focusColor = outlineColor != null ? outlineColor : this.getFocusColor(c2);
                    focusInnerWidth = borderWidth + UIScale.scale(innerWidth);
                }
            }
            Color borderColor = outlineColor != null ? outlineColor : this.getBorderColor(c2);
            FlatUIUtils.paintOutlinedComponent(g22, x, y, width, height, focusWidth, 1.0f, focusInnerWidth, borderWidth, arc, focusColor, borderColor, null);
        }
        finally {
            g22.dispose();
        }
    }

    protected Color getOutlineColor(Component c2) {
        if (!(c2 instanceof JComponent)) {
            return null;
        }
        Color[] outline = ((JComponent)c2).getClientProperty("JComponent.outline");
        if (outline == null) {
            outline = this.outline;
        }
        if (outline == null) {
            if (this.outlineColor != null && this.outlineFocusedColor != null) {
                outline = new Color[]{this.outlineFocusedColor, this.outlineColor};
            } else if (this.outlineColor != null) {
                outline = this.outlineColor;
            } else if (this.outlineFocusedColor != null) {
                outline = this.outlineFocusedColor;
            }
        }
        if (outline instanceof String) {
            switch ((String)outline) {
                case "error": {
                    return this.isFocused(c2) ? this.errorFocusedBorderColor : this.errorBorderColor;
                }
                case "warning": {
                    return this.isFocused(c2) ? this.warningFocusedBorderColor : this.warningBorderColor;
                }
            }
        } else {
            if (outline instanceof Color) {
                Color color = (Color)outline;
                if (!this.isFocused(c2) && this.customBorderColor instanceof DerivedColor) {
                    color = ((DerivedColor)this.customBorderColor).derive(color);
                }
                return color;
            }
            if (outline instanceof Color[] && ((Color[])outline).length >= 2) {
                return ((Color[])outline)[this.isFocused(c2) ? 0 : 1];
            }
        }
        return null;
    }

    protected Color getFocusColor(Component c2) {
        return this.focusColor;
    }

    protected Paint getBorderColor(Component c2) {
        return this.isEnabled(c2) ? (this.isFocused(c2) ? this.focusedBorderColor : this.borderColor) : this.disabledBorderColor;
    }

    protected boolean isEnabled(Component c2) {
        if (c2 instanceof JScrollPane) {
            Component view;
            JViewport viewport = ((JScrollPane)c2).getViewport();
            Component component = view = viewport != null ? viewport.getView() : null;
            if (view != null && !this.isEnabled(view)) {
                return false;
            }
        }
        return c2.isEnabled();
    }

    protected boolean isFocused(Component c2) {
        if (c2 instanceof JScrollPane) {
            return FlatScrollPaneUI.isPermanentFocusOwner((JScrollPane)c2);
        }
        if (c2 instanceof JComboBox) {
            return FlatComboBoxUI.isPermanentFocusOwner((JComboBox)c2);
        }
        if (c2 instanceof JSpinner) {
            return FlatSpinnerUI.isPermanentFocusOwner((JSpinner)c2);
        }
        return FlatUIUtils.isPermanentFocusOwner(c2);
    }

    protected boolean isCellEditor(Component c2) {
        return FlatUIUtils.isCellEditor(c2);
    }

    @Override
    public Insets getBorderInsets(Component c2, Insets insets) {
        float focusWidth = UIScale.scale((float)this.getFocusWidth(c2));
        int ow = Math.round(focusWidth + UIScale.scale((float)this.getLineWidth(c2)));
        insets = super.getBorderInsets(c2, insets);
        insets.top = UIScale.scale(insets.top) + ow;
        insets.left = UIScale.scale(insets.left) + ow;
        insets.bottom = UIScale.scale(insets.bottom) + ow;
        insets.right = UIScale.scale(insets.right) + ow;
        if (this.isCellEditor(c2)) {
            insets.bottom = 0;
            insets.top = 0;
            if (c2.getComponentOrientation().isLeftToRight()) {
                insets.right = 0;
            } else {
                insets.left = 0;
            }
        }
        return insets;
    }

    protected int getFocusWidth(Component c2) {
        if (this.isCellEditor(c2)) {
            return 0;
        }
        return this.focusWidth;
    }

    protected float getInnerFocusWidth(Component c2) {
        return this.innerFocusWidth;
    }

    protected int getLineWidth(Component c2) {
        return 1;
    }

    protected float getBorderWidth(Component c2) {
        return this.borderWidth;
    }

    protected int getArc(Component c2) {
        return 0;
    }
}

