/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LazyRandom;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class RandomBasedGenerator
extends NoArgGenerator {
    protected static Random _sharedRandom = null;
    protected final Random _random;
    protected final boolean _secureRandom;

    public RandomBasedGenerator(Random rnd) {
        if (rnd == null) {
            rnd = LazyRandom.sharedSecureRandom();
            this._secureRandom = true;
        } else {
            this._secureRandom = rnd instanceof SecureRandom;
        }
        this._random = rnd;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.RANDOM_BASED;
    }

    @Override
    public UUID generate() {
        long r2;
        long r1;
        if (this._secureRandom) {
            byte[] buffer = new byte[16];
            this._random.nextBytes(buffer);
            r1 = RandomBasedGenerator._toLong(buffer, 0);
            r2 = RandomBasedGenerator._toLong(buffer, 1);
        } else {
            r1 = this._random.nextLong();
            r2 = this._random.nextLong();
        }
        return UUIDUtil.constructUUID(UUIDType.RANDOM_BASED, r1, r2);
    }

    protected static final long _toLong(byte[] buffer, int offset) {
        long l1 = RandomBasedGenerator._toInt(buffer, offset);
        long l2 = RandomBasedGenerator._toInt(buffer, offset + 4);
        long l3 = (l1 << 32) + (l2 << 32 >>> 32);
        return l3;
    }

    private static final long _toInt(byte[] buffer, int offset) {
        return (buffer[offset] << 24) + ((buffer[++offset] & 0xFF) << 16) + ((buffer[++offset] & 0xFF) << 8) + (buffer[++offset] & 0xFF);
    }
}

