/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid;

import com.fasterxml.uuid.EgressInterfaceFinder;
import java.io.Serializable;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;

public class EthernetAddress
implements Serializable,
Cloneable,
Comparable<EthernetAddress> {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX_CHARS = "0123456789abcdefABCDEF".toCharArray();
    protected static Random _rnd;
    protected final long _address;
    private volatile String _asString;

    public EthernetAddress(String addrStr) throws NumberFormatException {
        int len = addrStr.length();
        long addr = 0L;
        int i2 = 0;
        for (int j2 = 0; j2 < 6; ++j2) {
            int value;
            if (i2 >= len) {
                if (j2 == 5) {
                    addr <<= 8;
                    break;
                }
                throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
            }
            char c2 = addrStr.charAt(i2);
            ++i2;
            if (c2 == ':') {
                value = 0;
            } else {
                if (c2 >= '0' && c2 <= '9') {
                    value = c2 - 48;
                } else if (c2 >= 'a' && c2 <= 'f') {
                    value = c2 - 97 + 10;
                } else if (c2 >= 'A' && c2 <= 'F') {
                    value = c2 - 65 + 10;
                } else {
                    throw new NumberFormatException("Non-hex character '" + c2 + "'");
                }
                if (i2 < len) {
                    c2 = addrStr.charAt(i2);
                    ++i2;
                    if (c2 != ':') {
                        value <<= 4;
                        if (c2 >= '0' && c2 <= '9') {
                            value |= c2 - 48;
                        } else if (c2 >= 'a' && c2 <= 'f') {
                            value |= c2 - 97 + 10;
                        } else if (c2 >= 'A' && c2 <= 'F') {
                            value |= c2 - 65 + 10;
                        } else {
                            throw new NumberFormatException("Non-hex character '" + c2 + "'");
                        }
                    }
                }
            }
            addr = addr << 8 | (long)value;
            if (c2 == ':') continue;
            if (i2 < len) {
                if (addrStr.charAt(i2) != ':') {
                    throw new NumberFormatException("Expected ':', got ('" + addrStr.charAt(i2) + "')");
                }
                ++i2;
                continue;
            }
            if (j2 >= 5) continue;
            throw new NumberFormatException("Incomplete ethernet address (missing one or more digits");
        }
        this._address = addr;
    }

    public EthernetAddress(byte[] addr) throws NumberFormatException {
        if (addr.length != 6) {
            throw new NumberFormatException("Ethernet address has to consist of 6 bytes");
        }
        long l2 = addr[0] & 0xFF;
        for (int i2 = 1; i2 < 6; ++i2) {
            l2 = l2 << 8 | (long)(addr[i2] & 0xFF);
        }
        this._address = l2;
    }

    public EthernetAddress(long addr) {
        this._address = addr;
    }

    public Object clone() {
        return new EthernetAddress(this._address);
    }

    public static EthernetAddress valueOf(byte[] addr) throws NumberFormatException {
        return new EthernetAddress(addr);
    }

    public static EthernetAddress valueOf(int[] addr) throws NumberFormatException {
        byte[] bAddr = new byte[addr.length];
        for (int i2 = 0; i2 < addr.length; ++i2) {
            bAddr[i2] = (byte)addr[i2];
        }
        return new EthernetAddress(bAddr);
    }

    public static EthernetAddress valueOf(String addrStr) throws NumberFormatException {
        return new EthernetAddress(addrStr);
    }

    public static EthernetAddress valueOf(long addr) {
        return new EthernetAddress(addr);
    }

    public static EthernetAddress fromInterface() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                EthernetAddress addr;
                NetworkInterface nint = en.nextElement();
                if (nint.isLoopback() || (addr = EthernetAddress.fromInterface(nint)) == null) continue;
                return addr;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static EthernetAddress fromInterface(NetworkInterface nint) {
        if (nint != null) {
            try {
                byte[] data = nint.getHardwareAddress();
                if (data != null && data.length == 6) {
                    return new EthernetAddress(data);
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return null;
    }

    public static EthernetAddress fromPreferredInterface() {
        EthernetAddress egressIfAddress = EthernetAddress.fromEgressInterface();
        if (egressIfAddress == null) {
            return EthernetAddress.fromInterface();
        }
        return egressIfAddress;
    }

    public static EthernetAddress fromEgressInterface() {
        try {
            EgressInterfaceFinder finder = new EgressInterfaceFinder();
            return EthernetAddress.fromInterface(finder.egressInterface());
        }
        catch (EgressInterfaceFinder.EgressResolutionException e2) {
            return null;
        }
    }

    public static EthernetAddress constructMulticastAddress() {
        return EthernetAddress.constructMulticastAddress(EthernetAddress._randomNumberGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EthernetAddress constructMulticastAddress(Random rnd) {
        byte[] dummy = new byte[6];
        Random random = rnd;
        synchronized (random) {
            rnd.nextBytes(dummy);
        }
        dummy[0] = (byte)(dummy[0] | 1);
        return new EthernetAddress(dummy);
    }

    public byte[] asByteArray() {
        byte[] result = new byte[6];
        this.toByteArray(result);
        return result;
    }

    public byte[] toByteArray() {
        return this.asByteArray();
    }

    public void toByteArray(byte[] array) {
        if (array.length < 6) {
            throw new IllegalArgumentException("Too small array, need to have space for 6 bytes");
        }
        this.toByteArray(array, 0);
    }

    public void toByteArray(byte[] array, int pos) {
        if (pos < 0 || pos + 6 > array.length) {
            throw new IllegalArgumentException("Illegal offset (" + pos + "), need room for 6 bytes");
        }
        int i2 = (int)(this._address >> 32);
        array[pos++] = (byte)(i2 >> 8);
        array[pos++] = (byte)i2;
        i2 = (int)this._address;
        array[pos++] = (byte)(i2 >> 24);
        array[pos++] = (byte)(i2 >> 16);
        array[pos++] = (byte)(i2 >> 8);
        array[pos] = (byte)i2;
    }

    public long toLong() {
        return this._address;
    }

    public boolean isMulticastAddress() {
        return ((int)(this._address >> 40) & 1) != 0;
    }

    public boolean isLocallyAdministeredAddress() {
        return ((int)(this._address >> 40) & 2) != 0;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() != this.getClass()) {
            return false;
        }
        return ((EthernetAddress)o2)._address == this._address;
    }

    public int hashCode() {
        return (int)this._address ^ (int)(this._address >>> 32);
    }

    @Override
    public int compareTo(EthernetAddress other) {
        long l2 = this._address - other._address;
        if (l2 < 0L) {
            return -1;
        }
        return l2 == 0L ? 0 : 1;
    }

    public String toString() {
        String str = this._asString;
        if (str != null) {
            return str;
        }
        StringBuilder b2 = new StringBuilder(17);
        int i1 = (int)(this._address >> 32);
        int i2 = (int)this._address;
        this._appendHex(b2, i1 >> 8);
        b2.append(':');
        this._appendHex(b2, i1);
        b2.append(':');
        this._appendHex(b2, i2 >> 24);
        b2.append(':');
        this._appendHex(b2, i2 >> 16);
        b2.append(':');
        this._appendHex(b2, i2 >> 8);
        b2.append(':');
        this._appendHex(b2, i2);
        this._asString = str = b2.toString();
        return str;
    }

    protected static synchronized Random _randomNumberGenerator() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
        return _rnd;
    }

    private final void _appendHex(StringBuilder sb, int hex) {
        sb.append(HEX_CHARS[hex >> 4 & 0xF]);
        sb.append(HEX_CHARS[hex & 0xF]);
    }
}

