/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.table;

import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.util.table.TableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    protected int minus = 0;
    int[] indexes;
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    Class type;
    TableModel data;
    protected int lastSortedColumn = -1;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    public void resetMinus() {
        this.minus = this.model != null ? this.model.getRowCount() : 0;
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        this.type = this.model.getColumnClass(column);
        this.data = this.model;
        Object o1 = this.data.getValueAt(row1, column);
        Object o2 = this.data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (this.type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)this.data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)this.data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (this.type == Time.class) {
            Calendar n1 = Calendar.getInstance();
            Calendar n2 = Calendar.getInstance();
            Time dx = (Time)this.data.getValueAt(row1, column);
            n1.setTime(dx);
            dx = (Time)this.data.getValueAt(row2, column);
            n2.setTime(dx);
            if (n1.before(n2)) {
                return -1;
            }
            if (n1.after(n2)) {
                return 1;
            }
            return 0;
        }
        if (this.type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)this.data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)this.data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (this.type == GregorianCalendar.class) {
            GregorianCalendar d2;
            GregorianCalendar n2;
            GregorianCalendar d1 = (GregorianCalendar)this.data.getValueAt(row1, column);
            GregorianCalendar n1 = d1;
            if (n1.before(n2 = (d2 = (GregorianCalendar)this.data.getValueAt(row2, column)))) {
                return -1;
            }
            if (n1.after(n2)) {
                return 1;
            }
            return 0;
        }
        if (this.type == String.class) {
            String s22;
            String s1 = this.data.getValueAt(row1, column).toString();
            int result = s1.compareTo(s22 = this.data.getValueAt(row2, column).toString());
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (this.type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)this.data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)this.data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        if (this.type == ObjectID.class) {
            if (ObjectIDPredicate.instance.execute(this.data.getValueAt(row1, column), this.data.getValueAt(row2, column))) {
                return -1;
            }
            return 1;
        }
        if (this.type.isAssignableFrom(Comparable.class)) {
            Object v22;
            Object v1 = this.data.getValueAt(row1, column);
            int result = ((Comparable)v1).compareTo(v22 = this.data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        Object v1 = this.data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = this.data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public void reallocateIndexes() {
        this.resetMinus();
        if (this.model == null) {
            return;
        }
        int rowCount = this.model.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void filtertableChanged(TableModelEvent e2) {
        super.tableChanged(e2);
    }

    @Override
    public void tableChanged(TableModelEvent e2) {
        this.reallocateIndexes();
        super.tableChanged(e2);
    }

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            this.reallocateIndexes();
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        if (this.model.getRowCount() > 0) {
            this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.minus);
        }
    }

    public void n2sort() {
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int j2 = i2 + 1; j2 < this.getRowCount(); ++j2) {
                if (this.compare(this.indexes[i2], this.indexes[j2]) != -1) continue;
                this.swap(i2, j2);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p2 = low;
        int q2 = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i2 = low; i2 < high; ++i2) {
                to[i2] = from[i2];
            }
            return;
        }
        for (int i3 = low; i3 < high; ++i3) {
            to[i3] = q2 >= high || p2 < middle && this.compare(from[p2], from[q2]) <= 0 ? from[p2++] : from[q2++];
        }
    }

    public void swap(int i2, int j2) {
        int tmp = this.indexes[i2];
        this.indexes[i2] = this.indexes[j2];
        this.indexes[j2] = tmp;
    }

    public int getRowInTableModel(int aRow) {
        this.checkModel();
        return this.indexes[aRow];
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        Object o2 = this.model.getValueAt(this.indexes[aRow], aColumn);
        return o2;
    }

    @Override
    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
        this.fireTableCellUpdated(aRow, aColumn);
    }

    @Override
    public int getRowCount() {
        return this.model == null ? 0 : this.minus;
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public int getLastSortedColumn() {
        return this.lastSortedColumn;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e2.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e2.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e2.getModifiers() & 1;
                    boolean ascending = shiftPressed == 0;
                    sorter.sortByColumn(column, ascending);
                    TableSorter.this.lastSortedColumn = column;
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }
}

