/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class Vista
implements Pageable {
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private Printable mPainter;
    private PageFormat mFormat;

    public Vista(float width, float height, Printable painter, PageFormat format) {
        this.setPrintable(painter);
        this.setPageFormat(format);
        this.setSize(width, height);
    }

    protected Vista() {
    }

    protected void setPrintable(Printable painter) {
        this.mPainter = painter;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    protected void setSize(float width, float height) {
        this.mNumPagesX = (int)(((double)width + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
        this.mNumPagesY = (int)(((double)height + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    protected PageFormat getPageFormat() {
        return this.mFormat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        double originX = (double)(pageIndex % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double originY = (double)(pageIndex / this.mNumPagesX) * this.mFormat.getImageableHeight();
        Point2D.Double origin = new Point2D.Double(originX, originY);
        return new TranslatedPrintable(this.mPainter, origin);
    }

    public static final class TranslatedPrintable
    implements Printable {
        private Printable mPainter;
        private Point2D mOrigin;

        public TranslatedPrintable(Printable painter, Point2D origin) {
            this.mPainter = painter;
            this.mOrigin = origin;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(-this.mOrigin.getX(), -this.mOrigin.getY());
            this.mPainter.print(g2, pageFormat, 1);
            return 0;
        }
    }
}

