/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util.gui;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class StringField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private boolean upperCase = false;
    private String pattern = "";
    private boolean allowPattern = false;
    private boolean firstLowerCase = false;
    private boolean firstUpperCase = false;

    public StringField() {
    }

    public StringField(String pattern, boolean patternAllowed, int columns, boolean upperCase) {
        super(columns);
        this.setPattern(pattern);
        this.setAllowPattern(patternAllowed);
        this.upperCase = upperCase;
    }

    @Override
    protected Document createDefaultModel() {
        return new TextDocument();
    }

    public void setUpperCase(boolean newUpperCase) {
        this.upperCase = newUpperCase;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setPattern(String newPattern) {
        this.pattern = newPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setAllowPattern(boolean newAllowPattern) {
        this.allowPattern = newAllowPattern;
    }

    public boolean isAllowPattern() {
        return this.allowPattern;
    }

    public void setFirstLowerCase(boolean newFirstLowerCase) {
        this.firstLowerCase = newFirstLowerCase;
    }

    public boolean isFirstLowerCase() {
        return this.firstLowerCase;
    }

    @Override
    public String getText() {
        Object s2 = super.getText();
        if (this.firstLowerCase && ((String)s2).length() > 0) {
            s2 = Character.toLowerCase(((String)s2).charAt(0)) + ((String)s2).substring(1);
        }
        return s2;
    }

    public void setFirstUpperCase(boolean newFirstUpperCase) {
        this.firstUpperCase = newFirstUpperCase;
    }

    public boolean isFirstUpperCase() {
        return this.firstUpperCase;
    }

    protected class TextDocument
    extends PlainDocument {
        protected TextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j2 = 0;
            for (int i2 = 0; i2 < result.length; ++i2) {
                char c2;
                char c3 = c2 = StringField.this.isUpperCase() ? Character.toUpperCase(source[i2]) : source[i2];
                if (StringField.this.firstLowerCase && j2 == 0 && offs == 0) {
                    if (!Character.isLetter(c2)) {
                        StringField.this.toolkit.beep();
                        continue;
                    }
                    c2 = Character.toLowerCase(c2);
                } else if (StringField.this.firstUpperCase && j2 == 0 && offs == 0) {
                    if (!Character.isLetter(c2)) {
                        StringField.this.toolkit.beep();
                        continue;
                    }
                    c2 = Character.toUpperCase(c2);
                }
                if (StringField.this.isAllowPattern() && StringField.this.pattern.indexOf(c2) >= 0 || !StringField.this.isAllowPattern() && StringField.this.pattern.indexOf(c2) < 0) {
                    result[j2++] = c2;
                    continue;
                }
                StringField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j2), a2);
        }
    }
}

