/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.BaseConfig;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;

public class UserConfigFile
extends BaseConfig {
    private volatile byte[] masterKey;

    public UserConfigFile() {
        super(false);
    }

    public UserConfigFile(boolean allowZeroLengthValues) {
        this();
        this.allowZeroLengthValues = allowZeroLengthValues;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public void setMasterKey(byte[] masterKey) {
        this.masterKey = masterKey;
    }

    public Font getFont(String key, Font def) {
        int style;
        int size;
        String family = this.get(key, null);
        String sizeString = this.get(key + "size", null);
        String styleString = this.get(key + "style", null);
        if (family == null || sizeString == null || styleString == null) {
            return def;
        }
        try {
            size = Integer.parseInt(sizeString);
            style = Integer.parseInt(styleString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        return new Font(family, style, size);
    }

    public void setFont(String key, Font f2) {
        this.put(key, f2.getFamily());
        this.put(key + "size", "" + f2.getSize());
        this.put(key + "style", "" + f2.getStyle());
    }

    public void write() {
        File f2 = new File(this.configFile);
        if (f2.exists()) {
            if (f2.isFile() && f2.canWrite()) {
                this.saveAs(f2);
            }
        } else {
            this.saveAs(f2);
        }
    }

    protected void saveAs(File f2) {
        try {
            FileOutputStream os = new FileOutputStream(f2);
            this.properties.store(os, "Config File of: " + System.getProperty("user.name"));
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

