/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Regex {
    private Pattern pattern;

    public void compile(String regex) throws ParseException {
        this.pattern = Pattern.compile("(?s)(.*)" + regex + "(.*)");
    }

    public void compileWithExactMatch(String regex) throws ParseException {
        this.pattern = Pattern.compile("(?s)" + regex);
    }

    public static String quote(String s2) {
        return Pattern.quote(s2);
    }

    public boolean match(String s2) {
        if (this.pattern == null) {
            return false;
        }
        return this.pattern.matcher(s2).matches();
    }

    public List<int[]> allMatchPositions(String s2) {
        return this.allMatchPositions(s2, 0);
    }

    public List<int[]> allMatchPositions(String s2, int maxMatches) {
        ArrayList<int[]> matchList = new ArrayList<int[]>();
        Matcher matcher = this.pattern.matcher(s2);
        int n2 = 0;
        while (matcher.find() && (maxMatches <= 0 || n2++ < maxMatches)) {
            int suffixLength = 0;
            int prefixLength = 0;
            int groupCount = matcher.groupCount();
            if (groupCount > 1) {
                String prefixGroup = matcher.group(1);
                String suffixGroup = matcher.group(groupCount);
                suffixLength = suffixGroup != null ? suffixGroup.length() : 0;
                prefixLength = prefixGroup != null ? prefixGroup.length() : 0;
            }
            matchList.add(new int[]{matcher.start() + prefixLength, matcher.end() - suffixLength});
        }
        return matchList;
    }

    public static boolean isRegex(String s2) {
        try {
            Pattern.compile(s2);
        }
        catch (PatternSyntaxException rex) {
            return false;
        }
        return true;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern.pattern();
    }
}

