/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.PropertyEncrypter;
import com.agentpp.util.UserConfigFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.snmp4j.smi.OctetString;

public class EncryptedUserConfigFile
extends UserConfigFile {
    private static final String MAGIC_ENCRYPT_STRING = "\n..E";
    private static final String VERSION_ID = "01|";
    private PropertyEncrypter encrypter;

    public EncryptedUserConfigFile(PropertyEncrypter encrypter) {
        this.encrypter = encrypter;
    }

    public EncryptedUserConfigFile(PropertyEncrypter encrypter, boolean allowZeroLengthValues) {
        super(allowZeroLengthValues);
        this.encrypter = encrypter;
    }

    @Override
    protected void load(InputStream is) throws IOException {
        InputStream dis = is;
        if (!is.markSupported()) {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            dis = new ByteArrayInputStream(buffer.toByteArray());
        }
        is.mark(8);
        byte[] magicString = new byte[MAGIC_ENCRYPT_STRING.length()];
        int read = dis.read(magicString, 0, magicString.length);
        if (read < MAGIC_ENCRYPT_STRING.length() || !Arrays.equals(MAGIC_ENCRYPT_STRING.getBytes(), magicString)) {
            dis.reset();
            super.load(dis);
        } else {
            int nRead;
            if (this.getMasterKey() == null || this.getMasterKey().length < 8) {
                throw new IOException("Configuration file is encrypted, but master password not given or shorter than 8 characters!");
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] payload = buffer.toByteArray();
            int posSaltStart = MAGIC_ENCRYPT_STRING.length() + 1 + VERSION_ID.length();
            int posSaltEnd = EncryptedUserConfigFile.bytesIndexOf(payload, (byte)10, MAGIC_ENCRYPT_STRING.length() + 1);
            if (posSaltEnd < posSaltStart) {
                throw new IOException("Wrong encryption format, checksum hash not found");
            }
            byte[] salt = Arrays.copyOfRange(payload, posSaltStart, posSaltEnd);
            byte[] cryptedProperties = Arrays.copyOfRange(payload, posSaltEnd + 1, payload.length);
            byte[] properties = this.encrypter.decrypt(cryptedProperties, new OctetString(salt));
            super.load(new ByteArrayInputStream(properties));
        }
    }

    private static int bytesIndexOf(byte[] bytes, byte searchByte, int startPos) {
        for (int i2 = startPos; i2 < bytes.length; ++i2) {
            if (bytes[i2] != searchByte) continue;
            return i2;
        }
        return -1;
    }

    @Override
    protected void saveAs(File f2) {
        if (this.getMasterKey() != null && this.getMasterKey().length >= 8) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                this.properties.store(buffer, "Config File of: " + System.getProperty("user.name"));
                OctetString salt = new OctetString();
                byte[] propertyBytes = this.encrypter.encrypt(buffer.toByteArray(), salt, true);
                FileOutputStream fos = new FileOutputStream(f2);
                fos.write(MAGIC_ENCRYPT_STRING.getBytes());
                fos.write(VERSION_ID.getBytes());
                fos.write(salt.toHexString().getBytes());
                fos.write(10);
                fos.write(propertyBytes);
                fos.flush();
                fos.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            super.saveAs(f2);
        }
    }
}

