/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.util;

import com.agentpp.util.ConfigFile;
import com.agentpp.util.UserConfigEvent;
import com.agentpp.util.UserConfigListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BaseConfig
extends ConfigFile {
    protected transient boolean allowZeroLengthValues = false;
    private transient List listeners;
    private transient boolean disableChangeEvents = false;

    public BaseConfig(boolean init) {
        super(init);
    }

    public void setConfigName(String s2) {
        super.setConfigFile(System.getProperty("user.home") + System.getProperty("file.separator") + s2);
    }

    public synchronized void addChangeListener(UserConfigListener l2) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(l2);
    }

    public synchronized boolean removeChangeListener(UserConfigListener l2) {
        if (this.listeners != null) {
            return this.listeners.remove(l2);
        }
        return false;
    }

    public void setDisableChangeEvents(boolean disableChangeEvents) {
        this.disableChangeEvents = disableChangeEvents;
    }

    public void put(String key, String s2) {
        Object oldValue = this.properties.remove(key);
        if (s2 != null) {
            this.properties.put(key, s2);
        }
        if (this.listeners != null && (s2 != null && !s2.equals(oldValue) || oldValue != null && s2 == null)) {
            this.fireConfigChangedEvent(new UserConfigEvent(this, key, oldValue, s2));
        }
    }

    public String get(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    public Vector<String> getArray(String key) {
        String s2;
        Vector<String> v = new Vector<String>();
        int i2 = 0;
        while ((s2 = this.get(key + i2++, null)) != null) {
            if (this.allowZeroLengthValues || s2.length() > 0) {
                v.add(s2);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public Map<String, String> getRawMap(String key) {
        String k2;
        String s2;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i2 = 0;
        while ((s2 = this.get(k2 = key + i2++, null)) != null) {
            if (!this.allowZeroLengthValues && s2.length() <= 0) continue;
            map.put(k2, s2);
        }
        return map;
    }

    public Map<String, String> getStringMap(String key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map<String, String> rawMap = this.getRawMap(key);
        for (String entry : rawMap.values()) {
            int equalsSignPos = entry.indexOf(61);
            if (equalsSignPos <= 0 || entry.length() <= equalsSignPos) continue;
            String k2 = entry.substring(0, equalsSignPos);
            String v = entry.substring(equalsSignPos + 1);
            map.put(k2, v);
        }
        return map;
    }

    public void putStringMap(String key, Map<String, String> map) {
        this.removeAll(key);
        int i2 = 0;
        for (Map.Entry<String, String> mapping : map.entrySet()) {
            this.put(key + i2, mapping.getKey() + "=" + mapping.getValue());
        }
    }

    public String[] getStringArray(String key, String[] def) {
        String s2 = null;
        ArrayList<String> v = new ArrayList<String>();
        int i2 = 0;
        while ((s2 = this.get(key + i2++, null)) != null) {
            if (this.allowZeroLengthValues || s2.length() > 0) {
                v.add(s2);
                continue;
            }
            v.add(null);
        }
        if (v.size() == 0) {
            return def;
        }
        return v.toArray(new String[0]);
    }

    public Vector<String> getArray(String key, int size) {
        String s2 = null;
        Vector<String> v = new Vector<String>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            s2 = this.get(key + i2, null);
            if (this.allowZeroLengthValues || s2 != null && s2.length() > 0) {
                v.add(s2);
                continue;
            }
            v.add(null);
        }
        return v;
    }

    public void putArray(String key, List<?> v) {
        int i2 = 0;
        while (this.get(key + i2, null) != null) {
            this.remove(key + i2);
            ++i2;
        }
        if (v != null) {
            for (i2 = 0; i2 < v.size(); ++i2) {
                if (v.get(i2) != null) {
                    this.put(key + i2, v.get(i2).toString());
                    continue;
                }
                this.remove(key + i2);
            }
            this.remove(key + i2);
        }
    }

    public final void putTable(String[] keys, List<String[]> values) {
        for (int i2 = 0; i2 < keys.length; ++i2) {
            String key = keys[i2];
            ArrayList<String> vlist = new ArrayList<String>(values.size());
            for (String[] row : values) {
                vlist.add(row[i2]);
            }
            this.putArray(key, vlist);
        }
    }

    public List<String[]> getTable(String[] keys) {
        ArrayList<String[]> v = new ArrayList<String[]>();
        ArrayList<Vector<String>> cols = new ArrayList<Vector<String>>(keys.length);
        int max = 0;
        for (String key : keys) {
            cols.add(this.getArray(key));
            int cur = ((List)cols.get(cols.size() - 1)).size();
            if (cur <= max) continue;
            max = cur;
        }
        for (int i2 = 0; i2 < max; ++i2) {
            String[] row = new String[keys.length];
            for (int k2 = 0; k2 < keys.length; ++k2) {
                if (((List)cols.get(k2)).size() <= i2) continue;
                row[k2] = (String)((List)cols.get(k2)).get(i2);
            }
            v.add(row);
        }
        return v;
    }

    public void putInteger(String key, int value) {
        this.put(key, "" + value);
    }

    public int getInteger(String key, int defValue) {
        try {
            return Integer.parseInt(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putLong(String key, long value) {
        this.put(key, "" + value);
    }

    public long getLong(String key, long defValue) {
        try {
            return Long.parseLong(this.get(key, "" + defValue));
        }
        catch (NumberFormatException nfex) {
            return defValue;
        }
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, "" + value);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return Boolean.parseBoolean(this.get(key, "" + defValue));
    }

    public void putEnumeration(String key, Enumeration e2) {
        int i2 = 0;
        while (e2.hasMoreElements()) {
            this.put(key + i2, e2.nextElement().toString());
            ++i2;
        }
        this.remove(key + i2);
    }

    public void remove(String key) {
        Object oldValue = this.properties.remove(key);
        if (this.listeners != null) {
            this.fireConfigChangedEvent(new UserConfigEvent(this, key, oldValue, null));
        }
    }

    public void removeAll(String keyPrefix) {
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            this.remove(key);
        }
    }

    private synchronized void fireConfigChangedEvent(UserConfigEvent event) {
        if (this.listeners != null && !this.disableChangeEvents) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((UserConfigListener)it.next()).configChanged(event);
            }
        }
    }

    public Color getColor(String key, Color defaultColor) {
        String color = this.get(key, null);
        if (color != null) {
            return new Color(Integer.parseInt(color), true);
        }
        return defaultColor;
    }

    public void putColor(String key, Color color) {
        if (color != null) {
            this.putInteger(key, color.getRGB());
        } else {
            this.remove(key);
        }
    }
}

