/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.NewRowException;
import com.agentpp.snmp.ReportException;
import com.agentpp.snmp.SetActiveFailedException;
import com.agentpp.snmp.SetAuthException;
import com.agentpp.snmp.SetPrivException;
import com.agentpp.snmp.SnmpErrorException;
import com.agentpp.snmp.TimeoutException;
import com.agentpp.snmp.UnderConstructionException;
import com.agentpp.snmp.UserProfile;
import com.agentpp.snmp.UsmError;
import com.agentpp.snmp.UsmException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.KeyAgreement;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.dh.DHOperations;
import org.snmp4j.security.dh.DHParameters;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.PDUFactory;

public class Operations {
    public static final int SUCCESS = 0;
    public static final int ERROR_OFFLINE = 1;
    public static final int ERROR_INTERNAL = -1;
    public static final OID usmNoAuthProtocol = new OID("1.3.6.1.6.3.10.1.1.1");
    public static final OID usmNoPrivProtocol = new OID("1.3.6.1.6.3.10.1.2.1");
    public static final OID usmUserAuthProtocol = new OID("1.3.6.1.6.3.15.1.2.2.1.5");
    public static final OID usmUserPrivProtocol = new OID("1.3.6.1.6.3.15.1.2.2.1.8");
    public static final OID usmSpinLock = new OID("1.3.6.1.6.3.15.1.2.1.0");
    public static final OID usmUserPublic = new OID("1.3.6.1.6.3.15.1.2.2.1.11");
    public static final OID usmUserAuthKeyChange = new OID("1.3.6.1.6.3.15.1.2.2.1.6");
    public static final OID usmUserPrivKeyChange = new OID("1.3.6.1.6.3.15.1.2.2.1.9");
    public static final OID usmUserStatus = new OID("1.3.6.1.6.3.15.1.2.2.1.13");
    public static final OID usmUserCloneFrom = new OID("1.3.6.1.6.3.15.1.2.2.1.4");
    public static final OID usmUserSecurityName = new OID("1.3.6.1.6.3.15.1.2.2.1.3");
    public static final OID vacmGroupName = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1, 3});
    public static final OID vacmSecurityToGroupStorageType = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1, 4});
    public static final OID vacmSecurityToGroupRowStatus = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1, 5});
    public static final OID usmDHParameters = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 1, 1, 0});
    public static final OID usmUserDHUserAuthKeyChange = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 1, 2, 1, 1});
    public static final OID usmUserDHUserPrivKeyChange = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 1, 2, 1, 3});

    public static byte[] setAuthentication(Snmp session, GenTarget target, byte[] engineID, OID protocol, OID index, OctetString newPassword) throws SetAuthException, TimeoutException, ReportException, IOException {
        Target t = target.getTarget();
        if (engineID == null) {
            throw new SetAuthException("Cannot determine SNMP engine ID");
        }
        if (index == null) {
            index = Operations.getRowIndex(engineID, target.getUser().getUser().getSecurityName());
        }
        if (protocol == null) {
            PDU pdu = target.makePDU();
            pdu.setType(-93);
            VariableBinding vb = new VariableBinding();
            OID authProtocol = new OID(usmUserAuthProtocol.getValue());
            authProtocol.append(index);
            vb.setOid(authProtocol);
            vb.setVariable(usmNoAuthProtocol);
            ResponseEvent responseEvent = session.send(pdu, t);
            PDU response = responseEvent.getResponse();
            Operations.checkForReport(response);
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Cannot set authentication protocol to 'no authentication': " + response.getErrorStatusText());
            }
            return new byte[0];
        }
        PDU spinPDU = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[]{new VariableBinding(), new VariableBinding()};
        vbs[0].setOid(usmSpinLock);
        OID publicOID = new OID(usmUserPublic.getValue());
        publicOID.append(index);
        vbs[1].setOid(publicOID);
        spinPDU.addAll(vbs);
        spinPDU.setType(-96);
        ResponseEvent responseEvent = session.send(spinPDU, t);
        PDU response = responseEvent.getResponse();
        Operations.checkForReport(response);
        if (response.getErrorStatus() != 0 || response.size() != 2) {
            throw new SetAuthException("Cannot get usmSpinLock value: " + response.getErrorStatusText());
        }
        Variable lockVal = response.get(0).getVariable();
        Variable pubVal = response.get(1).getVariable();
        if (pubVal.getSyntax() != 4 || lockVal.getSyntax() < 0) {
            throw new SetAuthException("Set authentication failed: usmSpinLock.0 or usmUserPublic." + index.toString() + " does not exists.");
        }
        OctetString pub = (OctetString)pubVal;
        byte[] n2 = new byte[8];
        AuthenticationProtocol authProtocol = SecurityProtocols.getInstance().getAuthenticationProtocol(protocol);
        OctetString oldPassword = target.getUser().getUser().getAuthenticationPassphrase();
        byte[] oldKey = oldPassword.getValue();
        byte[] newKey = authProtocol.passwordToKey(newPassword, engineID);
        OctetString deltaKey = Operations.computeDeltaKey(authProtocol, oldKey, newKey, pub, n2, authProtocol.getDigestLength());
        PDU pdu = target.makePDU();
        vbs = new VariableBinding[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            vbs[i2] = new VariableBinding();
        }
        vbs[0].setOid(usmSpinLock);
        vbs[0].setVariable(lockVal);
        OID keyChange = new OID(usmUserAuthKeyChange.getValue());
        keyChange.append(index);
        vbs[1].setOid(keyChange);
        vbs[1].setVariable(deltaKey);
        vbs[2].setOid(publicOID);
        vbs[2].setVariable(new OctetString(n2));
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            pdu = target.makePDU();
            vbs[2].setVariable(new Null());
            pdu.add(vbs[2]);
            pdu.setType(-96);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new SetAuthException("Timeout on getting usmPublic." + index.toString() + " after failed key change!");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Cannot get usmPublic." + index.toString() + " after failed key change: " + response.getErrorStatusText());
            }
            OctetString cp = (OctetString)response.get(0).getVariable();
            if (!n2.equals(cp.getValue())) {
                throw new SetAuthException("Key change failed, may be due to a simultaneous key update by another manager!");
            }
        } else {
            if (response.getErrorStatus() == 12) {
                return oldKey;
            }
            if (response.getErrorStatus() != 0) {
                throw new SetAuthException("Setting new authentication password failed: " + response.getErrorStatusText());
            }
        }
        return newKey;
    }

    private static OctetString computeDeltaKey(AuthenticationProtocol authProtocol, byte[] oldKey, byte[] newKey, OctetString pub, byte[] pubKey, int keyLength) {
        byte[] rand = new byte[keyLength];
        Random r2 = new Random();
        r2.nextBytes(rand);
        if (newKey.length > keyLength) {
            newKey = Operations.truncateKey(keyLength, newKey);
        }
        if (oldKey.length > keyLength) {
            oldKey = Operations.truncateKey(keyLength, oldKey);
        }
        byte[] delta = authProtocol.changeDelta(oldKey, newKey, rand);
        Random rn = new Random();
        do {
            rn.nextBytes(pubKey);
        } while (Arrays.equals(pubKey, pub.getValue()));
        return new OctetString(delta);
    }

    private static byte[] truncateKey(int keyLength, byte[] newKey) {
        byte[] truncatedNewKey = new byte[keyLength];
        System.arraycopy(newKey, 0, truncatedNewKey, 0, keyLength);
        newKey = truncatedNewKey;
        return newKey;
    }

    public static byte[] setPrivacy(Snmp session, GenTarget target, byte[] engineID, OID authProtocol, OID privProtocol, OID index, OctetString newPassword) throws SetPrivException, IOException {
        Target t = target.getTarget(session);
        if (engineID == null) {
            throw new SetPrivException("Cannot determine SNMP engine ID");
        }
        if (index == null) {
            index = Operations.getRowIndex(engineID, target.getUser().getUser().getSecurityName());
        }
        if (privProtocol == null) {
            PDU pdu = target.makePDU();
            pdu.setType(-93);
            VariableBinding vb = new VariableBinding();
            OID privOID = new OID(usmUserPrivProtocol.getValue());
            privOID.append(index);
            vb.setOid(privOID);
            vb.setVariable(usmNoPrivProtocol);
            ResponseEvent responseEvent = session.send(pdu, t);
            PDU response = responseEvent.getResponse();
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Cannot set privacy protocol to 'no privacy': " + response.getErrorStatusText());
            }
            return new byte[0];
        }
        PDU spinPDU = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[2];
        vbs[0] = new VariableBinding();
        vbs[0].setOid(usmSpinLock);
        OID publicOID = new OID(usmUserPublic.getValue());
        publicOID.append(index);
        vbs[1] = new VariableBinding();
        vbs[1].setOid(publicOID);
        spinPDU.addAll(vbs);
        spinPDU.setType(-96);
        ResponseEvent responseEvent = session.send(spinPDU, t);
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new SetPrivException("Timeout on getting usmSpinLock.0");
        }
        if (response.getErrorStatus() != 0 || response.size() != 2) {
            if (response.getType() == -88) {
                throw new SetPrivException("Cannot get usmSpinLock value - received REPORT PDU instead: " + response);
            }
            throw new SetPrivException("Cannot get usmSpinLock value: " + response.getErrorStatusText());
        }
        Variable lockVal = response.get(0).getVariable();
        Variable pubVal = response.get(1).getVariable();
        if (pubVal.getSyntax() != 4 || lockVal.getSyntax() < 0) {
            throw new SetPrivException("Set privacy failed: usmSpinLock.0 or usmUserPublic." + index.toString() + " does not exists.");
        }
        OctetString pub = (OctetString)pubVal;
        byte[] n2 = new byte[8];
        AuthenticationProtocol a2 = session.getUSM().getSecurityProtocols().getAuthenticationProtocol(authProtocol);
        PrivacyProtocol p2 = session.getUSM().getSecurityProtocols().getPrivacyProtocol(privProtocol);
        OctetString oldPassword = target.getUser().getUser().getPrivacyPassphrase();
        byte[] newKey = session.getUSM().getSecurityProtocols().passwordToKey(privProtocol, a2.getID(), newPassword, engineID);
        byte[] oldKey = oldPassword.getValue();
        OctetString deltaKey = Operations.computeDeltaKey(a2, oldKey, newKey, pub, n2, p2.getMaxKeyLength());
        PDU pdu = target.makePDU();
        vbs = new VariableBinding[3];
        vbs[0] = new VariableBinding();
        vbs[0].setOid(usmSpinLock);
        vbs[0].setVariable(lockVal);
        OID keyChange = new OID(usmUserPrivKeyChange.getValue());
        keyChange.append(index);
        vbs[1] = new VariableBinding();
        vbs[1].setOid(keyChange);
        vbs[1].setVariable(deltaKey);
        vbs[2] = new VariableBinding();
        vbs[2].setOid(publicOID);
        vbs[2].setVariable(new OctetString(n2));
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            pdu = target.makePDU();
            vbs[2].setVariable(new Null());
            pdu.add(vbs[2]);
            pdu.setType(-96);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new SetPrivException("Timeout on getting usmPublic." + index.toString() + " after failed privacy key change");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Cannot get usmPublic." + index.toString() + " after failed privacy key change: " + response.getErrorStatusText());
            }
            OctetString cp = (OctetString)response.get(0).getVariable();
            if (!Arrays.equals(n2, cp.getValue())) {
                throw new SetPrivException("Privacy key change failed. May be due to a simultaneous key update by another manager!");
            }
        } else {
            if (response.getErrorStatus() == 12) {
                return null;
            }
            if (response.getErrorStatus() != 0) {
                throw new SetPrivException("Setting new privacy password failed: " + response.getErrorStatusText());
            }
        }
        return newKey;
    }

    protected static GenTarget modifyUser(Snmp session, GenTarget target, UserProfile newUser, byte[] engineID, boolean userIsActive) throws SetAuthException, SetPrivException, ReportException, TimeoutException, IOException {
        OID index = Operations.getRowIndex(engineID, newUser.getUser().getSecurityName());
        boolean ok = false;
        Random r2 = new Random();
        int retriesLeft = 10;
        OID[] autPrivProtocols = new OID[2];
        try {
            autPrivProtocols = Operations.getAuthPrivProtocols(session, target, engineID, newUser);
        }
        catch (SnmpErrorException ex) {
            throw new SetAuthException("Failed to retrieve current authentication and privacy protocol with SNMP error: " + ex.getMessage());
        }
        if (autPrivProtocols[0] != null && !autPrivProtocols[0].equals(newUser.getUser().getAuthenticationProtocol()) && !usmNoAuthProtocol.equals(autPrivProtocols[0]) && newUser.getUser().getAuthenticationProtocol() != null || autPrivProtocols[0] == null && !usmNoAuthProtocol.equals(newUser.getUser().getAuthenticationProtocol()) && newUser.getUser().getAuthenticationProtocol() != null) {
            throw new SetAuthException("Authentication protocol does not match with existing user's protocol");
        }
        if (autPrivProtocols[1] != null && !autPrivProtocols[1].equals(newUser.getUser().getPrivacyProtocol()) && !usmNoPrivProtocol.equals(autPrivProtocols[1]) && newUser.getUser().getPrivacyProtocol() != null || autPrivProtocols[1] == null && !usmNoPrivProtocol.equals(newUser.getUser().getPrivacyProtocol()) && newUser.getUser().getPrivacyProtocol() != null) {
            throw new SetPrivException("Privacy protocol does not match with existing user's protocol");
        }
        byte[] newKey = null;
        while (newKey == null && retriesLeft > 0) {
            --retriesLeft;
            newKey = Operations.setAuthentication(session, target, engineID, newUser.getUser().getAuthenticationProtocol(), index, newUser.getUser().getAuthenticationPassphrase());
            if (newKey != null) continue;
            try {
                Thread.sleep(r2.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {}
        }
        GenTarget privOpTarget = target;
        if (newKey == null) {
            throw new SetAuthException("Failed to set authentication after 10 tries");
        }
        if (target.getUser().getUser().getSecurityName().equals(newUser.getUser().getSecurityName())) {
            privOpTarget = new GenTarget(target);
            UsmUser oldUser = target.getUser().getUser();
            UserProfile userProfile = new UserProfile("", new UsmUser(oldUser.getSecurityName(), newUser.getUser().getAuthenticationProtocol(), new OctetString(newKey), oldUser.getPrivacyProtocol(), oldUser.getPrivacyPassphrase(), oldUser.getLocalizationEngineID()));
            privOpTarget.setUser(userProfile);
            privOpTarget.setDirectUser(true);
        }
        newKey = null;
        retriesLeft = 10;
        while (newKey == null && retriesLeft-- > 0) {
            newKey = Operations.setPrivacy(session, privOpTarget, engineID, newUser.getUser().getAuthenticationProtocol(), newUser.getUser().getPrivacyProtocol(), index, newUser.getUser().getPrivacyPassphrase());
            if (newKey != null) continue;
            try {
                Thread.sleep(r2.nextInt(1000));
            }
            catch (InterruptedException interruptedException) {}
        }
        if (newKey == null && retriesLeft <= 0) {
            throw new SetPrivException("Failed to set privacy after 10 tries");
        }
        return GenTarget.convertToDirectUser(target, newUser.getUser(), session.getUSM().getSecurityProtocols(), true);
    }

    public static boolean copyVacmGroupEntry(Snmp session, GenTarget target, byte[] engineID, UserProfile newUser, boolean useCreateAndGo) throws IOException, TimeoutException, ReportException {
        if (target.getUser() == null || target.getUser().getUser() == null || target.getUser().getUser().getSecurityModel() != 3) {
            return false;
        }
        UsmUser usmUser = target.getUser().getUser();
        OID sourceIndex = Operations.getVacmGroupRowIndex(usmUser.getSecurityModel(), usmUser.getSecurityName());
        Target t = target.getTarget(session);
        PDU pdu = target.makePDU();
        VariableBinding vb = new VariableBinding();
        OID vacmGroupName = new OID(Operations.vacmGroupName.getValue());
        vacmGroupName.append(sourceIndex);
        vb.setOid(vacmGroupName);
        pdu.add(vb);
        pdu.setType(-96);
        ResponseEvent responseEvent = session.send(pdu, t);
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on getting VACM group for: " + usmUser.getSecurityName());
        }
        Operations.checkForReport(response);
        if (response.size() > 0) {
            Variable groupNameVar = response.get(0).getVariable();
            OctetString groupName = (OctetString)groupNameVar;
            PDU setPDU = target.makePDU();
            vb = new VariableBinding();
            vacmGroupName = new OID(Operations.vacmGroupName.getValue());
            OID newGroupRowIndex = Operations.getVacmGroupRowIndex(newUser.getUser().getSecurityModel(), newUser.getUser().getSecurityName());
            vacmGroupName.append(newGroupRowIndex);
            vb.setOid(vacmGroupName);
            vb.setVariable(groupName);
            setPDU.add(vb);
            vb = new VariableBinding(new OID(vacmSecurityToGroupRowStatus).append(newGroupRowIndex));
            vb.setVariable(Operations.getRowCreationStatus(useCreateAndGo));
            setPDU.add(vb);
            setPDU.setType(-93);
            responseEvent = session.send(setPDU, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new TimeoutException("Timeout on setting VACM group for: " + usmUser.getSecurityName() + "=" + groupName);
            }
            Operations.checkForReport(response);
            return response.getErrorStatus() == 0;
        }
        return false;
    }

    public static GenTarget addNewUser(Snmp session, GenTarget target, byte[] engineID, UserProfile newUser, boolean useCreateAndGo) throws SetAuthException, SetPrivException, TimeoutException, UnderConstructionException, NewRowException, SetActiveFailedException, ReportException, IOException {
        return Operations.addNewUser(session, target, engineID, newUser, useCreateAndGo, true, false);
    }

    public static GenTarget addNewUser(Snmp session, GenTarget target, byte[] engineID, UserProfile newUser, boolean useCreateAndGo, boolean modifyUser, boolean copyVacmGroup) throws SetAuthException, SetPrivException, TimeoutException, UnderConstructionException, NewRowException, SetActiveFailedException, ReportException, IOException {
        target = GenTarget.convertToDirectUser(target, null, session.getUSM().getSecurityProtocols(), false);
        Target t = target.getTarget(session);
        OID index = Operations.getRowIndex(engineID, newUser.getUser().getSecurityName());
        PDU pdu = target.makePDU();
        VariableBinding vb = new VariableBinding();
        OID userStatus = new OID(usmUserStatus.getValue());
        userStatus.append(index);
        vb.setOid(userStatus);
        pdu.add(vb);
        pdu.setType(-96);
        ResponseEvent responseEvent = session.send(pdu, t);
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on getting user status: " + vb.getOid());
        }
        Operations.checkForReport(response);
        if (response.getErrorStatus() == 0 && !response.get(0).isException()) {
            if (modifyUser) {
                int s2 = ((Integer32)response.get(0).getVariable()).getValue();
                if (s2 != 1) {
                    throw new UnderConstructionException("User is under construction");
                }
                return Operations.modifyUser(session, target, newUser, engineID, true);
            }
            throw new UnderConstructionException("User exists");
        }
        if (copyVacmGroup && !Operations.copyVacmGroupEntry(session, target, engineID, newUser, useCreateAndGo)) {
            throw new NewRowException("Creating VACM group copy failed/not possible");
        }
        pdu = target.makePDU();
        VariableBinding[] vbs = new VariableBinding[]{new VariableBinding(), new VariableBinding()};
        OID cloneFrom = new OID(usmUserCloneFrom.getValue());
        cloneFrom.append(index);
        vbs[1].setOid(cloneFrom);
        OID template = Operations.getRowIndex(target.getEngineID().getValue(), target.getUser().getUser().getSecurityName());
        OID templateOID = new OID(usmUserSecurityName.getValue());
        templateOID.append(template);
        vbs[1].setVariable(templateOID);
        vbs[0].setOid(userStatus);
        vbs[0].setVariable(Operations.getRowCreationStatus(useCreateAndGo));
        pdu.addAll(vbs);
        pdu.setType(-93);
        responseEvent = session.send(pdu, t);
        response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on creating new user");
        }
        if (response.getErrorStatus() != 0) {
            throw new NewRowException("Creating new row failed with error status " + response.getErrorStatusText());
        }
        if (!useCreateAndGo) {
            vb.setOid(userStatus);
            vb.setVariable(new Integer32(1));
            pdu = target.makePDU();
            pdu.add(vb);
            pdu.setType(-93);
            responseEvent = session.send(pdu, t);
            response = responseEvent.getResponse();
            if (response == null) {
                throw new TimeoutException("Timeout on activating new user");
            }
            if (response.getErrorStatus() != 0) {
                throw new SetActiveFailedException("Activating new row failed: " + response.getErrorStatusText());
            }
        }
        GenTarget newTarget = GenTarget.convertToDirectUser(target, newUser.getUser(), session.getUSM().getSecurityProtocols(), true);
        if (modifyUser) {
            newTarget = Operations.modifyUser(session, target, newUser, engineID, false);
        }
        return newTarget;
    }

    public static Integer32 getRowCreationStatus(boolean useCreateAndGo) {
        if (useCreateAndGo) {
            return new Integer32(4);
        }
        return new Integer32(5);
    }

    public static OID[] getAuthPrivProtocols(Snmp session, GenTarget target, byte[] engineID, UserProfile user) throws IOException, TimeoutException, ReportException, SnmpErrorException {
        OID index = Operations.getRowIndex(engineID, user.getUser().getSecurityName());
        Target t = target.getTarget();
        PDU pdu = target.makePDU();
        VariableBinding[] vb = new VariableBinding[2];
        OID authProtocol = new OID(usmUserAuthProtocol.getValue());
        authProtocol.append(index);
        vb[0] = new VariableBinding(authProtocol);
        OID privProtocol = new OID(usmUserPrivProtocol.getValue());
        privProtocol.append(index);
        vb[1] = new VariableBinding(privProtocol);
        pdu.addAll(vb);
        ResponseEvent responseEvent = session.get(pdu, t);
        PDU response = responseEvent.getResponse();
        Operations.checkForReport(response);
        if (response.getErrorStatus() != 0) {
            throw new SnmpErrorException(response.getErrorStatus(), response.getErrorStatusText());
        }
        return new OID[]{(OID)response.get(0).getVariable(), (OID)response.get(1).getVariable()};
    }

    public static OID getVacmGroupRowIndex(int securityModel, OctetString securityName) {
        OID index = new OID();
        index.append(securityModel);
        index.append(securityName.toSubIndex(false));
        return index;
    }

    public static OID getRowIndex(byte[] engineID, OctetString userName) {
        OID index = new OID();
        index.append(engineID.length);
        for (byte subID : engineID) {
            index.append(subID & 0xFF);
        }
        index.append(userName.length());
        for (int i2 = 0; i2 < userName.length(); ++i2) {
            index.append(userName.get(i2) & 0xFF);
        }
        return index;
    }

    public static void checkForReport(PDU response) throws ReportException, TimeoutException {
        if (response == null) {
            throw new TimeoutException("Timeout occurred.");
        }
        if (response.getType() == -88) {
            Object s2 = "";
            if (response.size() > 0) {
                String os = response.get(0).getOid().toString();
                s2 = os + " = " + response.get(0).getVariable().toString();
            }
            throw new ReportException("SNMPv3 report: " + (String)s2);
        }
    }

    public static OctetString diffieHellmanKeyChange(Snmp session, Target target, PDUFactory pduFactory, byte[] engineID, OctetString user, OID usmUserKeyChangeOID, OID protocolOID, OID rowIndex) throws UsmException, IOException, TimeoutException {
        if (target == null || engineID == null) {
            throw new UsmException("Cannot determine SNMP engine ID", UsmError.engineID);
        }
        if (rowIndex == null) {
            rowIndex = Operations.getRowIndex(engineID, user);
        }
        if (usmNoPrivProtocol.equals(protocolOID) || usmNoAuthProtocol.equals(protocolOID)) {
            PDU pdu = pduFactory.createPDU(target);
            pdu.setType(-93);
            VariableBinding vb = new VariableBinding();
            OID usmSecurityProtocolOID = new OID(protocolOID);
            usmSecurityProtocolOID.append(rowIndex);
            vb.setOid(usmSecurityProtocolOID);
            vb.setVariable(protocolOID);
            ResponseEvent responseEvent = session.send(pdu, target);
            PDU response = responseEvent.getResponse();
            if (response.getErrorStatus() != 0) {
                throw new UsmException("Cannot set security protocol '" + protocolOID + "': " + response.getErrorStatusText(), UsmError.snmpError, response.getErrorStatus());
            }
            return null;
        }
        SecurityProtocol securityProtocol = SecurityProtocols.getInstance().getSecurityProtocol(protocolOID);
        if (securityProtocol == null) {
            throw new UsmException("Given security protocol " + protocolOID + " is unknown", UsmError.securityProtocolUnknown);
        }
        PDU paramPDU = pduFactory.createPDU(target);
        VariableBinding[] vbs = new VariableBinding[2];
        vbs[0] = new VariableBinding();
        vbs[0].setOid(usmDHParameters);
        OID usmUserDHUserKeyChangeOID = new OID(usmUserKeyChangeOID);
        usmUserDHUserKeyChangeOID.append(rowIndex);
        vbs[1] = new VariableBinding();
        vbs[1].setOid(usmUserDHUserKeyChangeOID);
        paramPDU.addAll(vbs);
        paramPDU.setType(-96);
        ResponseEvent responseEvent = session.send(paramPDU, target);
        PDU response = responseEvent.getResponse();
        if (response == null) {
            throw new TimeoutException("Timeout on getting usmUserDHUserKeyChangeOID." + rowIndex.toString() + ", key change failed.");
        }
        if (response.getErrorStatus() != 0 || response.size() != 2) {
            if (response.getType() == -88) {
                throw new UsmException("Cannot get usmDHParameters value - received REPORT PDU instead: " + response, UsmError.report, response);
            }
            throw new UsmException("Cannot get usmDHParameters and usmUserDHUserPrivKeyChange public value: " + response.getErrorStatusText(), UsmError.snmpError, response.getErrorStatus());
        }
        Variable dhParametersVal = response.get(0).getVariable();
        Variable y = response.get(1).getVariable();
        if (y.getSyntax() != 4 || dhParametersVal.getSyntax() != 4) {
            throw new UsmException("Set privacy failed: usmDHParameters.0 or usmUserDHUserPrivKeyChange." + rowIndex.toString() + " do not exist.", UsmError.userNotFound);
        }
        try {
            DHParameters dhParameters = DHParameters.getDHParametersFromBER((OctetString)dhParametersVal);
            KeyPair keyPair = DHOperations.generatePublicKey(dhParameters);
            KeyAgreement keyAgreement = DHOperations.getInitializedKeyAgreement(keyPair);
            byte[] sharedKey = DHOperations.computeSharedKey(keyAgreement, ((OctetString)y).toByteArray(), dhParameters);
            OctetString z = DHOperations.derivePublicKey(keyPair);
            PDU pdu = pduFactory.createPDU(target);
            vbs = new VariableBinding[]{new VariableBinding()};
            vbs[0].setOid(usmUserDHUserKeyChangeOID);
            vbs[0].setVariable(new OctetString(((OctetString)y).getValue(), z.getValue()));
            pdu.addAll(vbs);
            pdu.setType(-93);
            responseEvent = session.send(pdu, target);
            response = responseEvent.getResponse();
            if (response == null) {
                pdu = pduFactory.createPDU(target);
                vbs[0].setVariable(new Null());
                pdu.add(vbs[0]);
                pdu.setType(-96);
                responseEvent = session.send(pdu, target);
                response = responseEvent.getResponse();
                if (response == null) {
                    throw new TimeoutException("Timeout on getting usmUserDHUserKeyChangeOID." + rowIndex.toString() + " after failed key change");
                }
                if (response.getErrorStatus() != 0) {
                    throw new UsmException("Cannot get usmUserDHUserKeyChangeOID." + rowIndex.toString() + " after failed key change: " + response.getErrorStatusText(), UsmError.snmpError, response.getErrorStatus());
                }
                OctetString cp = (OctetString)response.get(0).getVariable();
                if (Arrays.equals(((OctetString)y).toByteArray(), cp.getValue())) {
                    throw new UsmException("Key change failed for unknown reason.", UsmError.keyChangeFailed);
                }
            } else {
                if (response.getErrorStatus() == 12) {
                    return null;
                }
                if (response.getErrorStatus() != 0) {
                    throw new UsmException("Setting new key failed: " + response.getErrorStatusText(), UsmError.snmpError, response.getErrorStatus());
                }
                byte[] usmKey = DHOperations.deriveKey(sharedKey, securityProtocol.getMaxKeyLength());
                return new OctetString(usmKey);
            }
            return null;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e2) {
            throw new UsmException("Security algorithm not supported by Java Runtime for this key change: " + e2.getMessage(), UsmError.securityAlgorithmNotAvailable);
        }
    }
}

