/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.snmp.ValueConverter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;

public class IndexConverter {
    /*
     * WARNING - void declaration
     */
    public static Variable getIndexVariable(IndexStruct index, ObjectID indexValue) {
        try {
            Object object;
            switch (index.baseType) {
                case 1: {
                    if (index.impliedLength || index.minLength == index.maxLength) {
                        return new OctetString(indexValue.asByteArray());
                    }
                    ObjectID objectID = indexValue;
                    object = objectID.getSuffix(objectID.size() - 1);
                    return new OctetString(((ObjectID)object).asByteArray());
                }
                case 0: {
                    return new Integer32((int)indexValue.getLastSubID());
                }
                case 9: {
                    return new TimeTicks(indexValue.getLastSubID());
                }
                case 5: {
                    return new IpAddress(indexValue.toString());
                }
                case 12: {
                    Object object2 = object = indexValue.toString();
                    return new IpAddress(((String)object2).substring(((String)object2).indexOf(".") + 1));
                }
            }
            if (((IndexStruct)object).impliedLength || ((IndexStruct)object).minLength == ((IndexStruct)object).maxLength) {
                return new OID(indexValue.toString());
            }
            ObjectID objectID = indexValue;
            return new OID(objectID.getSuffix(objectID.size() - 1).toString());
        }
        catch (Exception exception) {
            void var1_1;
            return new OID(var1_1.toString());
        }
    }

    public static Variable[] getIndexVariables(IndexStruct[] indexes, ObjectID[] indexValues) {
        int n2 = Math.min(indexes.length, indexValues.length);
        Variable[] variableArray = new Variable[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            variableArray[i2] = IndexConverter.getIndexVariable(indexes[i2], indexValues[i2]);
        }
        return variableArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue) {
        void var2_2;
        void var1_1;
        return IndexConverter.getIndexString(converter, (IndexStruct)var1_1, (ObjectID)var2_2, false, null, null, null, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexString(ValueConverter converter, IndexStruct index, Variable indexVariable, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableAsHex) {
        ValueConverter valueConverter;
        void var3_3;
        Object object;
        if ((object = converter.toNative((Variable)object, true)) == null) {
            return "?";
        }
        object = object.toString();
        if (var3_3 != false && (((String)object).indexOf(46) >= 0 || index.baseType == 1 || index.baseType == 3 || converter.getEffectiveSyntax().hasEnums() || valueConverter.displayHint != null)) {
            void var1_1;
            if (index.impliedLength || index.minLength == var1_1.maxLength) {
                return fixedLengthQuote + IndexConverter.a((String)object, nonPrintableAsHex, fixedLengthQuote, fixedLengthQuoteEscape) + fixedLengthQuote;
            }
            return variableLengthQuote + IndexConverter.a((String)object, nonPrintableAsHex, variableLengthQuote, variableLengthQuoteEscape) + variableLengthQuote;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexString(ValueConverter converter, IndexStruct index, ObjectID indexValue, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableAsHex) {
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return IndexConverter.getIndexString(converter, (IndexStruct)v0, IndexConverter.getIndexVariable((IndexStruct)v0, (ObjectID)var2_2), (boolean)var3_3, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableAsHex);
    }

    private static String a(String string, StringFormat stringFormat, String string2, String string3) {
        if (stringFormat != null && !IndexConverter.isPrintable(string)) {
            return stringFormat.getFormatIdentifier() + new OctetString(string).toString(stringFormat.getDelimiter(), stringFormat.getRadix());
        }
        return string.replaceAll(Pattern.quote(string2), Matcher.quoteReplacement(string3));
    }

    public static boolean isPrintable(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (!Character.isISOControl(c2) && (c2 & 0xFF) < 128 || Character.isWhitespace(c2) && ((c2 & 0xFF) < 28 || (c2 & 0xFF) > 31)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues) {
        void var2_2;
        void var1_1;
        return IndexConverter.getIndexString(converter, (IndexStruct[])var1_1, (ObjectID[])var2_2, false, null, null, null, null, null);
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, ObjectID[] indexValues, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < indexes.length && i2 < indexValues.length && i2 < converter.length; ++i2) {
            stringBuffer.append(IndexConverter.getIndexString(converter[i2], indexes[i2], indexValues[i2], withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat));
            if (i2 + 1 >= indexes.length || i2 + 1 >= indexValues.length || i2 + 1 >= converter.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String getIndexString(ValueConverter[] converter, IndexStruct[] indexes, Variable[] indexVariables, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < indexes.length && i2 < indexVariables.length && i2 < converter.length; ++i2) {
            stringBuilder.append(IndexConverter.getIndexString(converter[i2], indexes[i2], indexVariables[i2], withStringDelimiter, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat));
            if (i2 + 1 >= indexes.length || i2 + 1 >= indexVariables.length || i2 + 1 >= converter.length) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static ValueConverter[] getIndexValueConverter(MIBRepository rep, MIBObjectType table) {
        Vector<? extends MIBObjectType> vector;
        if (!table.isTable()) {
            return null;
        }
        vector = rep.getColumnarObjectsOfTable((MIBObjectType)((Object)vector), true, false);
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            MIBObjectType mIBObjectType = (MIBObjectType)vector.get(i2);
            MIBTextualConvention mIBTextualConvention = rep.getEffectiveSyntax(mIBObjectType.getSyntax());
            valueConverterArray[i2] = new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        return valueConverterArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String getIndexValueString(MIBRepository rep, MIBObjectType table, Variable[] indexVariables, boolean withStringDelimiter, String fixedLengthQuote, String variableLengthQuote, String fixedLengthQuoteEscape, String variableLengthQuoteEscape, StringFormat nonPrintableStringFormat) {
        void var3_3;
        void var2_2;
        IndexStruct[] indexStructArray;
        void var1_1;
        ValueConverter[] valueConverterArray = IndexConverter.getIndexValueConverter(rep, table);
        indexStructArray = var1_1.getIndexPart().getIndexStruct((MIBRepository)indexStructArray);
        return IndexConverter.getIndexString(valueConverterArray, indexStructArray, (Variable[])var2_2, (boolean)var3_3, fixedLengthQuote, variableLengthQuote, fixedLengthQuoteEscape, variableLengthQuoteEscape, nonPrintableStringFormat);
    }

    public static enum StringFormat {
        hex(':', 16, "#x"),
        decimal('.', 10, "#d"),
        octal(':', 8, "#o"),
        binary(':', 2, "#b");

        private char a;
        private int b;
        private String c;

        /*
         * WARNING - void declaration
         */
        private StringFormat(char separator, int radix, String formatIdentifier) {
            void var3_3;
            this.a = var3_3;
            this.b = radix;
            this.c = formatIdentifier;
        }

        public final int getRadix() {
            return this.b;
        }

        public final char getDelimiter() {
            return this.a;
        }

        public final String getFormatIdentifier() {
            return this.c;
        }

        public static StringFormat getFormat(int radix) {
            for (StringFormat stringFormat : StringFormat.values()) {
                if (stringFormat.getRadix() != radix) continue;
                return stringFormat;
            }
            return null;
        }

        public static StringFormat getFormat(String id) {
            for (StringFormat stringFormat : StringFormat.values()) {
                if (!stringFormat.getFormatIdentifier().equals(id)) continue;
                return stringFormat;
            }
            return null;
        }
    }
}

