/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmp;

import com.agentpp.snmp.TargetStatistics;
import com.agentpp.snmp.UserProfile;
import java.io.Serializable;
import java.time.Instant;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.DirectUserTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.DtlsAddress;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.util.SchedulerTask;
import org.snmp4j.util.TaskScheduler;
import org.snmp4j.util.ThreadPool;

public class GenTarget
implements Comparable,
Serializable {
    public static final long serialVersionUID = 4611240302686996959L;
    private static final LogAdapter logger = LogFactory.getLogger("SNMP");
    private String name;
    private OctetString community;
    private UserProfile user;
    private OctetString context = new OctetString();
    private OctetString contextEngineID = new OctetString();
    private int version;
    private int retries;
    private int timeout = 1000;
    private OctetString engineID = new OctetString();
    private String MIBSet;
    private volatile Address address;
    private volatile String resolvedAddress;
    private volatile boolean resolvePending;
    private String addressString;
    private String addressType;
    private TargetType targetType;
    private Instant lastUpdated;
    private volatile byte[] cachedEngineID;
    private volatile TargetStatistics targetStatistics = new TargetStatistics();
    private static TaskScheduler resolver;

    private GenTarget() {
        GenTarget.initResolver();
    }

    public GenTarget(String name, Address address) {
        this();
        this.name = name;
        this.setAddress(address);
        this.lastUpdated = Instant.now();
    }

    public GenTarget(GenTarget other) {
        this();
        this.name = other.name;
        this.resolvedAddress = other.resolvedAddress;
        this.addressString = other.addressString;
        this.setAddress(other.address);
        this.addressType = other.addressType;
        this.context = other.context;
        this.contextEngineID = other.contextEngineID;
        this.version = other.version;
        this.retries = other.retries;
        this.community = other.community;
        this.timeout = other.timeout;
        this.engineID = other.engineID;
        this.user = other.getUser();
        this.MIBSet = other.MIBSet;
        this.targetType = other.targetType;
        this.lastUpdated = other.lastUpdated;
        this.targetStatistics = new TargetStatistics(other.targetStatistics);
        this.cachedEngineID = other.cachedEngineID;
    }

    public GenTarget(Target t, String name) {
        this();
        this.name = name;
        this.addressType = t.getAddress() instanceof TcpAddress ? "TCP" : "UDP";
        this.setAddress((Address)t.getAddress());
        this.timeout = (int)t.getTimeout();
        this.retries = t.getRetries();
        this.version = t.getVersion();
        if (t instanceof UserTarget) {
            UserTarget st = (UserTarget)t;
            this.engineID = new OctetString(st.getAuthoritativeEngineID());
        }
        this.setTargetType(t);
    }

    private void setTargetType(Target t) {
        this.targetType = t instanceof DirectUserTarget ? TargetType.usmKey : (t instanceof CertifiedTarget ? TargetType.certified : (t instanceof UserTarget ? TargetType.usmUser : TargetType.community));
    }

    public GenTarget(String name, String addressType, String address) {
        this();
        this.name = name;
        this.addressType = addressType;
        this.addressString = address;
    }

    public static GenTarget convertToDirectUser(GenTarget other, UsmUser newUser, SecurityProtocols securityProtocols, boolean forceLocalization) {
        GenTarget directUserTarget = new GenTarget(other);
        directUserTarget.targetType = TargetType.usmKey;
        if (newUser == null) {
            newUser = directUserTarget.getUser().getUser();
        }
        if (forceLocalization || !newUser.isLocalized()) {
            OctetString localizationEngineID = newUser.getLocalizationEngineID() != null ? newUser.getLocalizationEngineID() : directUserTarget.engineID;
            newUser = newUser.localizeUser(localizationEngineID, null, null, securityProtocols);
        }
        directUserTarget.setUser(new UserProfile("", newUser));
        return directUserTarget;
    }

    public boolean isDirectUser() {
        return this.targetType == TargetType.usmKey;
    }

    public void setDirectUser(boolean directUser) {
        this.targetType = directUser ? TargetType.usmKey : TargetType.usmUser;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public boolean isUsmUser() {
        return this.targetType == null && this.user != null && this.user.getUser() != null || this.targetType == TargetType.usmKey || this.targetType == TargetType.usmUser;
    }

    public boolean isUsmNonLocalized() {
        return this.user != null && this.user.getUser() != null && !this.user.getUser().isLocalized() && this.targetType == TargetType.usmUser;
    }

    private static synchronized void initResolver() {
        if (resolver == null) {
            ThreadPool tp = ThreadPool.create("DNSResolver", 2);
            resolver = new TaskScheduler(tp);
            Thread resolverScheduler = new Thread(resolver);
            resolverScheduler.setDaemon(true);
            resolverScheduler.start();
        }
    }

    public void setCommunity(OctetString newCommunity) {
        this.community = newCommunity;
    }

    public OctetString getCommunity() {
        return this.community;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUser(UserProfile newUser) {
        this.user = newUser;
    }

    public UserProfile getUser() {
        return this.user;
    }

    public void setVersion(int newVersion) {
        this.version = newVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public void setRetries(int newRetries) {
        this.retries = newRetries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setTimeout(int newTimeout) {
        this.timeout = newTimeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAddress(Address newAddress) {
        this.address = newAddress;
        if (!this.resolvePending) {
            ResolveTask task = new ResolveTask();
            resolver.addTask(task);
        }
    }

    public String getHostname() {
        String hostname = this.getName();
        if (hostname.indexOf(32) > 0) {
            hostname = hostname.substring(0, hostname.indexOf(32));
        }
        return hostname;
    }

    public Address getAddress() {
        if (this.address == null) {
            Object addrString = this.addressString;
            if (addrString == null) {
                addrString = "127.0.0.1";
            }
            if (!((String)addrString).contains("/")) {
                addrString = (String)addrString + "/161";
            }
            if (this.addressType == null) {
                this.addressType = "UDP";
            }
            this.setAddress(GenericAddress.parse(this.addressType + ":" + (String)addrString));
        }
        return this.address;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GenTarget genTarget = (GenTarget)o2;
        if (this.getVersion() != genTarget.getVersion()) {
            return false;
        }
        if (this.getRetries() != genTarget.getRetries()) {
            return false;
        }
        if (this.getTimeout() != genTarget.getTimeout()) {
            return false;
        }
        if (!this.getName().equals(genTarget.getName())) {
            return false;
        }
        if (this.getCommunity() != null ? !this.getCommunity().equals(genTarget.getCommunity()) : genTarget.getCommunity() != null) {
            return false;
        }
        if (this.getUser() != null ? !this.getUser().equals(genTarget.getUser()) : genTarget.getUser() != null) {
            return false;
        }
        if (this.getContext() != null ? !this.getContext().equals(genTarget.getContext()) : genTarget.getContext() != null) {
            return false;
        }
        if (this.getContextEngineID() != null ? !this.getContextEngineID().equals(genTarget.getContextEngineID()) : genTarget.getContextEngineID() != null) {
            return false;
        }
        if (this.getEngineID() != null ? !this.getEngineID().equals(genTarget.getEngineID()) : genTarget.getEngineID() != null) {
            return false;
        }
        if (this.getMIBSet() != null ? !this.getMIBSet().equals(genTarget.getMIBSet()) : genTarget.getMIBSet() != null) {
            return false;
        }
        if (this.getAddress() != null ? !this.getAddress().equals(genTarget.getAddress()) : genTarget.getAddress() != null) {
            return false;
        }
        if (!this.getAddressString().equals(genTarget.getAddressString())) {
            return false;
        }
        if (this.getAddressType() != null ? !this.getAddressType().equals(genTarget.getAddressType()) : genTarget.getAddressType() != null) {
            return false;
        }
        return this.getTargetType() == genTarget.getTargetType();
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + (this.getEngineID() != null ? this.getEngineID().hashCode() : 0);
        result = 31 * result + this.getAddressString().hashCode();
        return result;
    }

    public Target getTarget(long maxTimeoutMillis) {
        Target t = this.getTarget();
        if (t.getTimeout() * 10L * (long)(1 + t.getRetries()) > maxTimeoutMillis) {
            t.setTimeout(maxTimeoutMillis / (long)(10 * (1 + t.getRetries())));
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Set maximum timeout for target " + t.getAddress() + " to: " + t.getTimeout() + "/100 seconds")));
            }
        }
        return t;
    }

    public Target getTarget(Snmp session) {
        AbstractTarget t = null;
        if (this.version == 3) {
            Address addr = this.getAddress();
            if (addr instanceof TlsAddress) {
                t = new CertifiedTarget(OctetString.fromString(this.getName()));
                t.setAddress((Address)addr);
                t.setSecurityModel(4);
                this.targetType = TargetType.certified;
            } else if (addr instanceof DtlsAddress) {
                t = new CertifiedTarget(OctetString.fromString(this.getName()));
                t.setAddress(addr);
                t.setSecurityModel(4);
                this.targetType = TargetType.certified;
            } else if (this.getUser() != null) {
                if (this.engineID == null || this.engineID.length() == 0) {
                    if (this.cachedEngineID == null || this.cachedEngineID.length == 0) {
                        if (session != null) {
                            this.cachedEngineID = session.discoverAuthoritativeEngineID(this.getAddress(), this.getTimeout());
                            if (this.cachedEngineID == null) {
                                logger.warn((Serializable)((Object)("Timeout on engine ID discovery from " + this.getAddress())));
                                return null;
                            }
                        } else if (this.cachedEngineID == null) {
                            this.cachedEngineID = new byte[0];
                        }
                    }
                } else {
                    this.cachedEngineID = this.engineID.getValue();
                }
                UsmUser usmUser = this.user.getUser();
                SecurityProtocols securityProtocols = session != null ? session.getUSM().getSecurityProtocols() : SecurityProtocols.getInstance();
                AuthenticationProtocol authenticationProtocol = securityProtocols.getAuthenticationProtocol(usmUser.getAuthenticationProtocol());
                PrivacyProtocol privacyProtocol = securityProtocols.getPrivacyProtocol(usmUser.getPrivacyProtocol());
                if (this.isDirectUser() || !this.user.isPrincipal() && this.user.getUser().isLocalized()) {
                    t = new DirectUserTarget<Address>(this.getAddress(), this.user.getUser().getSecurityName(), this.user.getUser().getLocalizationEngineID().getValue(), authenticationProtocol, usmUser.getAuthenticationPassphrase(), privacyProtocol, usmUser.getPrivacyPassphrase());
                } else {
                    t = new UserTarget<Address>(this.getAddress(), this.user.getUser().getSecurityName(), this.cachedEngineID);
                    this.targetType = TargetType.usmUser;
                }
                int secLevel = 1;
                if (authenticationProtocol != null) {
                    secLevel = 2;
                    if (privacyProtocol != null) {
                        secLevel = 3;
                    }
                }
                t.setSecurityLevel(secLevel);
            }
        } else {
            CommunityTarget<Address> ct = new CommunityTarget<Address>(this.getAddress(), this.community);
            t = ct;
            this.targetType = TargetType.community;
        }
        if (t != null) {
            t.setRetries(this.retries);
            t.setTimeout(this.timeout);
            t.setVersion(this.version);
        }
        return t;
    }

    public Target getTarget() {
        return this.getTarget(null);
    }

    public OctetString getEngineID() {
        if (this.engineID != null && this.engineID.length() > 0) {
            return this.engineID;
        }
        if (this.cachedEngineID != null) {
            return new OctetString(this.cachedEngineID);
        }
        return new OctetString();
    }

    public PDU makePDU() {
        PDU pdu;
        if (this.version == 3) {
            ScopedPDU scopedPdu = new ScopedPDU();
            if (this.getUser() != null) {
                if (this.getContextEngineID() != null && this.getContextEngineID().length() > 0) {
                    scopedPdu.setContextEngineID(this.getContextEngineID());
                } else if (this.engineID != null) {
                    scopedPdu.setContextEngineID(new OctetString(this.engineID));
                }
                if (this.getContext() != null) {
                    scopedPdu.setContextName(this.getContext());
                }
            }
            pdu = scopedPdu;
        } else {
            pdu = new PDU();
        }
        return pdu;
    }

    public String toString() {
        Address addr;
        String s2 = this.getName() + " - " + this.addressType + ":";
        s2 = this.address == null ? s2 + this.addressString : ((addr = this.getAddress()) == null ? s2 + "<unresolvable address>" : (this.resolvedAddress != null ? s2 + this.resolvedAddress : s2 + GenTarget.getDottedAddressString(addr)));
        return s2;
    }

    private static String getDottedAddressString(Address address) {
        if (address instanceof IpAddress) {
            byte[] addr = ((IpAddress)address).getInetAddress().getAddress();
            StringBuffer buf = new StringBuffer(addr.length * 4);
            for (int i2 = 0; i2 < addr.length; ++i2) {
                buf.append("" + (addr[i2] & 0xFF));
                if (i2 + 1 >= addr.length) continue;
                buf.append(".");
            }
            return buf.toString();
        }
        return "?";
    }

    public String toDetailedString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.toString());
        buf.append(": ");
        buf.append(GenTarget.getVersionString(this.version));
        buf.append(", retries=");
        buf.append(this.retries);
        buf.append(", timeout=");
        buf.append(this.timeout);
        buf.append("|");
        if (this.version == 3) {
            buf.append("engineID=");
            buf.append(this.engineID.toHexString());
            buf.append(", context=");
            buf.append(this.context);
            buf.append(", contextID=");
            if (this.getContextEngineID() != null) {
                buf.append(new OctetString(this.getContextEngineID()).toHexString());
            }
            buf.append("|");
            if (this.user != null) {
                buf.append(this.user.toDetailedString());
            }
        } else {
            buf.append("community=");
            buf.append(this.getCommunity());
        }
        return buf.toString();
    }

    public static String getVersionString(int version) {
        switch (version) {
            case 0: {
                return "SNMPv1";
            }
            case 1: {
                return "SNMPv2c";
            }
            case 3: {
                return "SNMPv3";
            }
        }
        return "?";
    }

    public int compareTo(Object o2) {
        return this.toString().compareTo(o2.toString());
    }

    public void setContext(OctetString newContext) {
        this.context = newContext;
    }

    public OctetString getContext() {
        return this.context;
    }

    public void setContextEngineID(OctetString newContextEngineID) {
        if (newContextEngineID == null) {
            throw new NullPointerException();
        }
        this.contextEngineID = newContextEngineID;
    }

    public OctetString getContextEngineID() {
        return this.contextEngineID;
    }

    public void setMIBSet(String newMIBSet) {
        this.MIBSet = newMIBSet;
    }

    public String getMIBSet() {
        return this.MIBSet;
    }

    public void setEngineID(OctetString engineID) {
        if (engineID == null) {
            throw new NullPointerException();
        }
        this.engineID = engineID;
    }

    public void setAddressString(String addressString) {
        this.addressString = addressString;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public String getAddressString() {
        if (this.addressString == null && this.address != null) {
            this.addressString = this.address.toString();
        }
        return this.addressString;
    }

    public String getAddressType() {
        return this.addressType;
    }

    public Instant getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Instant lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public TargetStatistics getTargetStatistics() {
        return this.targetStatistics;
    }

    public static enum TargetType {
        community,
        usmUser,
        certified,
        usmKey;

    }

    public class ResolveTask
    implements SchedulerTask {
        private ResolveTask() {
            GenTarget.this.resolvePending = true;
        }

        @Override
        public void run() {
            Address addr = GenTarget.this.getAddress();
            if (addr != null) {
                GenTarget.this.resolvedAddress = addr.toString();
            }
            GenTarget.this.resolvePending = false;
        }

        @Override
        public boolean isReadyToRun() {
            return GenTarget.this.resolvePending;
        }

        @Override
        public boolean isDone() {
            return GenTarget.this.resolvedAddress != null;
        }

        @Override
        public void terminate() {
        }

        @Override
        public void join() throws InterruptedException {
        }

        @Override
        public void interrupt() {
        }
    }
}

