/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.CreateOidsVisitor;
import com.agentpp.smiparser.ParseScope;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SMIRepository
extends SimpleNode {
    private ImportModuleListener a = null;
    protected Map modules = new HashMap();
    protected ParseScope scope = null;

    public SMIRepository() {
        super(0);
    }

    /*
     * WARNING - void declaration
     */
    public SMIRepository(int id) {
        super((int)var1_1);
        void var1_1;
    }

    public void reinit() {
        this.modules = new HashMap();
    }

    public void setImporter(ImportModuleListener importer) {
        this.a = importer;
        if (this.scope != null) {
            this.scope.setImporter(importer);
        }
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ((ParseScope)iterator.next()).setImporter(importer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addScope(String moduleName) {
        void var1_1;
        this.scope = new ParseScope(moduleName, this.a);
        this.modules.put(var1_1, this.scope);
    }

    /*
     * WARNING - void declaration
     */
    public void setScope(String moduleName, SMIParseExceptionHandler errorHandler) {
        void var2_2;
        void var1_1;
        this.scope = (ParseScope)this.modules.get(var1_1);
        this.scope.setErrorHandler((SMIParseExceptionHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ParseScope getScope(String moduleName) {
        void var1_1;
        return (ParseScope)this.modules.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean importModule(String moduleName, MIBRepository localCache, boolean addAllToKnownObjects) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.scope == null) {
            return false;
        }
        return this.scope.importModule((String)var1_1, (MIBRepository)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String hasCircularImport(String imp, String moduleName) {
        SMIRepository sMIRepository;
        void var2_2;
        if (this.a == null) {
            return null;
        }
        void var3_3 = var2_2;
        var2_2 = sMIRepository;
        sMIRepository = this;
        IObject[] iObjectArray = new ImportModuleEvent(sMIRepository, (String)var2_2);
        sMIRepository.a.importModule((ImportModuleEvent)iObjectArray);
        if (iObjectArray.getObjects() != null) {
            iObjectArray = iObjectArray.getObjects();
            for (int i2 = 0; i2 < iObjectArray.length; ++i2) {
                if (!(iObjectArray[i2] instanceof MIBModule)) continue;
                String[] stringArray = (String[])iObjectArray[i2];
                if (stringArray.importsFrom((String)var2_2) || stringArray.importsFrom((String)var3_3)) {
                    return var2_2;
                }
                if (!stringArray.hasImports()) continue;
                stringArray = stringArray.getImportSources();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    String string = sMIRepository.hasCircularImport(stringArray[i3], (String)var3_3);
                    if (string == null) continue;
                    return string;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObject(String moduleName, String objectName) {
        void var2_2;
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObject((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean setErrorHandler(SMIParseExceptionHandler errorHandler) {
        if (this.scope != null) {
            void var1_1;
            this.scope.setErrorHandler((SMIParseExceptionHandler)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getObjectID(String objectName) {
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getObjectID(String moduleName, String objectName) {
        void var2_2;
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isModuleAlreadyImported(String moduleName) {
        void var1_1;
        if (this.scope == null) {
            return false;
        }
        return this.scope.isModuleAlreadyImported((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isObjectKnown(String objectName) {
        void var1_1;
        if (this.scope == null) {
            return false;
        }
        return this.scope.isObjectKnown((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getKnownObject(String objectName) {
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getKnownObject((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getModuleName(Object moduleID) {
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getModuleName(var1_1);
    }

    public void createOids() {
        try {
            this.jjtAccept(new CreateOidsVisitor(this), null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createOids(String scope) {
        try {
            void var1_1;
            this.jjtAccept(new CreateOidsVisitor(this, (String)var1_1), null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addObject(MIBObject o2) {
        if (this.scope != null) {
            void var1_1;
            this.scope.addObject((MIBObject)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addKnownObject(MIBObject o2) throws SMIParseException {
        if (this.scope != null) {
            void var1_1;
            this.scope.addKnownObject((MIBObject)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void replaceKnownObject(String name, MIBObject o2) {
        if (this.scope != null) {
            void var2_2;
            void var1_1;
            this.scope.replaceKnownObject((String)var1_1, (MIBObject)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addUnresolvedName(StringToken[] oid, StringToken name) {
        if (this.scope != null) {
            void var2_2;
            void var1_1;
            this.scope.addUnresolvedName((StringToken[])var1_1, (StringToken)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkUnresolved(StringToken name, StringToken[] oid) {
        if (this.scope != null) {
            void var2_2;
            void var1_1;
            this.scope.checkUnresolved((StringToken)var1_1, (StringToken[])var2_2);
        }
    }

    public void resolveNames() {
        if (this.scope != null) {
            this.scope.resolveNames();
        }
    }

    public boolean existsUnresolvedNames() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedNames();
    }

    public Iterator getUnresolvedNames() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedNames();
    }

    /*
     * WARNING - void declaration
     */
    public StringToken getUnresolvedSyntax(String syntax) {
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedSyntax((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void checkUnresolvedSyntax(StringToken syntax) {
        if (this.scope != null) {
            void var1_1;
            this.scope.checkUnresolvedSyntax((StringToken)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkUnresolvedObject(StringToken objectName, Class type) {
        if (this.scope != null) {
            void var2_2;
            void var1_1;
            this.scope.checkUnresolvedObject((StringToken)var1_1, (Class)var2_2);
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedSyntaxes();
    }

    public boolean existsWrongTypes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsWrongTypes();
    }

    public void resolveSyntaxes() {
        if (this.scope != null) {
            this.scope.resolveSyntaxes();
        }
    }

    public Iterator getWrongTypes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getWrongTypes();
    }

    public Iterator getUnresolvedSyntaxes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedSyntaxes();
    }

    /*
     * WARNING - void declaration
     */
    public void addSequence(String sequenceIdentifier) {
        if (this.scope != null) {
            void var1_1;
            this.scope.addSequence((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector getSequence(String sequenceIdentifier) {
        void var1_1;
        if (this.scope == null) {
            return null;
        }
        return this.scope.getSequence((String)var1_1);
    }

    public List<String> getKnownLowerCaseNames() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getKnownLowerCaseNames();
    }

    public List<String> getKnownUpperCaseNames() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getKnownUpperCaseNames();
    }

    public ImportModuleListener getModuleImporter() {
        return this.a;
    }
}

