/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.notepad;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.font.FontStyle;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.print.SmiTextPrintable;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.notepad.ElementTreePanel;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.util.ThreadPool;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class Notepad
extends JDialog
implements JCSelectListener {
    private static final String CFG_SEARCH = "agentpp.notepad.searchExpression";
    private static final String CFG_REPLACE = "agentpp.notepad.substitution";
    private static ResourceBundle resources;
    protected File file = new File("");
    private ExtendedListTable errorTable = new ExtendedListTable();
    private JCVectorDataSource errorModel = new JCVectorDataSource();
    private TableSorter tableSorter;
    private JScrollPane scroller;
    JFrame myFrame;
    String lastSearch = "";
    private MIBImporter importer = null;
    private UserConfigFile config = new UserConfigFile();
    PatternMatcher matcher = new Perl5Matcher();
    PatternCompiler compiler = new Perl5Compiler();
    Pattern lastPattern;
    PatternMatcherInput input;
    MatchResult result;
    private boolean lookupEnabled;
    private MIBModule lookupData;
    private JDialog ccPopup;
    private ThreadPool lookupPool;
    private CompletionLookupUpdater lookupUpdater;
    private LinkedList propertyChangeListeners = new LinkedList();
    static final String[] COLUMN_NAMES;
    static final int COL_NR = 0;
    static final int COL_ERROR = 1;
    static final int COL_TEXT = 2;
    private static final String ACTION_EXPORT_SELECTED_ERRORS = "Save selected errors...";
    private JEditorPane editor;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    protected StatusBar status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String accelSuffix = "Accelerator";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String saveAsAction = "saveAs";
    public static final String exitAction = "exit";
    public static final String printAction = "print";
    public static final String findAction = "find";
    public static final String importAction = "import";
    public static final String exportErrorsAction = "exportErrors";
    public static final String replaceAction = "replace";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private ImportAction importActionObj = new ImportAction();
    private ExportSelectedErrorsAction exportAllErrorsAction = new ExportSelectedErrorsAction("exportErrors", false);
    private Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new SaveAsAction(), new ExitAction(), new FindAction(), new ReplaceAction(), this.importActionObj, this.exportAllErrorsAction, new ImportAccurateAction(), new ImportLenientAction(), new CheckAccurateAction(), new CheckLenientAction(), new FindNextAction(), new PrintAction(), this.undoAction, this.redoAction};
    private int parserMode;
    private boolean syntaxHighlighting;
    private int tabSize = 8;

    public Notepad(JFrame frame) {
        super(frame);
        super.setDefaultCloseOperation(2);
        this.myFrame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TablePopupMenu menu = this.errorTable.getPopupMenu();
        menu.addItem(ACTION_EXPORT_SELECTED_ERRORS, new ExportSelectedErrorsAction(ACTION_EXPORT_SELECTED_ERRORS, true));
        this.errorTable.setPopupMenuEnabled(true);
    }

    public void setConfig(UserConfigFile config) {
        this.config = config;
        SmiContext s2 = ((SmiEditorKit)this.getEditor().getEditorKit()).getStylePreferences(this.editor.getForeground());
        List<FontStyle> v = SmiContext.getStyles(config);
        s2.setSyntaxHighlighting(SmiContext.loadSyntaxHighlighting(config));
        s2.setStyles(v);
    }

    public void setLookupEnabled(boolean lookupEnabled) {
        this.lookupEnabled = lookupEnabled;
    }

    private void jbInit() {
        this.createErrorTable();
        this.getContentPane().setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new Hashtable();
        Action[] actions = this.getActions();
        for (int i2 = 0; i2 < actions.length; ++i2) {
            Action a2 = actions[i2];
            this.commands.put(a2.getValue("Name"), a2);
        }
        this.scroller = new JScrollPane();
        JViewport port = this.scroller.getViewport();
        port.add(this.editor);
        port.setScrollMode(1);
        this.menuItems = new Hashtable();
        this.menubar = this.createMenubar();
        this.getContentPane().add("North", this.menubar);
        JSplitPane pane = new JSplitPane(0);
        JScrollPane statusScroller = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", pane);
        pane.setBottomComponent(this.scroller);
        pane.setTopComponent(this.errorTable);
        pane.setOneTouchExpandable(true);
        this.getContentPane().add("Center", panel);
        this.status = this.createStatusbar();
        this.editor.addCaretListener(this.status);
        this.getContentPane().add("South", this.status);
        panel.setPreferredSize(new Dimension(600, 600));
        this.pack();
        pane.setDividerLocation(0.2);
    }

    public Notepad(JFrame f2, File file) {
        this(f2);
        this.loadFile(file, 1, 1, 0);
    }

    public Notepad(JFrame f2, File file, String searchString) {
        this(f2);
        this.loadFile(file, searchString);
    }

    public Notepad(JFrame f2, File file, int row, int col) {
        this(f2);
        this.loadFile(file, row, col, 0);
    }

    public Notepad(JFrame f2, File file, int row, int col, int sel) {
        this(f2);
        this.loadFile(file, row, col, sel);
    }

    public Notepad(JFrame f2, String text, int row, int col, int sel) {
        this(f2);
        this.loadString(text, row, col, sel);
    }

    public int getCaretPosition() {
        return this.getEditor().getCaretPosition();
    }

    public JDialog getDialog() {
        return this;
    }

    public boolean replace(Pattern pattern, String s2) {
        int numSubs = 1;
        Perl5Substitution substitution = new Perl5Substitution(s2);
        int r2 = -1;
        int start = -1;
        int stop = -1;
        block8: while (r2 != 1 && this.searchPattern(pattern)) {
            start = this.getEditor().getSelectionStart();
            stop = this.getEditor().getSelectionEnd();
            StringBuffer buf = new StringBuffer();
            String[] text = new String[]{"Replace?"};
            Object[] options = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            r2 = JOptionPane.showOptionDialog(this.getDialog(), text, "Confirm Substitution", 1, 3, null, options, options[0]);
            switch (r2) {
                case 0: {
                    break;
                }
                case 1: {
                    stop = ((SmiDocument)this.editor.getDocument()).getEndPosition().getOffset();
                    numSubs = -1;
                    break;
                }
                case 2: {
                    continue block8;
                }
                case 3: {
                    return false;
                }
            }
            SmiDocument doc = (SmiDocument)this.editor.getDocument();
            int length = stop - start;
            Segment seg = new Segment();
            try {
                doc.getText(start, length, seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.input = new PatternMatcherInput(new String(seg.array, seg.offset, seg.count));
            Util.substitute(buf, this.matcher, pattern, (Substitution)substitution, this.input, numSubs);
            this.getEditor().setSelectionStart(start);
            this.getEditor().setSelectionEnd(stop);
            this.getEditor().replaceSelection(buf.toString());
            this.getEditor().setCaretPosition(start + buf.toString().length());
        }
        if (r2 == 0 || r2 == 1) {
            this.setCaretPosition(start);
        }
        return true;
    }

    public boolean searchPattern(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        this.lastPattern = pattern;
        int start = 0;
        if (this.getEditor().getCaretPosition() > 0) {
            start = this.getEditor().getCaretPosition();
        }
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        int length = doc.getEndPosition().getOffset() - start;
        Segment seg = new Segment();
        try {
            doc.getText(start, length, seg);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        this.input = new PatternMatcherInput(new String(seg.array, seg.offset, length));
        if (this.matcher.contains(this.input, pattern)) {
            int pos = this.input.getMatchBeginOffset() + start;
            int len = this.input.getMatchEndOffset() - this.input.getMatchBeginOffset();
            this.editor.getCaret().setSelectionVisible(true);
            this.editor.setCaretPosition(pos);
            this.editor.moveCaretPosition(pos + len);
            return true;
        }
        this.status.setText("Search complete!");
        return false;
    }

    private Pattern makePattern(String s2, boolean quite) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this.compiler.compile(s2);
            }
            catch (MalformedPatternException e2) {
                if (quite) break block2;
                JOptionPane.showMessageDialog(this.getDialog(), e2.getMessage(), "Malformed Expression", 0);
            }
        }
        return pattern;
    }

    public boolean searchString(String s2) {
        Pattern p2 = this.makePattern(s2, true);
        if (p2 != null) {
            return this.searchPattern(p2);
        }
        return false;
    }

    public void setCaretPosition(int pos) {
        this.getEditor().setCaretPosition(pos);
    }

    public boolean setCaretPosition(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            this.editor.setCaretPosition(smidoc.getLineStartOffset(row - 1) + col - 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public void setSelectionLength(int sel) {
        this.editor.getCaret().setSelectionVisible(true);
        int len = sel;
        while (true) {
            try {
                this.editor.moveCaretPosition(this.editor.getCaretPosition() + len);
            }
            catch (IllegalArgumentException iaex) {
                if (--len > 0) continue;
            }
            break;
        }
    }

    protected void loadFile(File file, int row, int col, int sel) {
        this.setEnabled(false);
        this.file = file;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        FileLoader loader = new FileLoader(file, this.editor.getDocument());
        loader.row = row;
        loader.col = col;
        loader.selection = sel;
        loader.start();
    }

    protected void loadString(String text, int row, int col, int sel) {
        this.setEnabled(false);
        this.file = null;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Document doc = this.editor.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        try {
            this.setCaretPosition(row, col);
            this.setSelectionLength(sel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.elementTreeFrame != null) {
            this.elementTreePanel.setEditor(this.getEditor());
        }
        doc.addUndoableEditListener(this.undoHandler);
        this.status.removeAll();
        this.status.revalidate();
        this.resetUndoManager();
        this.setEnabled(true);
    }

    protected void loadFile(File file, String searchString) {
        this.setEnabled(false);
        this.file = file;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        FileLoader loader = new FileLoader(file, this.editor.getDocument());
        loader.search = searchString;
        loader.start();
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected void createErrorTable() {
        this.errorModel.setNumColumns(COLUMN_NAMES.length);
        this.errorModel.setNumRows(0);
        this.errorModel.setColumnLabels(COLUMN_NAMES);
        this.tableSorter = new TableSorter(this.errorTable, this.errorModel);
        this.errorTable.setDataSource(this.errorModel);
        this.errorTable.setPixelHeight(-997, 33001);
        this.errorTable.setRowLabelDisplay(false);
        for (int i2 = 0; i2 < this.errorModel.getNumColumns(); ++i2) {
            this.errorTable.setPixelWidth(i2, 33001);
        }
        this.errorTable.addSelectListener(this);
    }

    protected JEditorPane createEditor() {
        try {
            final JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKit(kit);
            editor.setBackground(Color.white);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            editor.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e2) {
                }

                @Override
                public void keyReleased(KeyEvent e2) {
                }

                @Override
                public void keyTyped(KeyEvent e2) {
                    if (Notepad.this.importer != null && editor.isEditable() && (e2.getModifiers() & 2) != 0) {
                        if (e2.getKeyChar() == ' ') {
                            Notepad.this.codeCompletion();
                        } else if (e2.getKeyCode() == 27 && Notepad.this.ccPopup != null) {
                            Notepad.this.disposeCodeCompletionPopup();
                        }
                    }
                }
            });
            return editor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JEditorPane getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        for (Container p2 = this.getParent(); p2 != null; p2 = p2.getParent()) {
            if (!(p2 instanceof Frame)) continue;
            return (Frame)p2;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        String sstr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((sstr = this.getResourceString(cmd + accelSuffix)) != null) {
            mi.setAccelerator(KeyStroke.getKeyStroke(sstr));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a2 = this.getAction(astr);
        if (a2 != null) {
            mi.addActionListener(a2);
            a2.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a2.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i2 = 0; i2 < toolKeys.length; ++i2) {
            if (toolKeys[i2].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(toolKeys[i2]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        ToolBarUtils.setMinimumButtonSize(this.toolbar);
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a2;
        URL url = this.getResource(key + imageSuffix);
        JButton b2 = new JButton((Icon)new ImageIcon(url)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b2.setRequestFocusEnabled(false);
        b2.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a2 = this.getAction(astr)) != null) {
            b2.setActionCommand(astr);
            a2.addPropertyChangeListener(this.createActionChangeListener(b2));
            b2.addActionListener(a2);
            b2.setEnabled(a2.isEnabled());
        } else {
            b2.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b2.setToolTipText(tip);
        }
        return b2;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i2 = 0; i2 < cmd.length; ++i2) {
            cmd[i2] = (String)v.elementAt(i2);
        }
        return cmd;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        for (int i2 = 0; i2 < menuKeys.length; ++i2) {
            JMenu m3 = this.createMenu(menuKeys[i2]);
            if (m3 == null) continue;
            mb.add(m3);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (int i2 = 0; i2 < itemKeys.length; ++i2) {
            if (itemKeys[i2].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i2]);
            menu.add(mi);
        }
        return menu;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b2) {
        ActionChangedListener listener = new ActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    protected PropertyChangeListener createActionChangeListener(JButton b2) {
        ButtonActionChangedListener listener = new ButtonActionChangedListener(b2);
        this.propertyChangeListeners.add(listener);
        return listener;
    }

    public void setImporter(MIBImporter newImporter) {
        this.importer = newImporter;
    }

    public MIBImporter getImporter() {
        return this.importer;
    }

    public void setParserMode(int newParserMode) {
        this.parserMode = newParserMode;
    }

    public int getParserMode() {
        return this.parserMode;
    }

    public void clearErrors() {
        this.errorModel.setNumRows(0);
        this.exportAllErrorsAction.setEnabled(false);
    }

    public void setError(SMIParseException pex) {
        this.errorModel.setNumRows(0);
        int n2 = 0;
        if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
            int i2 = 0;
            for (SMIParseException lpex : pex.getErrorList()) {
                if (lpex == pex) {
                    n2 = i2;
                }
                this.addRow(lpex);
                ++i2;
            }
        } else {
            this.addRow(pex);
        }
        this.errorTable.setRowSelection(n2, n2);
        this.exportAllErrorsAction.setEnabled(this.errorModel.getNumRows() > 0);
    }

    public boolean setSelectionEnd(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            int startPos = this.editor.getCaret().getDot();
            int endPos = smidoc.getLineStartOffset(row - 1) + col - 1;
            this.setSelectionLength(endPos - startPos + 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    protected void setCurrentErrorLocation(int rowIndex) {
        SMIParseException pex = (SMIParseException)this.errorModel.getTableRowLabel(rowIndex);
        if (pex.hasLocationInfo()) {
            this.setCaretPosition(pex.fileError.getLine(), pex.fileError.getColumn());
            this.setSelectionEnd(pex.fileError.getEndLine(), pex.fileError.getEndColumn());
        } else if (pex.objects != null) {
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (!this.searchString(pex.objects.get(0).toString())) {
                this.setCaretPosition(pos);
            }
        } else {
            StringTokenizer st = new StringTokenizer(pex.getMessage(), ", ");
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (st.hasMoreTokens() && !this.searchString(st.nextToken())) {
                this.setCaretPosition(pos);
            }
        }
    }

    public void print() {
        SmiContext ctx = new SmiContext();
        ctx.setSyntaxHighlighting(true);
        ctx.setStyles(SmiContext.getDefaultStyles(this.getBackground()));
        SmiTextPrintable smiPrintable = new SmiTextPrintable((SmiDocument)this.getEditor().getDocument(), new Font("SansSerif", 0, 10), this.config.getBoolean("print.header", true) ? this.getTitle() : null, this.config.getBoolean("print.footer", true) ? this.config.get("print.footerText", "{0} -- page {1}") : null, this.config.getBoolean("print.colored", false), this.config.getBoolean("print.lineNumbers", true), ctx, this.getTabSize());
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(this.getTitle());
        PageFormat pf = new PageFormat();
        pj.pageDialog(pf);
        pj.setPrintable(smiPrintable, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }

    protected byte[] getDocumentBytes() {
        Segment s2 = new Segment();
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            doc.getText(0, doc.getLength(), s2);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        return String.valueOf(s2.array, 0, doc.getLength()).getBytes();
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public String getText() {
        SmiDocument doc = (SmiDocument)this.editor.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected void addRow(SMIParseException pex) {
        Vector<Object> row = new Vector<Object>(COLUMN_NAMES.length);
        row.add(new Integer(this.errorModel.getNumRows() + 1));
        row.add(new Integer(pex.errorType));
        row.add(DefaultRepositoryManager.getErrorText(pex, false).replace('\r', ' '));
        this.errorModel.addRow(Integer.MAX_VALUE, pex, row);
    }

    @Override
    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void select(JCSelectEvent jCSelectEvent) {
    }

    @Override
    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int row = TableUtils.getFirstSelectedRow(this.errorTable);
        if (row >= 0) {
            this.setCurrentErrorLocation(row);
        }
    }

    @Override
    public void dispose() {
        for (PropertyChangeListener l2 : this.propertyChangeListeners) {
            for (Action a2 : this.commands.values()) {
                a2.removePropertyChangeListener(l2);
            }
        }
        this.propertyChangeListeners.clear();
        super.dispose();
    }

    public void setLookupModule(MIBModule lookup) {
        this.lookupData = lookup;
    }

    private static boolean isTokenSeparator(char c2) {
        return Character.isWhitespace(c2) || c2 == ',';
    }

    private SMIParseException getCompletion(String text, int maxLength) {
        try {
            int size = Math.min(maxLength, this.getCaretPosition());
            for (int i2 = size - 1; i2 >= 0; --i2) {
                if (Character.isWhitespace(text.charAt(i2))) continue;
                size = i2 + 1;
                break;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(text.substring(0, size).getBytes());
            this.importer.checkMIB(this, bis, 1);
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (SMIParseException pex) {
            return pex;
        }
    }

    private void disposeCodeCompletionPopup() {
        this.ccPopup.setVisible(false);
        this.ccPopup.dispose();
        this.ccPopup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void codeCompletion() {
        if (!this.lookupEnabled) {
            return;
        }
        if (this.lookupPool == null) {
            this.lookupPool = ThreadPool.create("SMIEditorCodeCompletion", 1);
            this.lookupUpdater = new CompletionLookupUpdater();
        }
        CompletionLookupUpdater completionLookupUpdater = this.lookupUpdater;
        synchronized (completionLookupUpdater) {
            this.lookupPool.execute(this.lookupUpdater);
            try {
                this.lookupUpdater.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String text = this.getText();
        int startPos = this.getCaretPosition();
        for (int i2 = startPos - 1; i2 >= 1; --i2) {
            if (Notepad.isTokenSeparator(text.charAt(i2))) {
                this.editor.setCaretPosition(i2 + 1);
                break;
            }
            if (i2 != 1) continue;
            this.editor.setCaretPosition(1);
            break;
        }
        SMIParseException pex = this.getCompletion(text, this.editor.getDocument().getLength());
        LinkedList<SMIParseException> completionsTokens = new LinkedList<SMIParseException>();
        if (pex != null) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                int maxPos = 0;
                for (SMIParseException ip : pex.getErrorList()) {
                    if (!ip.hasLocationInfo()) continue;
                    if (ip.fileError.getLastEndPosition() > maxPos) {
                        completionsTokens.clear();
                        completionsTokens.add(ip);
                        maxPos = ip.fileError.getLastEndPosition();
                        continue;
                    }
                    if (ip.fileError.getLastEndPosition() != maxPos || ip.fileError.getFoundTokenImage().length() <= ((SMIParseException)completionsTokens.getLast()).fileError.getFoundTokenImage().length()) continue;
                    completionsTokens.add(ip);
                }
            }
            if (completionsTokens.size() == 0) {
                return;
            }
            for (int i3 = startPos; i3 < text.length(); ++i3) {
                if (!Notepad.isTokenSeparator(text.charAt(i3))) continue;
                this.editor.moveCaretPosition(i3);
                break;
            }
            HashSet completions = new HashSet();
            for (SMIParseException p2 : completionsTokens) {
                String[] exp = p2.fileError.getLastExpectedImages();
                for (int i4 = 0; i4 < exp.length; ++i4) {
                    String s2 = exp[i4];
                    StringTokenizer st = new StringTokenizer(s2, "\"", true);
                    boolean lastWasQuote = false;
                    StringBuffer buf = new StringBuffer(s2.length());
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("\"".equals(token)) {
                            if (!lastWasQuote) continue;
                            lastWasQuote = true;
                        } else {
                            lastWasQuote = false;
                        }
                        buf.append(token);
                    }
                    this.addCompletions(buf.toString(), completions);
                }
            }
            if (this.ccPopup != null) {
                this.ccPopup.setVisible(false);
                this.ccPopup.dispose();
            }
            if (completions.isEmpty()) {
                return;
            }
            if (completions.size() == 1) {
                boolean addSpace = false;
                this.replaceCurrentSelection((String)completions.iterator().next(), addSpace);
            } else {
                this.ccPopup = new JDialog(this);
                this.ccPopup.setTitle("SMI Completion");
                Vector completionVector = new Vector(completions);
                Collections.sort(completionVector);
                this.ccPopup.getContentPane().setLayout(new BorderLayout(5, 5));
                JScrollPane spane = new JScrollPane(20, 31);
                JList completionSelection = new JList(completionVector){

                    @Override
                    public void setSelectedIndex(int selectionIndex) {
                        super.setSelectedIndex(selectionIndex);
                        super.ensureIndexIsVisible(selectionIndex);
                    }
                };
                completionSelection.setSelectedIndex(0);
                boolean addSpace = false;
                CodeCompletionListener ccl = new CodeCompletionListener(pex, this.ccPopup, completionSelection, addSpace);
                completionSelection.addMouseListener(ccl);
                completionSelection.addKeyListener(ccl);
                spane.getViewport().add(completionSelection);
                this.ccPopup.getContentPane().add((Component)spane, "Center");
                Rectangle pos = null;
                try {
                    pos = this.editor.modelToView(this.getCaretPosition());
                    Point loc = pos.getLocation();
                    loc.translate(this.editor.getLocationOnScreen().x, this.editor.getLocationOnScreen().y + 12);
                    this.ccPopup.setLocation(loc);
                }
                catch (BadLocationException ex1) {
                    ex1.printStackTrace();
                }
                this.ccPopup.pack();
                this.ccPopup.setVisible(true);
            }
        }
    }

    private void replaceCurrentSelection(String replacement, boolean addSpace) {
        Object r2 = addSpace ? " " : "";
        r2 = (String)r2 + replacement;
        this.editor.replaceSelection((String)r2);
    }

    private static boolean isTokenImage(String s2, int id) {
        return s2.startsWith(SMIParserConstants.tokenImage[id]);
    }

    private void addCompletions(String string, Set completions) {
        if (string.trim().length() == 0) {
            return;
        }
        if (this.lookupUpdater != null && this.lookupUpdater.isDone() && this.lookupData != null) {
            if (Notepad.isTokenImage(string, 120)) {
                completions.addAll(this.lookupData.getLowerCaseNames());
                return;
            }
            if (Notepad.isTokenImage(string, 119)) {
                completions.addAll(this.lookupData.getUpperCaseNames());
                return;
            }
        } else {
            if (Notepad.isTokenImage(string, 120)) {
                completions.add("lowerCaseName");
                return;
            }
            if (Notepad.isTokenImage(string, 119)) {
                completions.add("UpperCaseName");
                return;
            }
        }
        if (Notepad.isTokenImage(string, 8)) {
            completions.add("OBJECT IDENTIFIER");
        } else if (Notepad.isTokenImage(string, 9)) {
            completions.add("OCTET STRING");
        } else if (Notepad.isTokenImage(string, 11)) {
            completions.add("''h");
        } else if (Notepad.isTokenImage(string, 10)) {
            completions.add("''b");
        } else if (Notepad.isTokenImage(string, 16)) {
            completions.add("-1");
        } else if (Notepad.isTokenImage(string, 15)) {
            completions.add("1");
        } else if (Notepad.isTokenImage(string, 13)) {
            completions.add("\"\"");
        } else if (Notepad.isTokenImage(string, 12)) {
            completions.add("\"\"");
        } else {
            completions.add(string);
        }
    }

    static {
        COLUMN_NAMES = new String[]{"Number", "Error", "Description"};
        try {
            resources = ResourceBundle.getBundle("com.agentpp.notepad.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Notepad.properties not found");
        }
    }

    class ImportAction
    extends AbstractAction {
        ImportAction() {
            super("Import");
        }

        ImportAction(String nm) {
            super(nm);
        }

        public void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (Notepad.this.file == null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                try {
                    Notepad.this.importer.importMIB(Notepad.this, bis, "", Notepad.this.parserMode);
                    bis.close();
                    Notepad.this.setVisible(false);
                    Notepad.this.clearErrors();
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                }
            } else {
                try {
                    FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                    fo.write(Notepad.this.getDocumentBytes());
                    fo.close();
                    if (Notepad.this.importer != null) {
                        try {
                            Notepad.this.importer.importMIB(Notepad.this, Notepad.this.file, Notepad.this.parserMode);
                            Notepad.this.setVisible(false);
                            Notepad.this.clearErrors();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (SMIParseException pex) {
                            Notepad.this.setError(pex);
                        }
                    }
                }
                catch (IOException iox) {
                    Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
                }
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this.undoAction.update();
        }

        public void redo() {
            if (Notepad.this.undo.canRedo()) {
                try {
                    Notepad.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            Notepad.this.undoAction.update();
            Notepad.this.importActionObj.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this.redoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public void undo() {
            if (Notepad.this.undo.canUndo()) {
                try {
                    Notepad.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            Notepad.this.redoAction.update();
            Notepad.this.importActionObj.update();
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e2) {
            Notepad.this.undo.addEdit(e2.getEdit());
            Notepad.this.undoAction.update();
            Notepad.this.redoAction.update();
        }
    }

    class ExportSelectedErrorsAction
    extends AbstractAction {
        private boolean selectedOnly;

        public ExportSelectedErrorsAction(String name, boolean selectedOnly) {
            super(name);
            this.selectedOnly = selectedOnly;
            this.setEnabled(selectedOnly);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            int[] rows = TableUtils.getSelectedRows(Notepad.this.errorTable);
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            if (fc.showSaveDialog(Notepad.this.myFrame) == 0) {
                Object[] options;
                int n2;
                if (fc.getSelectedFile().exists() && (n2 = JOptionPane.showOptionDialog(Notepad.this.myFrame, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, options = new Object[]{"Yes", "Cancel"}, options[1])) == 1) {
                    return;
                }
                try {
                    FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                    StringBuffer buf = new StringBuffer();
                    TableDataModel data = Notepad.this.errorTable.getDataSource();
                    Arrays.sort(rows);
                    for (int i2 = 0; i2 < data.getNumRows(); ++i2) {
                        if (this.selectedOnly && Arrays.binarySearch(rows, i2) < 0 || data.getTableDataItem(i2, 0) instanceof String) continue;
                        buf.append(data.getTableDataItem(i2, 0).toString());
                        buf.append(": ");
                        SMIParseException pex = (SMIParseException)data.getTableRowLabel(i2);
                        buf.append(MIBObject.formatLines("\t", DefaultRepositoryManager.getErrorText(pex) + "."));
                        buf.append("\n\n");
                    }
                    fos.write(buf.toString().getBytes());
                    fos.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Notepad.this.myFrame, "Error writing report: " + ex.getMessage(), "File Error", 0);
                }
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Document oldDoc = Notepad.this.getEditor().getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(Notepad.this.undoHandler);
            }
            Notepad.this.getEditor().setDocument(new SmiDocument());
            Notepad.this.getEditor().getDocument().addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.resetUndoManager();
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(0);
            Notepad.this.fileDialog.setVisible(true);
            String file = Notepad.this.fileDialog.getFile();
            if (file == null) {
                return;
            }
            String directory = Notepad.this.fileDialog.getDirectory();
            File f2 = new File(directory, file);
            if (f2.exists()) {
                Notepad.this.setTitle(file);
                Notepad.this.loadFile(f2, 0, 0, 0);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Notepad.saveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                Notepad.this.status.setText("Saved '" + Notepad.this.file.getPath() + "'");
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super(Notepad.saveAsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(1);
            Notepad.this.fileDialog.setDirectory(Notepad.this.file.getParent());
            Notepad.this.fileDialog.setFile(Notepad.this.file.getName());
            Notepad.this.fileDialog.setVisible(true);
            String fs = Notepad.this.fileDialog.getFile();
            if (fs == null) {
                return;
            }
            String directory = Notepad.this.fileDialog.getDirectory();
            Notepad.this.file = new File(directory, fs);
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                Notepad.this.status.setText("Saved '" + Notepad.this.file.getPath() + "'");
                Notepad.this.setTitle(Notepad.this.file.getName());
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (Notepad.this.lookupPool != null) {
                Notepad.this.lookupPool.stop();
                Notepad.this.lookupPool = null;
            }
            Notepad.this.setVisible(false);
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
            super("Find");
        }

        private String getSelection() {
            if (Notepad.this.getEditor().getSelectedText() != null) {
                return Notepad.this.getEditor().getSelectedText();
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(false);
            Vector<String> v = Notepad.this.config.getArray(Notepad.CFG_SEARCH);
            if (this.getSelection() != null) {
                v.insertElementAt(this.getSelection(), 0);
            }
            sp.setSearchExpressions(v);
            StandardDialog sd = new StandardDialog((Frame)Notepad.this.myFrame, "Find", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(Notepad.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = Notepad.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                Notepad.this.config.putArray(Notepad.CFG_SEARCH, sp.getSearchExpressions());
                Notepad.this.searchPattern(p2);
                break;
            } while (sd.getResult() == 0);
        }
    }

    class ReplaceAction
    extends AbstractAction {
        ReplaceAction() {
            super("Replace");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(true);
            sp.setSearchExpressions(Notepad.this.config.getArray(Notepad.CFG_SEARCH));
            sp.setSubstitutionStrings(Notepad.this.config.getArray(Notepad.CFG_REPLACE));
            StandardDialog sd = new StandardDialog((Frame)Notepad.this.myFrame, "Replace", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(Notepad.this.myFrame);
            do {
                Pattern p2;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p2 = Notepad.this.makePattern(sp.getSearchExpression(), false)) == null) continue;
                Notepad.this.config.putArray(Notepad.CFG_SEARCH, sp.getSearchExpressions());
                Notepad.this.config.putArray(Notepad.CFG_REPLACE, sp.getSubstitutionStrings());
                Notepad.this.replace(p2, sp.getSubstitutionString());
                break;
            } while (sd.getResult() == 0);
        }
    }

    class ImportAccurateAction
    extends AbstractAction {
        ImportAccurateAction() {
            super("ImportAccurate");
        }

        ImportAccurateAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                if (Notepad.this.importer != null) {
                    try {
                        Notepad.this.clearErrors();
                        Notepad.this.importer.importMIB(Notepad.this, Notepad.this.file, 1);
                        Notepad.this.setVisible(false);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this.setError(pex);
                    }
                }
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class ImportLenientAction
    extends AbstractAction {
        ImportLenientAction() {
            super("ImportLenient");
        }

        ImportLenientAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                if (Notepad.this.importer != null) {
                    try {
                        Notepad.this.clearErrors();
                        Notepad.this.importer.importMIB(Notepad.this, Notepad.this.file, 2);
                        Notepad.this.setVisible(false);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this.setError(pex);
                    }
                }
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class CheckAccurateAction
    extends AbstractAction {
        CheckAccurateAction() {
            super("CheckAccurate");
        }

        CheckAccurateAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (Notepad.this.importer != null) {
                try {
                    Notepad.this.clearErrors();
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    Notepad.this.importer.checkMIB(Notepad.this, bis, 1);
                    bis.close();
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file passed the SMI standard syntax check successfully.", "SMI Syntax Check OK", 1);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file contains " + (pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1) + " syntax errors!", "Syntax Check Failed", 0);
                }
            }
        }
    }

    class CheckLenientAction
    extends AbstractAction {
        CheckLenientAction() {
            super("CheckLenient");
        }

        CheckLenientAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (Notepad.this.importer != null) {
                try {
                    Notepad.this.clearErrors();
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    Notepad.this.importer.checkMIB(Notepad.this, bis, 2);
                    bis.close();
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file passed the lenient SMI syntax check successfully.", "Lenient SMI Syntax Check OK", 1);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file contains " + (pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1) + " syntax errors!", "Syntax Check Failed", 0);
                }
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            super("FindNext");
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Notepad.this.searchPattern(Notepad.this.lastPattern);
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(Notepad.printAction);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            Notepad.this.print();
        }
    }

    class StatusBar
    extends JLabel
    implements CaretListener {
        public StatusBar() {
            super(" ");
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void caretUpdate(CaretEvent e2) {
            int dot = e2.getDot();
            SmiDocument smidoc = (SmiDocument)Notepad.this.editor.getDocument();
            int line = smidoc.getLineOfOffset(dot) + 1;
            int col = dot + 1 - smidoc.getLineStartOffset(smidoc.getLineOfOffset(dot));
            this.setText(line + ":" + col);
            this.setToolTipText("Cursor is located at row " + line + ", column " + col);
        }

        @Override
        public void paint(Graphics g2) {
            super.paint(g2);
        }
    }

    class FileLoader
    extends Thread {
        public int row = 0;
        public int col = 0;
        public int selection = 0;
        public String search = null;
        Document doc;
        File f;

        FileLoader(File f2, Document doc) {
            this.setPriority(4);
            this.f = f2;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                int nch;
                Notepad.this.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                Notepad.this.status.add(progress);
                Notepad.this.status.revalidate();
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                String lastline = "";
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    int el;
                    Object s2 = new String(buff, 0, nch);
                    if (lastline.length() > 0) {
                        int nl = lastline.indexOf(10);
                        if (nl >= 0) {
                            String begin = lastline.substring(0, nl);
                            s2 = ShowHtmlDialog.replaceTabs(lastline + begin) + ShowHtmlDialog.replaceTabs(((String)s2).substring(nl));
                        } else {
                            s2 = ShowHtmlDialog.replaceTabs((String)s2);
                        }
                    }
                    lastline = (el = ((String)(s2 = ShowHtmlDialog.replaceTabs((String)s2))).lastIndexOf(10)) >= 0 ? ((String)s2).substring(el + 1) : "";
                    this.doc.insertString(this.doc.getLength(), (String)s2, null);
                    progress.setValue(progress.getValue() + nch);
                }
                ((Reader)in).close();
            }
            catch (IOException e2) {
                System.err.println(e2.toString());
            }
            catch (BadLocationException e3) {
                System.err.println(e3.getMessage());
            }
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Notepad.this.elementTreePanel.setEditor(Notepad.this.getEditor());
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileLoader.this.doc.addUndoableEditListener(Notepad.this.undoHandler);
                    Notepad.this.status.removeAll();
                    Notepad.this.status.revalidate();
                    Notepad.this.resetUndoManager();
                    Notepad.this.setEnabled(true);
                    Notepad.this.editor.setEditable(true);
                    if (FileLoader.this.search != null) {
                        Notepad.this.searchString(FileLoader.this.search);
                    } else {
                        try {
                            Notepad.this.setCaretPosition(FileLoader.this.row, FileLoader.this.col);
                            Notepad.this.setSelectionLength(FileLoader.this.selection);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (e2.getPropertyName().equals("Name")) {
                String text = (String)e2.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    private class ButtonActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ButtonActionChangedListener(JButton b2) {
            this.button = b2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String propertyName = e2.getPropertyName();
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e2.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    class CompletionLookupUpdater
    implements Runnable {
        private volatile boolean done = false;

        @Override
        public synchronized void run() {
            this.notify();
            try {
                if (Notepad.this.importer != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    try {
                        MIBModule[] modules = Notepad.this.importer.parseMIBs(Notepad.this, bis, "", 2);
                        MIBModule m3 = null;
                        if (modules.length == 1) {
                            m3 = modules[0];
                        } else {
                            int maxPos = 0;
                            for (int i2 = 0; i2 < modules.length; ++i2) {
                                int p2 = modules[i2].getStartPosition();
                                if (p2 <= maxPos || p2 > Notepad.this.getCaretPosition()) continue;
                                m3 = modules[i2];
                                maxPos = p2;
                            }
                        }
                        Notepad.this.lookupData = m3;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this.lookupData = null;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.done = true;
            this.notify();
        }

        public synchronized boolean isDone() {
            return this.done;
        }
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private SMIParseException pex;
        private JDialog popup;
        private JList list;
        private boolean addSpace;

        public CodeCompletionListener(SMIParseException pex, JDialog popup, JList list, boolean addSpace) {
            this.pex = pex;
            this.popup = popup;
            this.list = list;
            this.addSpace = addSpace;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() == 2) {
                this.replace();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                this.replace();
            } else if (e2.getKeyCode() == 27) {
                this.popup.setVisible(false);
                this.popup.dispose();
            }
        }

        @Override
        public void keyReleased(KeyEvent e2) {
        }

        @Override
        public void keyTyped(KeyEvent e2) {
        }

        private void replace() {
            String s2 = (String)this.list.getSelectedValue();
            if (s2 == null) {
                return;
            }
            Notepad.this.replaceCurrentSelection(s2, this.addSpace);
            this.popup.setVisible(false);
            this.popup.dispose();
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (Notepad.this.elementTreeFrame == null) {
                try {
                    String title = resources.getString("ElementTreeFrameTitle");
                    Notepad.this.elementTreeFrame = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    Notepad.this.elementTreeFrame = new JFrame();
                }
                Notepad.this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent weeee) {
                        Notepad.this.elementTreeFrame.setVisible(false);
                    }
                });
                Container fContentPane = Notepad.this.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                Notepad.this.elementTreePanel = new ElementTreePanel(Notepad.this.getEditor());
                fContentPane.add(Notepad.this.elementTreePanel);
                Notepad.this.elementTreeFrame.pack();
            }
            Notepad.this.elementTreeFrame.setVisible(true);
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e2) {
        }
    }
}

