/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.xml;

import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smiparser.SMI;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MIBModule2XML {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private final MIBRepository rep;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MIBModule2XML(MIBRepository rep) {
        this.rep = rep;
    }

    public DOMDocument createXML(MIBModule m3, String header, String dtdURL) {
        DOMElement root = new DOMElement("smi");
        DOMDocument doc = new DOMDocument(root);
        DOMDocumentType docType = new DOMDocumentType("smi", dtdURL);
        doc.setDocType(docType);
        doc.add(new DOMComment(header));
        try {
            List<DOMElement> l2 = this.makeModule(m3);
            for (DOMElement o2 : l2) {
                root.add(o2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    private DOMElement makeDescription(String descr) {
        DOMElement description = new DOMElement("description");
        description.add(new DOMCDATA(MIBObject.getUnquotedString(descr)));
        return description;
    }

    private DOMElement makeReference(String ref) {
        DOMElement reference = new DOMElement("reference");
        reference.add(new DOMCDATA(MIBObject.getUnquotedString(ref)));
        return reference;
    }

    private DOMElement makeRevision(MIBRevision r2) {
        DOMElement revision = new DOMElement("revision");
        Date d2 = MIBModule.getDateFromUTC(MIBObject.getUnquotedString(r2.getRevision()));
        revision.addAttribute("date", dateFormat.format(d2));
        revision.add(this.makeDescription(r2.getDescription()));
        return revision;
    }

    private DOMElement makeTypeDef(MIBTextualConvention tc) {
        Enumeration<Serializable> en;
        DOMElement typedef = new DOMElement("typedef");
        String m3 = this.rep.getModuleName(tc.getModuleID());
        if (m3 != null) {
            typedef.addAttribute("parent", m3);
        }
        if (tc.getName() != null) {
            typedef.addAttribute("name", tc.getName());
        }
        typedef.addAttribute("basetype", tc.getSyntax().getSyntax());
        if (tc.hasStatus()) {
            typedef.addAttribute("status", tc.getStatus());
        }
        if (tc.getSyntax().hasRanges()) {
            en = tc.getSyntax().getRangesVector().elements();
            while (en.hasMoreElements()) {
                MIBRange r2 = en.nextElement();
                DOMElement range = new DOMElement("range");
                range.addAttribute("min", r2.getLower().toString());
                range.addAttribute("max", r2.getUpper().toString());
                typedef.add(range);
            }
        }
        if (tc.getSyntax().hasEnums()) {
            en = tc.getSyntax().getEnumsVector().elements();
            while (en.hasMoreElements()) {
                MIBEnum e2 = (MIBEnum)en.nextElement();
                DOMElement enumeration = new DOMElement("namednumber");
                enumeration.addAttribute("name", e2.getLabel());
                enumeration.addAttribute("number", e2.getValue());
                typedef.add(enumeration);
            }
        }
        if (tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.setText(MIBObject.getUnquotedString(tc.getDisplayHint()));
            typedef.add(format);
        }
        if (tc.hasDescription()) {
            typedef.add(this.makeDescription(tc.getDescription()));
        }
        if (tc.hasReference()) {
            typedef.add(this.makeReference(tc.getReference()));
        }
        return typedef;
    }

    private DOMElement makeSyntax(MIBSyntax s2) {
        DOMElement syntax = new DOMElement("syntax");
        if (!s2.hasEnums() && !s2.hasRanges()) {
            DOMElement type = new DOMElement("type");
            type.addAttribute("name", s2.getSyntax());
            type.addAttribute("module", this.getModule(s2.getSyntax()));
            syntax.add(type);
        } else {
            Enumeration<Serializable> en;
            DOMElement typedef = new DOMElement("typedef");
            typedef.addAttribute("basetype", s2.getSyntax());
            if (s2.hasRanges()) {
                en = s2.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    MIBRange r2 = (MIBRange)en.nextElement();
                    DOMElement range = new DOMElement("range");
                    range.addAttribute("min", r2.getLower().toString());
                    range.addAttribute("max", r2.getUpper().toString());
                    typedef.add(range);
                }
            }
            if (s2.hasEnums()) {
                en = s2.getEnumsVector().elements();
                while (en.hasMoreElements()) {
                    MIBEnum e2 = (MIBEnum)en.nextElement();
                    DOMElement enumeration = new DOMElement("namednumber");
                    enumeration.addAttribute("name", e2.getLabel());
                    enumeration.addAttribute("number", e2.getValue());
                    typedef.add(enumeration);
                }
            }
            syntax.add(typedef);
        }
        return syntax;
    }

    public void output(OutputStream os, Document doc, int indent) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(true);
            outputFormat.setIndentSize(indent);
            outputFormat.setNewlines(true);
            XMLWriter xmlWriter = new XMLWriter(os, outputFormat);
            xmlWriter.write(doc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DOMElement makeTypeDefs(List<MIBTextualConvention> tcs) {
        DOMElement typedefs = new DOMElement("typedefs");
        tcs = new ArrayList<MIBTextualConvention>(tcs);
        for (MIBTextualConvention tc : tcs) {
            typedefs.add(this.makeTypeDef(tc));
        }
        return typedefs;
    }

    private DOMElement makeImports(List<MIBImport> i2) {
        DOMElement imports = new DOMElement("imports");
        for (MIBImport ii : i2) {
            for (int j2 = 0; j2 < ii.getImports().length; ++j2) {
                DOMElement imp = new DOMElement("import");
                imp.addAttribute("module", ii.getSource());
                imp.addAttribute("name", ii.getImportsVector().elementAt(j2));
                imports.add(imp);
            }
        }
        return imports;
    }

    private DOMElement makeScalar(MIBObjectType ot, String t) {
        DOMElement scalar = new DOMElement(t);
        scalar.addAttribute("name", ot.getName());
        scalar.addAttribute("oid", ot.getPrintableOid());
        scalar.addAttribute("status", ot.getStatus());
        MIBTextualConvention tc = null;
        if (ot.getSyntax().getType() == 3 || ot.getSyntax().hasEnums() || ot.getSyntax().hasRanges()) {
            tc = this.rep.getEffectiveSyntax(ot.getSyntax());
        }
        scalar.add(this.makeSyntax(ot.getSyntax()));
        DOMElement access = new DOMElement("access");
        access.setText(this.getAccessString(ot.getAccess()));
        scalar.add(access);
        if (ot.hasDefaultValue()) {
            DOMElement defaultValue = new DOMElement("default");
            defaultValue.add(new DOMCDATA(ot.getDefaultValue()));
            scalar.add(defaultValue);
        }
        if (tc != null && tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.add(new DOMCDATA(MIBObject.getUnquotedString(tc.getDisplayHint())));
            scalar.add(format);
        }
        if (ot.hasUnits()) {
            DOMElement units = new DOMElement("units");
            units.add(new DOMCDATA(MIBObject.getUnquotedString(ot.getUnits())));
            scalar.add(units);
        }
        scalar.add(this.makeDescription(ot.getDescription()));
        if (ot.hasReference()) {
            scalar.add(this.makeReference(ot.getReference()));
        }
        return scalar;
    }

    private DOMElement makeLinkage(MIBIndexPart index, MIBObjectType ot) {
        DOMElement linkage = new DOMElement("linkage");
        linkage.addAttribute("implied", "" + index.isImplied());
        if (index.isAugment()) {
            DOMElement augments = new DOMElement("augments");
            MIBObject o2 = this.rep.getObject(index.getIndexPart()[0]);
            if (o2 != null) {
                String string = this.rep.getModuleName(o2.getModuleID());
                if (string != null) {
                    augments.addAttribute("module", string);
                } else {
                    augments.addAttribute("module", "");
                }
            } else {
                augments.addAttribute("module", "");
            }
            augments.addAttribute("name", index.getIndexPart()[0]);
            linkage.add(augments);
        } else {
            Vector<? extends MIBObjectType> v = this.rep.getColumnarObjectsOfTable(ot, true, false);
            for (MIBObject mIBObject : v) {
                DOMElement ind = new DOMElement("index");
                MIBObjectType o3 = (MIBObjectType)mIBObject;
                String m4 = this.rep.getModuleName(o3.getModuleID());
                if (m4 != null) {
                    ind.addAttribute("module", m4);
                } else {
                    ind.addAttribute("module", "");
                }
                ind.addAttribute("name", o3.getName());
                linkage.add(ind);
            }
        }
        return linkage;
    }

    private DOMElement makeRow(MIBObjectType ot) {
        DOMElement row = new DOMElement("row");
        row.addAttribute("name", ot.getName());
        row.addAttribute("oid", ot.getPrintableOid());
        row.addAttribute("status", ot.getStatus());
        row.add(this.makeLinkage(ot.getIndexPart(), ot));
        row.add(this.makeDescription(ot.getDescription()));
        if (ot.hasReference()) {
            row.add(this.makeReference(ot.getReference()));
        }
        Vector<? extends MIBObjectType> cols = this.rep.getColumnarObjectsOfTable(ot, false, true);
        boolean rowCreation = false;
        Enumeration<? extends MIBObjectType> en = cols.elements();
        while (en.hasMoreElements()) {
            MIBObjectType c2 = en.nextElement();
            row.add(this.makeScalar(c2, "column"));
            if (SMI.accessType(c2.getAccess()) != 3) continue;
            rowCreation = true;
        }
        if (rowCreation) {
            row.addAttribute("create", "true");
        } else {
            row.addAttribute("create", "false");
        }
        return row;
    }

    private DOMElement makeNodes(Enumeration en) {
        DOMElement nodes = new DOMElement("nodes");
        while (en.hasMoreElements()) {
            MIBObject o2 = (MIBObject)en.nextElement();
            if (!o2.getClass().equals(MIBObject.class) && !(o2 instanceof MIBObjectType) && !(o2 instanceof MIBModule)) continue;
            if (o2 instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o2;
                MIBObjectType row = this.rep.getTableEntry(o2);
                if (row != null) {
                    DOMElement table = new DOMElement("table");
                    table.addAttribute("name", ot.getName());
                    table.addAttribute("oid", ot.getPrintableOid());
                    table.addAttribute("status", ot.getStatus());
                    table.add(this.makeDescription(ot.getDescription()));
                    if (ot.hasReference()) {
                        table.add(this.makeReference(ot.getReference()));
                    }
                    table.add(this.makeRow(row));
                    nodes.add(table);
                    continue;
                }
                if (ot.isTable() || ot.isColumnarObject()) continue;
                nodes.add(this.makeScalar(ot, "scalar"));
                continue;
            }
            DOMElement node = new DOMElement("node");
            node.addAttribute("name", o2.getName());
            node.addAttribute("oid", o2.getPrintableOid());
            if (o2.hasDescription()) {
                node.add(this.makeDescription(o2.getDescription()));
            }
            if (o2.hasReference()) {
                node.add(this.makeReference(o2.getReference()));
            }
            if (o2.hasStatus()) {
                node.addAttribute("status", o2.getStatus());
            }
            nodes.add(node);
        }
        return nodes;
    }

    private String getModule(String objectName) {
        String module = "";
        try {
            String m3;
            MIBObject obj = this.rep.getObject(objectName);
            if (obj != null && (m3 = this.rep.getModuleName(obj.getModuleID())) != null) {
                module = m3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    private DOMElement makeGroups(Enumeration<MIBObject> en) {
        DOMElement groups = new DOMElement("groups");
        while (en.hasMoreElements()) {
            MIBObject o2 = en.nextElement();
            if (!(o2 instanceof MIBGroup)) continue;
            MIBGroup g2 = (MIBGroup)o2;
            DOMElement group = new DOMElement("group");
            group.addAttribute("name", o2.getName());
            group.addAttribute("oid", o2.getPrintableOid());
            group.addAttribute("status", o2.getStatus());
            DOMElement members = new DOMElement("members");
            Enumeration<String> gen = g2.getObjectsVector().elements();
            while (gen.hasMoreElements()) {
                String name = gen.nextElement();
                DOMElement member = new DOMElement("member");
                member.addAttribute("module", this.getModule(name));
                member.addAttribute("name", name);
                members.add(member);
            }
            group.add(members);
            group.add(this.makeDescription(o2.getDescription()));
            if (o2.hasReference()) {
                group.add(this.makeReference(o2.getReference()));
            }
            groups.add(group);
        }
        return groups;
    }

    private DOMElement makeRefinement(MIBException variation) {
        DOMElement refinement = new DOMElement("refinement");
        refinement.addAttribute("module", this.getModule(variation.getVariation()));
        refinement.addAttribute("name", variation.getVariation());
        if (variation.hasSyntax()) {
            refinement.add(this.makeSyntax(variation.getSyntax()));
        }
        if (variation.hasAccess()) {
            DOMElement access = new DOMElement("access");
            access.setText(this.getAccessString(variation.getAccess()));
            refinement.add(access);
        }
        refinement.add(this.makeDescription(variation.getDescription()));
        return refinement;
    }

    private DOMElement makeCompliances(Enumeration<MIBObject> en) {
        DOMElement compliances = new DOMElement("compliances");
        while (en.hasMoreElements()) {
            MIBObject o2 = en.nextElement();
            if (!(o2 instanceof MIBCompliance)) continue;
            MIBCompliance c2 = (MIBCompliance)o2;
            DOMElement comp = new DOMElement("compliance");
            comp.addAttribute("name", o2.getName());
            comp.addAttribute("oid", o2.getPrintableOid());
            if (o2.hasStatus()) {
                comp.addAttribute("status", o2.getStatus());
            }
            comp.add(this.makeDescription(o2.getDescription()));
            DOMElement requires = new DOMElement("requires");
            DOMElement refinements = new DOMElement("refinements");
            boolean refined = false;
            Enumeration gen = c2.getModules().elements();
            while (gen.hasMoreElements()) {
                MIBComplianceModule cm = (MIBComplianceModule)gen.nextElement();
                if (cm.hasMandatory()) {
                    String[] mand;
                    for (String s2 : mand = cm.getMandatory()) {
                        DOMElement mandatory = new DOMElement("mandatory");
                        if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                            mandatory.addAttribute("module", this.getModule(s2));
                        } else {
                            mandatory.addAttribute("module", cm.getModuleName());
                        }
                        mandatory.addAttribute("name", s2);
                        requires.add(mandatory);
                    }
                }
                if (!cm.hasVariations()) continue;
                Enumeration ven = cm.getVariationsVector().elements();
                while (ven.hasMoreElements()) {
                    MIBVariation vv = (MIBVariation)ven.nextElement();
                    if (vv instanceof MIBException) {
                        refinements.add(this.makeRefinement((MIBException)vv));
                        refined = true;
                        continue;
                    }
                    if (!(vv instanceof MIBCondGroup)) continue;
                    MIBCondGroup cg = (MIBCondGroup)vv;
                    DOMElement cond = new DOMElement("option");
                    if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                        cond.addAttribute("module", this.getModule(cg.getVariation()));
                    } else {
                        cond.addAttribute("module", cm.getModuleName());
                    }
                    cond.addAttribute("name", cg.getVariation());
                    cond.add(this.makeDescription(cg.getDescription()));
                    requires.add(cond);
                }
            }
            comp.add(requires);
            if (refined) {
                comp.add(refinements);
            }
            if (o2.hasReference()) {
                comp.add(this.makeReference(o2.getReference()));
            }
            compliances.add(comp);
        }
        return compliances;
    }

    private List<DOMElement> makeModule(MIBModule m3) {
        Vector<MIBTextualConvention> tcs;
        ArrayList<DOMElement> v = new ArrayList<DOMElement>();
        DOMElement module = new DOMElement("module");
        module.addAttribute("name", m3.getModuleName());
        module.addAttribute("language", "SMIv" + m3.getSMIVersion());
        if (m3.getSMIVersion() > 1) {
            DOMElement organization = new DOMElement("organization");
            organization.add(new DOMCDATA(MIBObject.getUnquotedString(m3.getOrganization())));
            module.add(organization);
            DOMElement contact = new DOMElement("contact");
            contact.add(new DOMCDATA(MIBObject.getUnquotedString(m3.getContactInfo())));
            module.add(contact);
            module.add(this.makeDescription(m3.getDescription()));
            if (m3.hasReference()) {
                module.add(this.makeReference(m3.getReference()));
            }
            if (m3.hasRevisions()) {
                Enumeration en = m3.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    module.add(this.makeRevision((MIBRevision)en.nextElement()));
                }
            }
            DOMElement identity = new DOMElement("identity");
            identity.addAttribute("node", m3.getName());
            module.add(identity);
        }
        v.add(module);
        if (m3.hasImports()) {
            v.add(this.makeImports(m3.getImportsVector()));
        }
        if ((tcs = m3.getTextualConventions()).size() > 0) {
            v.add(this.makeTypeDefs(tcs));
        }
        v.add(this.makeNodes(m3.objectsByOid().elements()));
        v.add(this.makeNotifications(m3));
        v.add(this.makeGroups(m3.objectsByOid().elements()));
        v.add(this.makeCompliances(m3.objectsByOid().elements()));
        return v;
    }

    private DOMElement makeNotifications(MIBModule module) {
        DOMElement nodes = new DOMElement("notifications");
        Enumeration elements = module.objectsByOid().elements();
        while (elements.hasMoreElements()) {
            MIBObject o2 = (MIBObject)elements.nextElement();
            if (!(o2 instanceof MIBNotifyType)) continue;
            MIBNotifyType nt = (MIBNotifyType)o2;
            DOMElement node = new DOMElement("notification");
            node.addAttribute("name", nt.getName());
            node.addAttribute("oid", nt.getPrintableOid());
            if (nt.hasDescription()) {
                node.add(this.makeDescription(o2.getDescription()));
            }
            if (nt.hasReference()) {
                node.add(this.makeReference(o2.getReference()));
            }
            if (nt.hasStatus()) {
                node.addAttribute("status", o2.getStatus());
            }
            DOMElement objects = new DOMElement("objects");
            if (nt.hasVariables()) {
                for (String objectName : nt.getVariables()) {
                    DOMElement object = new DOMElement("object");
                    String moduleName = module.getImportSource(objectName);
                    if (moduleName != null) {
                        object.addAttribute("module", moduleName);
                    } else {
                        object.addAttribute("module", module.getModuleName());
                    }
                    object.addAttribute("name", objectName);
                    objects.add(object);
                }
            }
            node.add(objects);
            nodes.add(node);
        }
        return nodes;
    }

    private String getAccessString(String access) {
        switch (SMI.accessType(access)) {
            case 5: {
                return "notifyonly";
            }
            case 0: {
                return "noaccess";
            }
            case 6: {
                return "notimplemented";
            }
            case 2: 
            case 3: {
                return "readwrite";
            }
            case 1: {
                return "readonly";
            }
            case 4: {
                return "writeonly";
            }
        }
        return "unknown";
    }
}

