/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.util.UserConfigFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import rst.pdfbox.layout.text.Constants;

public class PDFPageSetupPanel
extends JPanel {
    public static final String[] PAGE_SIZES_DESCR = new String[]{"A0", "A1", "A2", "A3", "A4", "A5", "A6", "Letter"};
    private static final String CFG_FONT_SIZE = "com.agentpp.pdf.font.size";
    private static final String CFG_LEADING = "com.agentpp.pdf.font.leading";
    private static final String CFG_PAGE_NUMBERS = "com.agentpp.pdf.page.numbers";
    private static final String CFG_PAGE_SIZE = "com.agentpp.pdf.page.size";
    private static final String CFG_KEEP_TOGETHER = "com.agentpp.pdf.keep.together";
    private static final String CFG_OUTLINE_TREE = "com.agentpp.pdf.outline.tree";
    private static final String CFG_PAGE_DATE = "com.agentpp.pdf.page.date";
    public static final String CFG_PAGE_MARGIN_LEFT = "com.agentpp.pdf.page.margin.left";
    public static final String CFG_PAGE_MARGIN_RIGHT = "com.agentpp.pdf.page.margin.right";
    public static final String CFG_PAGE_MARGIN_TOP = "com.agentpp.pdf.page.margin.top";
    public static final String CFG_PAGE_MARGIN_BOTTOM = "com.agentpp.pdf.page.margin.bottom";
    public static final PDRectangle[] PAGE_SIZES = new PDRectangle[]{Constants.A0, Constants.A1, Constants.A2, Constants.A3, Constants.A4, Constants.A5, Constants.A6, Constants.Letter};
    private JLabel jLabelPageSize = new JLabel();
    private JComboBox pageSize = new JComboBox();
    private JCheckBox pageNumbers = new JCheckBox();
    private JLabel jLabelPageNumbers = new JLabel();
    private Border border1;
    private TitledBorder titledBorder1;
    private JSlider leading = new JSlider();
    private JLabel jLabelFontSize = new JLabel();
    private JSlider fontSize = new JSlider();
    private JPanel pageLayout = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel fontSettings = new JPanel();
    private Border border3;
    private TitledBorder titledBorder2;
    private Border border4;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Border border5;
    private TitledBorder titledBorder3;
    private Border border6;
    private JLabel jLabelKeepTogether = new JLabel();
    private JCheckBox keepObjectsTogether = new JCheckBox();
    private JPanel jPanelOutline = new JPanel();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JRadioButton flatTree = new JRadioButton();
    private JRadioButton treeOutline = new JRadioButton();
    private ButtonGroup buttonGroupOutlineTree = new ButtonGroup();
    private Border border7;
    private TitledBorder titledBorder4;
    private Border border8;
    private JCheckBox displayCurrentDate = new JCheckBox();

    public PDFPageSetupPanel() {
        this(true);
    }

    public PDFPageSetupPanel(boolean withUI) {
        for (String s2 : PAGE_SIZES_DESCR) {
            this.pageSize.addItem(s2);
        }
        if (withUI) {
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.treeOutline.setSelected(true);
        }
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "PDF Page Layout");
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Font Settings");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border5 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder3 = new TitledBorder(this.border5, "Page Layout");
        this.border6 = BorderFactory.createCompoundBorder(this.titledBorder3, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border7 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder4 = new TitledBorder(this.border7, "Outline");
        this.border8 = BorderFactory.createCompoundBorder(this.titledBorder4, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabelPageSize.setText("Page Size:");
        this.setLayout(this.borderLayout1);
        this.pageNumbers.setToolTipText("If selected, page numbers are displayed on the page footer");
        this.pageNumbers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                PDFPageSetupPanel.this.pageNumbers_itemStateChanged(e2);
            }
        });
        this.jLabelPageNumbers.setToolTipText("");
        this.jLabelPageNumbers.setText("Page Footer:");
        this.jLabelFontSize.setText("Font Size:");
        this.fontSize.setMajorTickSpacing(5);
        this.fontSize.setMaximum(20);
        this.fontSize.setMinimum(5);
        this.fontSize.setMinorTickSpacing(1);
        this.fontSize.setPaintLabels(true);
        this.fontSize.setPaintTicks(true);
        this.pageLayout.setLayout(this.gridBagLayout2);
        this.fontSettings.setBorder(this.border4);
        this.fontSettings.setLayout(this.gridBagLayout1);
        this.pageLayout.setBorder(this.border6);
        this.jLabelKeepTogether.setText("Keep Objects Together:");
        this.keepObjectsTogether.setToolTipText("Try to avoid page breaks within MIB object definitions");
        this.jPanelOutline.setLayout(this.gridBagLayout3);
        this.flatTree.setToolTipText("Creates a flat outline tree that lists all MIB objects in order of appearance in the MIB module");
        this.flatTree.setText("Flat");
        this.treeOutline.setToolTipText("Creates an outline tree based on the OID tree defined in the MIB module");
        this.treeOutline.setText("Tree");
        this.jPanelOutline.setBorder(this.border8);
        this.displayCurrentDate.setToolTipText("Print the current date in the page footer");
        this.displayCurrentDate.setHorizontalTextPosition(10);
        this.displayCurrentDate.setText("With Current Date:");
        this.pageLayout.add((Component)this.jLabelPageSize, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pageLayout.add((Component)this.pageSize, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.pageLayout.add((Component)this.pageNumbers, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.pageLayout.add((Component)this.jLabelPageNumbers, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.pageLayout.add((Component)this.jLabelKeepTogether, new GridBagConstraints(0, 3, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.fontSettings.add((Component)this.jLabelFontSize, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.fontSettings.add((Component)this.fontSize, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jPanelOutline, "Center");
        this.add((Component)this.pageLayout, "North");
        this.add((Component)this.fontSettings, "South");
        this.pageLayout.add((Component)this.keepObjectsTogether, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.pageLayout.add((Component)this.displayCurrentDate, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelOutline.add((Component)this.flatTree, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.buttonGroupOutlineTree.add(this.treeOutline);
        this.buttonGroupOutlineTree.add(this.flatTree);
        this.jPanelOutline.add((Component)this.treeOutline, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    public boolean isKeepTogether() {
        return this.keepObjectsTogether.isSelected();
    }

    public boolean isDisplayPageNumbers() {
        return this.pageNumbers.isSelected();
    }

    public PDRectangle getPageSizeRectangle() {
        return PAGE_SIZES[this.pageSize.getSelectedIndex()];
    }

    public int getPageSize() {
        return this.pageSize.getSelectedIndex();
    }

    public int getFontSize() {
        return this.fontSize.getValue();
    }

    public boolean isOutlineAsTree() {
        return this.treeOutline.isSelected();
    }

    public void save(UserConfigFile config) {
        config.putInteger(CFG_FONT_SIZE, this.getFontSize());
        config.putBoolean(CFG_KEEP_TOGETHER, this.isKeepTogether());
        config.putBoolean(CFG_PAGE_NUMBERS, this.isDisplayPageNumbers());
        config.putInteger(CFG_PAGE_SIZE, this.getPageSize());
        config.putBoolean(CFG_OUTLINE_TREE, this.treeOutline.isSelected());
        config.putBoolean(CFG_PAGE_DATE, this.isDisplayCurrentDate());
    }

    public boolean isDisplayCurrentDate() {
        return this.displayCurrentDate.isSelected();
    }

    public void load(UserConfigFile config) {
        this.pageSize.setSelectedIndex(config.getInteger(CFG_PAGE_SIZE, 5));
        this.leading.setValue(config.getInteger(CFG_LEADING, 11));
        this.fontSize.setValue(config.getInteger(CFG_FONT_SIZE, 10));
        this.pageNumbers.setSelected(config.getBoolean(CFG_PAGE_NUMBERS, true));
        this.keepObjectsTogether.setSelected(config.getBoolean(CFG_KEEP_TOGETHER, true));
        this.treeOutline.setSelected(config.getBoolean(CFG_OUTLINE_TREE, true));
        this.displayCurrentDate.setSelected(config.getBoolean(CFG_PAGE_DATE, true));
        if (!this.isDisplayPageNumbers()) {
            this.displayCurrentDate.setEnabled(false);
        }
    }

    void pageNumbers_itemStateChanged(ItemEvent e2) {
        this.displayCurrentDate.setEnabled(e2.getStateChange() != 2);
    }
}

