/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.DefaultResourceCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import rst.pdfbox.layout.elements.Document;
import rst.pdfbox.layout.elements.Orientation;
import rst.pdfbox.layout.elements.PageFormat;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.elements.render.ColumnLayout;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.RenderListener;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.DrawContext;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFlow;
import rst.pdfbox.layout.text.TextFlowUtil;
import rst.pdfbox.layout.text.TextSequenceUtil;
import rst.pdfbox.layout.text.annotations.Annotated;
import rst.pdfbox.layout.text.annotations.AnnotatedStyledText;
import rst.pdfbox.layout.text.annotations.AnnotationProcessor;
import rst.pdfbox.layout.text.annotations.AnnotationProcessorFactory;
import rst.pdfbox.layout.text.annotations.Annotations;

public class MIBModule2PDF {
    private static final String STYLE_COMMENT = "Comments";
    private static final String STYLE_KEYWORD = "Keywords";
    private static final String STYLE_IDENTIFIER = "Identifier";
    private static final String STYLE_VALUE = "Values";
    private static final String STYLE_TYPE = "Types";
    private static final String STYLE_CLAUSE = "Clauses";
    private static final String STYLE_TEXT = "Text";
    private static final int TREE_MODE = 160;
    private static final int FLAT_MODE = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository rep;
    private List<FontStyle> fontStyles;
    private int tabSize = 8;
    private int smiversion = 2;
    private int mode = 160;
    private float leading = 11.0f;
    private float fontSize = 10.0f;
    private String moduleName = "";
    private Date currentDate;
    private PDFont defaultFont = PDType1Font.COURIER;
    private Map<String, FontAndColor> fonts = new HashMap<String, FontAndColor>();
    private boolean keepTogether;
    private boolean displayPageNumbers;
    private boolean outlineTree = true;
    private boolean showBookmarks = true;
    private LinkedHashMap<String, Object> bookmarks = new LinkedHashMap();
    private int lastBookmark = 0;
    private boolean displayCurrentDate;

    public MIBModule2PDF(MIBRepository rep, List<FontStyle> fontStyles, int tabSize) {
        this.rep = rep;
        this.fontStyles = fontStyles;
        this.tabSize = tabSize;
        this.initFonts(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    private void initFonts(List<FontStyle> fontStyles) {
        for (FontStyle style : fontStyles) {
            PDFont font = this.defaultFont;
            if (style.isBold() && style.isItalic()) {
                font = PDType1Font.COURIER_BOLD_OBLIQUE;
            } else if (style.isBold()) {
                font = PDType1Font.COURIER_BOLD;
            } else if (style.isItalic()) {
                font = PDType1Font.COURIER_OBLIQUE;
            }
            FontAndColor fontAndColor = new FontAndColor(new FontDescriptor(font, this.fontSize), style.getColor());
            this.fonts.put(style.getName(), fontAndColor);
        }
    }

    private String tab(int num) {
        StringBuilder buf = new StringBuilder(num);
        for (int i2 = 0; i2 < num * this.tabSize; ++i2) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m3, OutputStream os, String creator, PDRectangle pageSize, int marginLeft, int marginRight, int marginTop, int marginBottom) {
        Paragraph p2;
        if (pageSize == null) {
            pageSize = PDRectangle.A4;
        }
        this.currentDate = new Date();
        this.smiversion = m3.getSMIVersion();
        this.moduleName = m3.getModuleName();
        PageFormat pageFormat = new PageFormat(pageSize, Orientation.Portrait, marginLeft, marginRight, marginTop, marginBottom);
        AnnotationProcessorFactory.register(BookmarkAnnotationProcessor.class);
        Document doc = new Document(pageFormat);
        PDDocumentInformation documentInformation = new PDDocumentInformation();
        documentInformation.setAuthor(System.getProperty("user.name"));
        documentInformation.setCreator(creator);
        documentInformation.setTitle(m3.getModuleName());
        documentInformation.setKeywords(m3.getModuleName() + ", " + (m3.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", MIB specification");
        doc.getPDDocument().setDocumentInformation(documentInformation);
        ColumnLayout layout = new ColumnLayout(1, 0.0f);
        layout.setRemoveLeadingEmptyVerticalSpace(false);
        doc.add(layout);
        this.initBookmarks(m3);
        PDDocumentOutline outline = new PDDocumentOutline();
        doc.getPDDocument().setResourceCache(new ResourceCacheWithBookmarks(new DefaultResourceCache(), this.bookmarks, this.rep, this.isOutlineAsTree()));
        doc.getPDDocument().getDocumentCatalog().setDocumentOutline(outline);
        doc.addRenderListener(new RenderListener(){

            @Override
            public void beforePage(RenderContext renderContext) {
            }

            @Override
            public void afterPage(RenderContext renderContext) throws IOException {
                String content;
                if (!MIBModule2PDF.this.displayPageNumbers) {
                    return;
                }
                float marginLeft = renderContext.getDocument().getPageFormat().getMarginLeft();
                int pageN = renderContext.getPageIndex() + 1;
                TextFlow text = TextFlowUtil.createTextFlow(MIBModule2PDF.this.moduleName, 10.0f, PDType1Font.TIMES_ROMAN);
                text.drawText(renderContext.getContentStream(), new Position(marginLeft, 30.0f), Alignment.Left, null);
                if (MIBModule2PDF.this.displayCurrentDate) {
                    content = df.format(MIBModule2PDF.this.currentDate);
                    text = TextFlowUtil.createTextFlow(content, 10.0f, PDType1Font.TIMES_ROMAN);
                    text.drawText(renderContext.getContentStream(), new Position(marginLeft + renderContext.getWidth() / 2.0f - text.getWidth() / 2.0f, 30.0f), Alignment.Right, null);
                }
                content = String.format("Page %s", pageN);
                text = TextFlowUtil.createTextFlow(content, 10.0f, PDType1Font.TIMES_ROMAN);
                float offset = marginLeft + TextSequenceUtil.getOffset(text, renderContext.getWidth(), Alignment.Right);
                text.drawText(renderContext.getContentStream(), new Position(offset, 30.0f), Alignment.Right, null);
            }
        });
        if (m3.hasCopyrightComment()) {
            p2 = new Paragraph();
            p2.add(new TextParagraph(m3.getCopyrightComment(), this.fonts.get(STYLE_COMMENT)));
            doc.add(p2);
        }
        p2 = new Paragraph();
        p2.add(new NewLine());
        doc.add(p2);
        this.writeModule(doc, m3);
        if (m3.hasCopyrightCommentEnd()) {
            p2.add(new TextParagraph(m3.getCopyrightCommentEnd(), this.fonts.get(STYLE_COMMENT)));
            doc.add(p2);
        }
        try {
            doc.save(os);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static TextFlow newline(TextFlow p2) {
        p2.add(new NewLine());
        return p2;
    }

    public static void convertNewLinesToFlow(String text, FontAndColor fontAndColor, TextFlow textFlow) {
        if (text == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.equals("\n")) {
                MIBModule2PDF.newline(textFlow);
                continue;
            }
            textFlow.add(new StyledText(line, fontAndColor.getFontDescriptor().getSize(), fontAndColor.getFontDescriptor().getFont(), fontAndColor.getColor()));
        }
    }

    private void initBookmarks(MIBModule m3) {
        this.bookmarks = new LinkedHashMap();
        this.lastBookmark = 0;
    }

    private Chunk keyWord(String keyword) {
        return new Chunk(keyword, this.fonts.get(STYLE_KEYWORD));
    }

    private Chunk normal(String text) {
        return new Chunk(text, new FontAndColor(new FontDescriptor(this.defaultFont, this.fontSize), Color.black));
    }

    private Chunk comment(String text) {
        return new Chunk(text, this.fonts.get(STYLE_COMMENT));
    }

    private Chunk text(String text) {
        return new Chunk(text, this.fonts.get(STYLE_TEXT));
    }

    private TextFlow text(int ident, String lines) {
        String prefix = this.tab(ident);
        if (lines == null) {
            return new TextParagraph(prefix + "\"\"", this.fonts.get(STYLE_TEXT));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Paragraph p2 = new Paragraph();
        while (st.hasMoreTokens()) {
            String s2 = st.nextToken();
            if (s2.equals("\n")) {
                p2.add(this.text(s2));
                continue;
            }
            if (s2.equals("\r")) continue;
            p2.add(this.text(prefix + s2));
        }
        return p2;
    }

    private Chunk clause(String text) {
        return new Chunk(text, this.fonts.get(STYLE_CLAUSE));
    }

    private Chunk type(String text) {
        return new Chunk(text, this.fonts.get(STYLE_TYPE));
    }

    private Chunk value(String value) {
        return new Chunk(value, this.fonts.get(STYLE_VALUE));
    }

    private Chunk identifier(String value) {
        return new Chunk(value, this.fonts.get(STYLE_IDENTIFIER));
    }

    private Paragraph objectLink(String objectName, String moduleName) {
        String objectNameRef = MIBModule2PDF.sanitizeLinkName(objectName);
        Paragraph chunk = new Paragraph();
        FontAndColor fontAndColor = this.fonts.get(STYLE_IDENTIFIER);
        String txt = moduleName != null ? "{link[#" + moduleName + "." + objectNameRef + "]}" + moduleName + "." + objectName + "{link}" : "{link[#" + objectNameRef + "]}" + objectName + "{link}";
        this.addMarkupText(chunk, fontAndColor, txt);
        return chunk;
    }

    private void writeRange(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this.value(range.getUpper().toString()));
        } else {
            doc.add(this.value(range.getLower().toString()));
            doc.add(this.normal(".."));
            doc.add(this.value(range.getUpper().toString()));
        }
    }

    private void writeEnum(Paragraph doc, IEnum enumeration) {
        doc.add(this.identifier(enumeration.getLabel()));
        doc.add(this.normal("("));
        doc.add(this.value(enumeration.getValue()));
        doc.add(this.normal(")"));
    }

    private void writeSyntax(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this.keyWord("SEQUENCE OF "));
                doc.add(this.value(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this.rep.getObject(syn.getSyntax()) != null) {
                    doc.add(this.objectLink(syn.getSyntax(), null));
                } else {
                    doc.add(this.type(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this.rep.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this.normal(" ("));
                    doc.add(this.keyWord("SIZE"));
                }
                doc.add(this.normal(" ("));
                Enumeration<MIBRange> en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this.writeRange(doc, en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this.normal(" | "));
                }
                doc.add(this.normal(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this.normal(")"));
            }
        }
        if (syn.hasEnums()) {
            this.writeEnums(doc, syn.getEnumsVector());
        }
    }

    private void writeEnums(Paragraph doc, List<MIBEnum> enums) {
        doc.add(this.normal(" {\n" + this.tab(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this.writeEnum(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add(this.normal(","));
                } else {
                    doc.add(this.normal(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add(this.normal(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add(this.comment(this.tab(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add(this.normal("\n" + this.tab(4) + MIBObject.space(max)));
                        doc.add(this.comment(st.nextToken()));
                    }
                }
                doc.add(this.normal("\n" + this.tab(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add(this.normal(",\n" + this.tab(3)));
                continue;
            }
            doc.add(this.normal(" "));
        }
        doc.add(this.normal("}"));
    }

    private void writeSmiDefBegin(Paragraph doc, MIBObject o2) {
        doc.add(this.normal(this.tab(1)));
        doc.add(this.clause("STATUS      "));
        if (!o2.hasStatus()) {
            doc.add(this.normal("current"));
        } else {
            doc.add(this.normal(o2.getStatus()));
        }
        doc.add(this.normal("\n" + this.tab(1)));
        doc.add(this.clause("DESCRIPTION"));
        if (!o2.hasDescription()) {
            doc.add(this.text(" \"\"\n"));
        } else {
            doc.add(this.normal("\n"));
            doc.add(this.text(2, o2.getDescription()));
            doc.add(this.normal("\n"));
        }
        if (o2 instanceof PIBObjectType) {
            doc.add(this.normal(this.tab(1)));
            doc.add(this.clause("INSTALL-ERRORS"));
            this.writeEnums(doc, ((PIBObjectType)o2).getInstallErrors());
            doc.add(this.normal("\n"));
        }
        if (o2.hasReference()) {
            doc.add(this.normal(this.tab(1)));
            doc.add(this.clause("REFERENCE"));
            doc.add(this.text(2, o2.getReference()));
            doc.add(this.normal("\n"));
        }
    }

    private void writeObjectID(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this.normal("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                doc.add(this.objectLink((String)(qualified != null ? qualified + "." + parent.getName() : parent.getName()), qualified));
            }
            doc.add(this.normal(" "));
            for (int i2 = oid.size() - diff; i2 < oid.size(); ++i2) {
                String oname = null;
                if (i2 + 1 < oid.size()) {
                    this.rep.getObjectName(oid.getPrefix(i2 + 1));
                }
                if (oname != null) {
                    doc.add(this.identifier(oname));
                    doc.add(this.normal("("));
                    doc.add(this.value(oid.getSubID(i2)));
                    doc.add(this.normal(")"));
                } else {
                    doc.add(this.value(oid.getSubID(i2)));
                }
                doc.add(this.normal(" "));
            }
            doc.add(this.normal("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this.normal("{ " + oid.toString() + " }"));
        }
    }

    private void writeSmiOidDef(Paragraph doc, MIBObject o2, MIBObject parent) {
        MIBObject[] parents = this.rep.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this.writeObjectID(doc, o2.getOid(), parent, null);
        } else {
            String m3 = this.rep.getModuleName(parent.getModuleID());
            if (m3 == null) {
                this.writeObjectID(doc, o2.getOid(), parent, null);
            } else {
                this.writeObjectID(doc, o2.getOid(), parent, m3);
            }
        }
    }

    private void writeSmiDefEnd(Paragraph doc, MIBObject o2) {
        if ((this.mode & 0x20) > 0) {
            if ((this.mode & 0x400) > 0) {
                doc.add(this.comment(" -- " + o2.getPrintableOid() + " --  "));
            } else {
                doc.add(this.normal(this.tab(1)));
                doc.add(this.comment("-- " + o2.getPrintableOid()));
                doc.add(this.normal("\n"));
                doc.add(this.normal(this.tab(1)));
            }
        } else {
            doc.add(this.normal(this.tab(1)));
        }
        doc.add(this.keyWord("::= "));
        MIBObject parent = this.rep.getParent(o2);
        if (parent == null) {
            doc.add(this.normal(o2.getOid().toSMI()));
        } else if (o2 instanceof MIBModule && parent.getModuleID() == o2.getModuleID()) {
            while (parent != null && parent.getModuleID() == o2.getModuleID()) {
                parent = this.rep.getParent(parent);
            }
            if (parent == null) {
                this.writeObjectID(doc, o2.getOid(), parent, null);
            } else {
                this.writeSmiOidDef(doc, o2, parent);
            }
        } else {
            this.writeSmiOidDef(doc, o2, parent);
        }
    }

    private void writeIndex(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add(this.clause("PIB-INDEX "));
            } else {
                doc.add(this.clause("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add(this.clause("EXTENDS "));
        } else {
            doc.add(this.clause("AUGMENTS "));
        }
        doc.add(this.normal("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this.normal(this.tab(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this.keyWord("IMPLIED "));
            }
            doc.add(this.objectLink(element, null));
            if (en.hasMoreElements()) {
                doc.add(this.normal(",\n"));
                continue;
            }
            doc.add(this.normal("\n"));
        }
        doc.add(this.normal(this.tab(1) + "}\n"));
    }

    private void writeObjectIdentity(Document doc, MIBObject o2) {
        Paragraph para = this.buildObject(doc, o2);
        if (o2.getType() == 0 && o2.hasStatus()) {
            para.add(this.keyWord(" OBJECT-IDENTITY\n"));
            this.writeSmiDefBegin(para, o2);
        } else {
            para.add(this.keyWord(" OBJECT IDENTIFIER"));
        }
        para.add(this.normal("\n"));
        this.writeSmiDefEnd(para, o2);
        doc.add(para);
    }

    private void writeObjectType(Document doc, MIBObjectType ot) {
        Paragraph p2 = this.buildObject(doc, ot);
        p2.add(this.keyWord(" OBJECT-TYPE"));
        p2.add(this.normal("\n" + this.tab(1)));
        p2.add(this.clause("SYNTAX      "));
        this.writeSyntax(p2, ot.getSyntax());
        p2.add(this.normal("\n"));
        if (ot.hasUnits()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p2.add(this.normal("\n"));
                p2.add(this.text(2, ot.getUnits()));
            } else {
                p2.add(this.text(ot.getUnits()));
            }
            p2.add(this.normal("\n"));
        }
        p2.add(this.normal(this.tab(1)));
        if (ot.getAccess() != null) {
            if (this.smiversion == 1) {
                p2.add(this.clause("ACCESS      "));
            } else {
                p2.add(this.clause("MAX-ACCESS  "));
            }
            p2.add(this.normal(ot.getAccess()));
            p2.add(this.normal("\n"));
        }
        this.writeSmiDefBegin(p2, ot);
        if (ot.hasIndexPart()) {
            p2.add(this.normal(this.tab(1)));
            this.writeIndex(p2, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p2.add(this.normal(this.tab(1)));
            this.writeIndex(p2, ((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("UNIQUENESS  "));
                p2.add(this.normal("{"));
                MIBModule2PDF.newline(p2);
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    p2.add(this.normal(this.tab(2)));
                    p2.add(this.objectLink(element, null));
                    if (it.hasNext()) {
                        p2.add(this.normal(",\n"));
                        continue;
                    }
                    p2.add(this.normal("\n"));
                }
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("DEFVAL      "));
            p2.add(this.normal("{ "));
            p2.add(this.value(ot.getDefaultValue()));
            p2.add(this.normal(" }\n"));
        }
        this.writeSmiDefEnd(p2, ot);
        if (this.rep != null && ot.isTable()) {
            p2.add(this.normal("\n\n"));
            p2.add(this.identifier(ot.getSyntax().getSyntax()));
            p2.add(this.normal(" ::= "));
            p2.add(this.keyWord("SEQUENCE"));
            p2.add(this.normal(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s2 = (String)en.nextElement();
                p2.add(this.normal(this.tab(2)));
                p2.add(this.objectLink(s2, null));
                p2.add(this.normal(MIBObject.space(max - s2.length() + 1)));
                MIBObjectType o2 = (MIBObjectType)this.rep.getObject(s2);
                if (o2 == null) continue;
                p2.add(this.identifier(o2.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p2.add(this.normal(",\n"));
                    continue;
                }
                p2.add(this.normal("\n" + this.tab(1) + "}\n"));
            }
            p2.add(this.normal("\n"));
        }
        doc.add(p2);
    }

    private Paragraph buildObject(Document doc, MIBObject o2) {
        if (o2.hasComment()) {
            Paragraph p2 = new Paragraph();
            p2.add(this.comment(o2.getComment()));
            doc.add(p2);
        }
        Paragraph para = new Paragraph();
        para.add(new NewLine(this.fonts.get(STYLE_IDENTIFIER).getFontDescriptor()));
        para.add(this.objectRef(null, o2.getName()));
        this.bookmarks.put(MIBModule2PDF.sanitizeLinkName(o2.getName()), o2);
        return para;
    }

    private Paragraph objectRefs(int indent, Enumeration en, boolean link) {
        Paragraph doc = new Paragraph();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this.normal(this.tab(indent)));
            if (link) {
                doc.add(this.objectLink(element, null));
            } else {
                doc.add(this.identifier(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this.normal(",\n"));
                continue;
            }
            doc.add(this.normal("\n"));
        }
        return doc;
    }

    private void writeNotifyType(Document doc, MIBNotifyType o2) {
        Paragraph p2 = this.buildObject(doc, o2);
        if (o2.isV1Trap()) {
            p2.add(this.keyWord(" TRAP-TYPE"));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("ENTERPRISE "));
            p2.add(this.normal(o2.getEnterprise() + "\n"));
            if (o2.hasVariables()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("VARIABLES"));
                p2.add(this.normal(" {\n"));
                p2.add(this.objectRefs(2, o2.getVariablesVector().elements(), true));
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            if (o2.hasDescription()) {
                p2.add(this.normal("\n" + this.tab(1)));
                p2.add(this.clause("DESCRIPTION "));
                p2.add(this.normal("\n"));
                if (!o2.hasDescription()) {
                    p2.add(this.text(" \"\"\n"));
                } else {
                    p2.add(this.normal("\n"));
                    p2.add(this.text(2, o2.getDescription()));
                    p2.add(this.normal("\n"));
                }
            }
        } else {
            p2.add(this.clause(" NOTIFICATION-TYPE"));
            p2.add(this.normal("\n"));
            if (o2.hasVariables()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("OBJECTS"));
                p2.add(this.normal(" {\n"));
                p2.add(this.objectRefs(2, o2.getVariablesVector().elements(), true));
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            this.writeSmiDefBegin(p2, o2);
        }
        if (o2.isV1Trap()) {
            try {
                p2.add(this.normal(" ::= "));
                p2.add(this.value("" + o2.getOid().getLastSubID()));
                p2.add(this.normal("\n"));
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            this.writeSmiDefEnd(p2, o2);
        }
        doc.add(p2);
    }

    private void writeGroup(Document doc, MIBGroup o2) {
        Paragraph p2 = this.buildObject(doc, o2);
        p2.add(this.keyWord(" " + SMI.ENTRY_TYPES[o2.getType()]));
        p2.add(this.normal("\n"));
        if (o2.getType() == 7) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("NOTIFICATIONS"));
            p2.add(this.normal(" {\n"));
        } else {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("OBJECTS"));
            p2.add(this.normal(" {\n"));
        }
        p2.add(this.objectRefs(2, o2.getObjectsVector().elements(), true));
        p2.add(this.normal(this.tab(1) + "}\n"));
        this.writeSmiDefBegin(p2, o2);
        this.writeSmiDefEnd(p2, o2);
        doc.add(p2);
    }

    private void writeVariation(Paragraph p2, MIBVariation o2) {
        p2.add(this.normal(this.tab(1)));
        if (o2 instanceof MIBException) {
            p2.add(this.clause("OBJECT         "));
        } else {
            p2.add(this.clause("VARIATION      "));
        }
        p2.add(this.normal(o2.getVariation()));
        if (o2.hasSyntax()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("SYNTAX       "));
            this.writeSyntax(p2, o2.getSyntax());
        }
        if (o2.hasWriteSyntax()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("WRITE-SYNTAX "));
            this.writeSyntax(p2, o2.getWriteSyntax());
        }
        if (o2.hasAccess()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            if (o2 instanceof MIBException) {
                if (o2 instanceof PIBComplianceObject) {
                    p2.add(this.clause("PIB-MIN-ACCESS "));
                } else {
                    p2.add(this.clause("MIN-ACCESS   "));
                }
            } else {
                p2.add(this.clause("ACCESS       "));
            }
            p2.add(this.normal(o2.getAccess()));
        }
        if (o2.hasCreationRequires()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("CREATION-REQUIRES"));
            p2.add(this.normal(" {\n"));
            p2.add(this.objectRefs(3, o2.getCreationRequiresVector().elements(), false));
            p2.add(this.normal(" }"));
        }
        if (o2.hasDefaultValue()) {
            p2.add(this.normal("\n" + this.tab(1) + "  "));
            p2.add(this.clause("DEFVAL       "));
            p2.add(this.normal(" { "));
            p2.add(this.normal(o2.getDefval()));
            p2.add(this.normal(" }"));
        }
        p2.add(this.normal("\n" + this.tab(1) + "  "));
        p2.add(this.clause("DESCRIPTION "));
        if (o2.getDescription() != null) {
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getDescription()));
        } else {
            p2.add(this.text("\"\""));
        }
        p2.add(this.normal("\n"));
    }

    private void writeComplianceModule(Paragraph p2, MIBComplianceModule o2) {
        p2.add(this.normal(this.tab(1)));
        p2.add(this.clause("MODULE "));
        if (o2.hasModuleName()) {
            p2.add(this.identifier(o2.getModuleName()));
        }
        p2.add(this.normal("\n"));
        if (o2.hasMandatory()) {
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("MANDATORY-GROUPS"));
            p2.add(this.normal(" {\n"));
            p2.add(this.objectRefs(3, o2.getMandatoryVector().elements(), false));
            p2.add(this.normal(this.tab(1) + "}\n"));
        }
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this.writeVariation(p2, v);
            }
        }
    }

    private void writeCompliance(Document doc, MIBCompliance o2) {
        if (this.smiversion > 1) {
            Paragraph p2 = this.buildObject(doc, o2);
            p2.add(this.keyWord(" MODULE-COMPLIANCE"));
            p2.add(this.normal("\n"));
            this.writeSmiDefBegin(p2, o2);
            Enumeration en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this.writeComplianceModule(p2, (MIBComplianceModule)en.nextElement());
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeSupportedModule(Paragraph p2, MIBSupportedModule o2) {
        p2.add(this.normal("\n\n" + this.tab(1)));
        p2.add(this.clause("SUPPORTS "));
        p2.add(this.normal(o2.getSupports()));
        p2.add(this.normal("\n" + this.tab(1)));
        p2.add(this.clause("INCLUDES"));
        p2.add(this.normal(" {\n"));
        p2.add(this.objectRefs(2, o2.getIncludes().elements(), false));
        p2.add(this.normal(this.tab(1) + "}\n"));
        if (o2.hasVariations()) {
            Enumeration en = o2.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this.writeVariation(p2, v);
            }
        }
    }

    private void writeAgentCaps(Document doc, MIBAgentCaps o2) {
        if (this.smiversion > 1) {
            Paragraph p2 = this.buildObject(doc, o2);
            p2.add(this.keyWord(" AGENT-CAPABILITIES"));
            p2.add(this.normal("\n\n" + this.tab(1)));
            p2.add(this.clause("PRODUCT-RELEASE"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getProductRelease()));
            p2.add(this.normal("\n"));
            this.writeSmiDefBegin(p2, o2);
            Enumeration<MIBSupportedModule> en = o2.getModules().elements();
            while (en.hasMoreElements()) {
                this.writeSupportedModule(p2, en.nextElement());
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeTextualConvention(Document doc, MIBTextualConvention o2) {
        Paragraph p2 = this.buildObject(doc, o2);
        if (!o2.hasStatus() || SMI.statusType(o2.getStatus()) == 0) {
            p2.add(this.normal(" ::= "));
            this.writeSyntax(p2, o2.getSyntax());
        } else {
            p2.add(this.normal(" ::= "));
            p2.add(this.keyWord("TEXTUAL-CONVENTION"));
            p2.add(this.normal("\n"));
            if (o2.hasDisplayHint()) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.clause("DISPLAY-HINT "));
                p2.add(this.text(o2.getDisplayHint()));
                p2.add(this.normal("\n"));
            }
            this.writeSmiDefBegin(p2, o2);
            p2.add(this.normal(this.tab(1)));
            p2.add(this.clause("SYNTAX      "));
            this.writeSyntax(p2, o2.getSyntax());
        }
        doc.add(p2);
    }

    private void writeObject(Document doc, MIBObject o2) {
        if (o2 instanceof MIBObjectType) {
            this.writeObjectType(doc, (MIBObjectType)o2);
        } else if (o2 instanceof MIBTextualConvention) {
            this.writeTextualConvention(doc, (MIBTextualConvention)o2);
        } else if (o2 instanceof MIBNotifyType) {
            this.writeNotifyType(doc, (MIBNotifyType)o2);
        } else if (o2 instanceof MIBGroup) {
            this.writeGroup(doc, (MIBGroup)o2);
        } else if (o2 instanceof MIBCompliance) {
            this.writeCompliance(doc, (MIBCompliance)o2);
        } else if (o2 instanceof MIBAgentCaps) {
            this.writeAgentCaps(doc, (MIBAgentCaps)o2);
        } else {
            this.writeObjectIdentity(doc, o2);
        }
    }

    private void writeObjects(Document doc, MIBModule m3) {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this.mode));
        Enumeration en = m3.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o2 : orderedObjects.values()) {
            if (!(o2 instanceof MIBModule)) {
                this.writeObject(doc, o2);
                continue;
            }
            if (m3.getSMIVersion() != 1 || !o2.getOid().isValid()) continue;
            this.writeObject(doc, o2);
        }
    }

    private Paragraph objectRef(String moduleName, String objectName) {
        String objNameRef = MIBModule2PDF.sanitizeLinkName(objectName);
        Paragraph anchor = new Paragraph();
        FontAndColor fontAndColor = this.fonts.get(STYLE_IDENTIFIER);
        String txt = moduleName != null ? "{anchor:" + moduleName + "." + objNameRef + "}" + moduleName + "." + objectName + "{anchor}" : "{anchor:" + objNameRef + "}" + objectName + "{anchor}";
        this.addMarkupText(anchor, fontAndColor, txt);
        return anchor;
    }

    private static String sanitizeLinkName(String objectName) {
        return objectName.replace('-', '0');
    }

    private void addMarkupText(Paragraph paragraph, FontAndColor fontAndColor, String txt) {
        try {
            PDFont baseFont = fontAndColor.getFontDescriptor().getFont();
            paragraph.add(TextFlowUtil.createTextFlowFromMarkup(txt, fontAndColor.getFontDescriptor().getSize(), baseFont, baseFont, baseFont, baseFont));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void writeImport(TextFlow doc, MIBImport imports) {
        Enumeration<String> en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this.normal(this.tab(1)));
            String name = en.nextElement().toString();
            MIBObject[] o2 = this.rep.getObjectsByName(name);
            if (o2 != null && o2.length > 1) {
                doc.add(this.objectRef(imports.getSource(), name));
            } else {
                doc.add(this.objectRef(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this.normal(",\n"));
        }
        doc.add(this.normal("\n" + this.tab(2)));
        doc.add(this.keyWord("FROM "));
        doc.add(this.identifier(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this.normal(this.tab(2)));
            doc.add(this.comment(imports.getComment()));
        }
    }

    private void writeModuleObject(Document doc, MIBModule o2) {
        if (this.smiversion > 1 && o2.getOid().size() > 0) {
            String d2;
            Paragraph p2 = this.buildObject(doc, o2);
            p2.add(this.keyWord(" MODULE-IDENTITY"));
            if (o2 instanceof PIBModule) {
                p2.add(this.normal("\n" + this.tab(1)));
                p2.add(this.clause("SUBJECT-CATEGORIES {"));
                p2.add(this.normal("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o2).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p2.add(this.normal(this.tab(2)));
                    this.writeEnum(p2, element);
                    if (it.hasNext()) {
                        p2.add(this.normal(",\n"));
                        continue;
                    }
                    p2.add(this.normal("\n"));
                }
                p2.add(this.normal(this.tab(1) + "}\n"));
            }
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("LAST-UPDATED "));
            p2.add(this.text(o2.getLastUpdated()));
            if ((this.mode & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o2.getLastUpdated()))) != null) {
                p2.add(this.normal(this.tab(1)));
                p2.add(this.comment("-- " + d2));
            }
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("ORGANIZATION "));
            p2.add(this.text(o2.getOrganization()));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("CONTACT-INFO"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getContactInfo()));
            p2.add(this.normal("\n" + this.tab(1)));
            p2.add(this.clause("DESCRIPTION"));
            p2.add(this.normal("\n"));
            p2.add(this.text(2, o2.getDescription()));
            p2.add(this.normal("\n"));
            if (o2.hasRevisions()) {
                Enumeration en = o2.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d3;
                    MIBRevision r2 = (MIBRevision)en.nextElement();
                    p2.add(this.normal("\n" + this.tab(1)));
                    p2.add(this.clause("REVISION "));
                    p2.add(this.text(r2.getRevision()));
                    if ((this.mode & 0x20) > 0 && (d3 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r2.getRevision()))) != null) {
                        p2.add(this.normal(this.tab(1)));
                        p2.add(this.comment("-- " + d3));
                    }
                    p2.add(this.normal("\n" + this.tab(1)));
                    p2.add(this.clause("DESCRIPTION"));
                    p2.add(this.normal("\n"));
                    p2.add(this.text(2, r2.getDescription()));
                    p2.add(this.normal("\n"));
                }
            }
            this.writeSmiDefEnd(p2, o2);
            doc.add(p2);
        }
    }

    private void writeModule(Document doc, MIBModule m3) {
        Paragraph top = new Paragraph();
        top.add(this.normal(m3.getModuleName()));
        if (m3 instanceof PIBModule) {
            top.add(this.keyWord(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add(this.keyWord(" DEFINITIONS ::= BEGIN"));
        }
        top.add(this.normal("\n\n"));
        doc.add(top);
        if (m3.hasImports()) {
            Paragraph p2 = new Paragraph();
            TextParagraph textFlow = new TextParagraph("IMPORTS\n", this.fonts.get(STYLE_KEYWORD));
            Enumeration<MIBImport> en = m3.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = en.nextElement();
                this.writeImport(textFlow, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                textFlow.add(this.normal("\n"));
            }
            textFlow.add(this.normal(";"));
            p2.add(textFlow);
            doc.add(p2);
        }
        this.writeModuleObject(doc, m3);
        this.writeObjects(doc, m3);
        Paragraph bottom = new Paragraph();
        bottom.add(this.normal("\n"));
        bottom.add(new TextParagraph("END", this.fonts.get(STYLE_KEYWORD)));
        doc.add(bottom);
    }

    public void setDefaultFont(PDFont defaultFont) {
        this.defaultFont = defaultFont;
    }

    public PDFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this.displayPageNumbers = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this.displayPageNumbers;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this.outlineTree = outlineTree;
        if (outlineTree) {
            this.mode = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this.outlineTree;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this.showBookmarks = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this.showBookmarks;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this.displayCurrentDate = displayCurrentDate;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this.displayCurrentDate;
    }

    public int getMode() {
        return this.mode;
    }

    public static class FontAndColor {
        private FontDescriptor fontDescriptor;
        private Color color;

        public FontAndColor(FontDescriptor fontDescriptor, Color color) {
            this.fontDescriptor = fontDescriptor;
            this.color = color;
        }

        public FontDescriptor getFontDescriptor() {
            return this.fontDescriptor;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class BookmarkAnnotationProcessor
    implements AnnotationProcessor {
        @Override
        public void annotatedObjectDrawn(Annotated annotated, DrawContext drawContext, Position position, float v, float v1) throws IOException {
            if (!(annotated instanceof AnnotatedStyledText)) {
                return;
            }
            AnnotatedStyledText annotatedText = (AnnotatedStyledText)annotated;
            this.handleAnchorAnnotations(annotatedText, drawContext, position);
        }

        @Override
        public void beforePage(DrawContext drawContext) throws IOException {
        }

        @Override
        public void afterPage(DrawContext drawContext) throws IOException {
        }

        @Override
        public void afterRender(PDDocument pdDocument) throws IOException {
        }

        private void handleAnchorAnnotations(AnnotatedStyledText annotatedText, DrawContext drawContext, Position position) {
            Iterable<Annotations.AnchorAnnotation> anchorAnnotations = annotatedText.getAnnotationsOfType(Annotations.AnchorAnnotation.class);
            ResourceCacheWithBookmarks resourceCacheWithBookmarks = (ResourceCacheWithBookmarks)drawContext.getPdDocument().getResourceCache();
            LinkedHashMap bookmarks = resourceCacheWithBookmarks.bookmarks;
            boolean isTreeOutline = ((ResourceCacheWithBookmarks)drawContext.getPdDocument().getResourceCache()).isTreeOutline;
            for (Annotations.AnchorAnnotation anchorAnnotation : anchorAnnotations) {
                Object marked = bookmarks.get(anchorAnnotation.getAnchor());
                if (marked == null) continue;
                PageAnchor anchor = new PageAnchor(drawContext.getCurrentPage(), position.getX(), position.getY());
                PDOutlineItem outlineItem = new PDOutlineItem();
                outlineItem.setDestination(anchor.getDestination());
                outlineItem.setTitle(anchorAnnotation.getAnchor());
                if (marked instanceof MIBObject) {
                    MIBObject mibObject = (MIBObject)marked;
                    if (isTreeOutline) {
                        PDOutlineItem parentNode;
                        mibObject.userObject = outlineItem;
                        MIBObject parent = resourceCacheWithBookmarks.repository.getParent(mibObject);
                        if (parent != null && (parentNode = (PDOutlineItem)parent.userObject) != null) {
                            parentNode.addLast(outlineItem);
                            continue;
                        }
                    }
                }
                drawContext.getPdDocument().getDocumentCatalog().getDocumentOutline().addLast(outlineItem);
            }
        }
    }

    private class ResourceCacheWithBookmarks
    implements ResourceCache {
        private final ResourceCache delegated;
        private final LinkedHashMap<String, Object> bookmarks;
        private boolean isTreeOutline;
        private MIBRepository repository;

        public ResourceCacheWithBookmarks(ResourceCache delegated, LinkedHashMap<String, Object> bookmarks, MIBRepository repository, boolean isTreeOutline) {
            this.delegated = delegated;
            this.bookmarks = bookmarks;
            this.repository = repository;
            this.isTreeOutline = isTreeOutline;
        }

        @Override
        public PDFont getFont(COSObject cosObject) throws IOException {
            return this.delegated.getFont(cosObject);
        }

        @Override
        public PDColorSpace getColorSpace(COSObject cosObject) throws IOException {
            return this.delegated.getColorSpace(cosObject);
        }

        @Override
        public PDExtendedGraphicsState getExtGState(COSObject cosObject) {
            return this.delegated.getExtGState(cosObject);
        }

        @Override
        public PDShading getShading(COSObject cosObject) throws IOException {
            return this.delegated.getShading(cosObject);
        }

        @Override
        public PDAbstractPattern getPattern(COSObject cosObject) throws IOException {
            return this.delegated.getPattern(cosObject);
        }

        @Override
        public PDPropertyList getProperties(COSObject cosObject) {
            return this.delegated.getProperties(cosObject);
        }

        @Override
        public PDXObject getXObject(COSObject cosObject) throws IOException {
            return this.delegated.getXObject(cosObject);
        }

        @Override
        public void put(COSObject cosObject, PDFont pdFont) throws IOException {
            this.delegated.put(cosObject, pdFont);
        }

        @Override
        public void put(COSObject cosObject, PDColorSpace pdColorSpace) throws IOException {
            this.delegated.put(cosObject, pdColorSpace);
        }

        @Override
        public void put(COSObject cosObject, PDExtendedGraphicsState pdExtendedGraphicsState) {
            this.delegated.put(cosObject, pdExtendedGraphicsState);
        }

        @Override
        public void put(COSObject cosObject, PDShading pdShading) throws IOException {
            this.delegated.put(cosObject, pdShading);
        }

        @Override
        public void put(COSObject cosObject, PDAbstractPattern pdAbstractPattern) throws IOException {
            this.delegated.put(cosObject, pdAbstractPattern);
        }

        @Override
        public void put(COSObject cosObject, PDPropertyList pdPropertyList) {
            this.delegated.put(cosObject, pdPropertyList);
        }

        @Override
        public void put(COSObject cosObject, PDXObject pdxObject) throws IOException {
            this.delegated.put(cosObject, pdxObject);
        }
    }

    private class TextParagraph
    extends TextFlow {
        private String text;
        private FontAndColor fontAndColor;

        public TextParagraph(String text, FontAndColor fontAndColor) {
            this.text = text;
            this.fontAndColor = fontAndColor;
            MIBModule2PDF.convertNewLinesToFlow(text, fontAndColor, this);
        }
    }

    private static class Chunk
    extends TextFlow {
        public Chunk(String text, FontAndColor fontAndColor) {
            MIBModule2PDF.convertNewLinesToFlow(text, fontAndColor, this);
        }
    }

    public static class PageAnchor {
        private final PDPage page;
        private final float x;
        private final float y;

        public PageAnchor(PDPage page, float x, float y) {
            this.page = page;
            this.x = x;
            this.y = y;
        }

        public PDPage getPage() {
            return this.page;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public PDPageXYZDestination getDestination() {
            PDPageXYZDestination destination = new PDPageXYZDestination();
            destination.setPage(this.page);
            destination.setLeft((int)this.getX());
            destination.setTop((int)this.getY());
            return destination;
        }

        public String toString() {
            return "PageAnchor [page=" + this.page + ", x=" + this.x + ", y=" + this.y + "]";
        }
    }

    private static class Phrase
    extends StyledText {
        public Phrase(String text, FontAndColor fontAndColor) {
            super(text, fontAndColor.getFontDescriptor(), fontAndColor.getColor());
        }
    }
}

