/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smi.ext.SMIVariation;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class MIBVariation
implements SMIVariation,
Serializable {
    public static final long serialVersionUID = 1000L;
    private MIBSyntax syntax = null;
    private MIBSyntax writeSyntax = null;
    private String variation = null;
    private String access = null;
    private Vector<String> creationRequires = new Vector();
    private String defval = null;
    private String description = null;
    private transient Object userObject = null;

    public MIBVariation() {
    }

    /*
     * WARNING - void declaration
     */
    public MIBVariation(String variation, String descr) {
        void var2_2;
        void var1_1;
        this.variation = var1_1;
        this.description = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MIBVariation(MIBVariation other) {
        void var1_1;
        this.variation = other.variation;
        if (other.hasSyntax()) {
            this.syntax = new MIBSyntax(other.syntax);
        }
        if (other.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(other.writeSyntax);
        }
        this.access = other.access;
        this.defval = other.defval;
        if (other.hasCreationRequires()) {
            Enumeration<String> enumeration = other.creationRequires.elements();
            while (enumeration.hasMoreElements()) {
                this.creationRequires.addElement(enumeration.nextElement());
            }
        }
        this.description = var1_1.description;
    }

    /*
     * WARNING - void declaration
     */
    public MIBVariation(IVariation other) {
        void var1_1;
        String[] stringArray;
        this.variation = other.getVariation();
        if (other.hasSyntax()) {
            this.syntax = new MIBSyntax(other.getSyntaxDef());
        }
        if (other.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(other.getWriteSyntaxDef());
        }
        if (other.hasAccess()) {
            this.access = other.getAccess();
        }
        if (other.hasDefaultValue()) {
            this.defval = other.getDefval();
        }
        if ((stringArray = other.getCreationRequires()) != null) {
            Collections.addAll(this.creationRequires, other.getCreationRequires());
        }
        this.description = var1_1.getDescription();
    }

    public MIBSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    @Override
    public ISyntax getWriteSyntaxDef() {
        return this.writeSyntax;
    }

    @Override
    public boolean hasSyntax() {
        return this.syntax != null;
    }

    @Override
    public boolean hasWriteSyntax() {
        return this.writeSyntax != null;
    }

    @Override
    public boolean hasAccess() {
        return this.access != null;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defval != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSyntaxDef(SMISyntax newSyntax) {
        void var1_1;
        this.syntax = (MIBSyntax)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSyntax(MIBSyntax newSyntax) {
        void var1_1;
        this.syntax = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteSyntax(MIBSyntax newWriteSyntax) {
        void var1_1;
        this.writeSyntax = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWriteSyntaxDef(SMISyntax newWriteSyntax) {
        void var1_1;
        this.writeSyntax = (MIBSyntax)var1_1;
    }

    public MIBSyntax getWriteSyntax() {
        return this.writeSyntax;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVariation(String newVariation) {
        void var1_1;
        this.variation = var1_1;
    }

    @Override
    public String getVariation() {
        return this.variation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAccess(String newAccess) {
        void var1_1;
        this.access = var1_1;
    }

    @Override
    public String getAccess() {
        return this.access;
    }

    public boolean hasCreationRequires() {
        return this.creationRequires != null && this.creationRequires.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCreationRequires(String[] newCreationRequires) {
        void var1_1;
        this.creationRequires = new Vector(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setCreationRequires(Vector<String> newCreationRequires) {
        void var1_1;
        this.creationRequires = var1_1;
    }

    public Vector getCreationRequiresVector() {
        return this.creationRequires;
    }

    @Override
    public String[] getCreationRequires() {
        Object[] objectArray = new String[this.creationRequires.size()];
        this.creationRequires.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDefval(String newDefval) {
        void var1_1;
        this.defval = var1_1;
    }

    @Override
    public String getDefval() {
        return this.defval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDescription(String newDescription) {
        void var1_1;
        this.description = var1_1;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, MIBRepository rep, MIBVariation c2, String lineSeparator) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(lineSeparator + "\t");
        MIBObject.addKeyWord(mode, stringBuffer, "VARIATION ");
        MIBObject.addString(mode, stringBuffer, this.variation, c2 == null ? null : c2.variation);
        if (this.syntax != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(mode, stringBuffer, "SYNTAX   ");
            object = null;
            if (c2 != null) {
                object = c2.syntax != null ? c2.syntax : new MIBSyntax();
            }
            stringBuffer.append(this.syntax.toSMI(mode, rep, (MIBSyntax)object, lineSeparator));
        }
        if (this.writeSyntax != null) {
            void var2_2;
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(mode, stringBuffer, "WRITE-SYNTAX ");
            object = null;
            if (c2 != null) {
                object = c2.writeSyntax != null ? c2.writeSyntax : new MIBSyntax();
            }
            stringBuffer.append(this.writeSyntax.toSMI(mode, (MIBRepository)var2_2, (MIBSyntax)object, lineSeparator));
        }
        if (this.access != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(mode, stringBuffer, "ACCESS ");
            object = null;
            if (c2 != null) {
                object = c2.access != null ? c2.access : "";
            }
            MIBObject.addString(mode, stringBuffer, this.access, (String)object);
            stringBuffer.append(lineSeparator);
        }
        if (this.creationRequires != null && this.creationRequires.size() > 0) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(mode, stringBuffer, "CREATION-REQUIRES");
            stringBuffer.append(" {");
            stringBuffer.append(lineSeparator);
            object = null;
            if (c2 != null) {
                object = c2.creationRequires != null && c2.creationRequires.size() > 0 ? MIBObject.formatObjectRefs(mode, "\t\t\t", c2.creationRequires.iterator(), lineSeparator) : "";
            }
            MIBObject.addString(mode, stringBuffer, MIBObject.formatObjectRefs(mode, "\t\t\t", this.creationRequires.iterator(), lineSeparator), (String)object);
            stringBuffer.append(" }");
        }
        if (this.defval != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(mode, stringBuffer, "DEFVAL");
            stringBuffer.append(" { ");
            object = null;
            if (c2 != null) {
                object = c2.defval != null ? c2.defval : "";
            }
            MIBObject.addString(mode, stringBuffer, this.defval, (String)object);
            stringBuffer.append(" }");
        }
        stringBuffer.append(lineSeparator);
        stringBuffer.append("\t  ");
        MIBObject.addKeyWord(mode, stringBuffer, "DESCRIPTION");
        if (this.description != null) {
            stringBuffer.append(lineSeparator);
            object = null;
            if (c2 != null) {
                void var3_3;
                object = c2.description != null && c2.description.length() > 0 ? MIBObject.formatLines("\t\t", var3_3.description) : "";
            }
            MIBObject.addText(lineSeparator, mode, stringBuffer, MIBObject.formatLines("\t\t", this.description), (String)object);
        } else {
            void var1_1;
            MIBObject.addText(lineSeparator, (int)var1_1, stringBuffer, "\"\"");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.variation;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserObject(Object userObject) {
        void var1_1;
        this.userObject = var1_1;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBVariation) {
            MIBVariation mIBVariation;
            mIBVariation = mIBVariation;
            return MIBObject.saveCompare(this.syntax, mIBVariation.syntax) && MIBObject.saveCompare(this.writeSyntax, mIBVariation.writeSyntax) && MIBObject.saveCompare(this.variation, mIBVariation.variation) && MIBObject.saveCompare(this.access, mIBVariation.access) && MIBObject.saveCompare(this.creationRequires, mIBVariation.creationRequires) && MIBObject.saveCompare(this.defval, mIBVariation.defval) && MIBObject.saveCompare(this.description, mIBVariation.description);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasSyntax()) {
            this.syntax.userObject = null;
        }
        if (this.hasWriteSyntax()) {
            this.writeSyntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

