/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IIndexPart;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIIndexPart;
import com.agentpp.smi.ext.SMIObjectType;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBObjectType
extends MIBObject
implements SMIObjectType,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected String access = null;
    protected String defValue = null;
    protected MIBSyntax syntax = null;
    protected String units = null;
    protected MIBIndexPart indexPart = null;
    protected Vector entries = null;
    protected boolean columnarObject = false;

    public MIBObjectType() {
        this.columnarObject = false;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObjectType(ObjectID oid, String name, Integer moduleID) {
        super((ObjectID)var1_1, (String)var2_2, (Integer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.columnarObject = false;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObjectType(MIBObjectType other) {
        super(other);
        void var1_1;
        this.access = other.access;
        if (other.hasDefaultValue()) {
            this.defValue = other.defValue;
        }
        MIBSyntax mIBSyntax = this.syntax = other.getSyntax() == null ? null : new MIBSyntax(other.getSyntax());
        if (other.hasUnits()) {
            this.units = other.units;
        }
        if (other.hasIndexPart()) {
            this.indexPart = new MIBIndexPart(other.indexPart);
        }
        if (other.isTable()) {
            this.setTableEntries(other.getTableEntries());
        }
        this.columnarObject = var1_1.columnarObject;
    }

    @Override
    public MIBObject getClone() {
        return new MIBObjectType(this);
    }

    @Override
    public final String getTypeString() {
        return SMI.ENTRY_TYPES[1];
    }

    @Override
    public final int getType() {
        return 1;
    }

    public final String getSubTypeString() {
        if (this.isScalar()) {
            return "Scalar";
        }
        if (this.isTable()) {
            return "TableEntry";
        }
        if (this.isColumnarObject()) {
            return "Column";
        }
        if (this.getSyntax() != null && this.getSyntax().getType() == 2) {
            return "Table";
        }
        return "Scalar";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setAccess(String access) {
        void var1_1;
        this.access = var1_1;
    }

    @Override
    public final String getAccess() {
        return this.access;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSyntax(MIBSyntax syntax) {
        void var1_1;
        this.syntax = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setSyntax(SMISyntax syntax) {
        void var1_1;
        this.syntax = (MIBSyntax)var1_1;
    }

    public final MIBSyntax getSyntax() {
        return this.syntax;
    }

    @Override
    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    @Override
    public final boolean hasDefaultValue() {
        return this.defValue != null;
    }

    @Override
    public final String getDefaultValue() {
        return this.defValue;
    }

    public Object getDefaultValueAsObject(MIBRepository rep) {
        Object object;
        Serializable serializable;
        block15: {
            if (!this.hasDefaultValue()) {
                return null;
            }
            serializable = rep.getEffectiveSyntax(this.syntax).getSyntax();
            if (!((MIBSyntax)serializable).hasEnums()) break block15;
            object = ((MIBSyntax)serializable).getEnum(this.getDefaultValue());
            if (object == null) {
                return null;
            }
            if (!((MIBSyntax)serializable).getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                return new Long(SMI.parseLongConstant((String)object));
            }
            return object;
        }
        try {
            if (((MIBSyntax)serializable).getSyntax().equals("INTEGER") || ((MIBSyntax)serializable).getSyntax().equals("Integer32") || ((MIBSyntax)serializable).getSyntax().equals("Counter") || ((MIBSyntax)serializable).getSyntax().equals("Counter32") || ((MIBSyntax)serializable).getSyntax().equals("UInteger32") || ((MIBSyntax)serializable).getSyntax().equals("Unsigned32") || ((MIBSyntax)serializable).getSyntax().equals("Gauge") || ((MIBSyntax)serializable).getSyntax().equals("Gauge32") || ((MIBSyntax)serializable).getSyntax().equals("Counter64") || ((MIBSyntax)serializable).getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(this.defValue));
            }
            if (((MIBSyntax)serializable).getSyntax().equals("IpAddress")) {
                byte[] byArray = SMI.stringConstantToByteArray(this.defValue);
                object = byArray;
                if (byArray == null) {
                    return "0.0.0.0";
                }
                serializable = new StringBuffer();
                for (int i2 = 0; i2 < 4 && i2 < ((Object)object).length; ++i2) {
                    ((StringBuffer)serializable).append((int)object[i2]);
                    if (i2 >= 3) continue;
                    ((StringBuffer)serializable).append(".");
                }
                return ((StringBuffer)serializable).toString();
            }
            if (((MIBSyntax)serializable).getSyntax().equals("NetworkAddress") || ((MIBSyntax)serializable).getSyntax().equals("Opaque") || ((MIBSyntax)serializable).getSyntax().startsWith("OCTET STRING")) {
                return SMI.parseStringConstant(this.defValue);
            }
            if (((MIBSyntax)serializable).getSyntax().equals("OBJECT-IDENTITY") || ((MIBSyntax)serializable).getSyntax().equals("OBJECT IDENTIFIER")) {
                if (this.defValue.indexOf(123) >= 0) {
                    object = new StringTokenizer("{ }");
                    serializable = new StringBuffer();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        ((StringBuffer)serializable).append(((StringTokenizer)object).nextToken());
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        ((StringBuffer)serializable).append('.');
                    }
                    return new ObjectID(((StringBuffer)serializable).toString());
                }
                if ((object = ((MIBRepository)object).getObjectID(this.defValue)) != null) {
                    return object;
                }
                return new ObjectID();
            }
            return this.defValue;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object getDefaultValue(MIBRepository rep, MIBSyntax syntax, String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        try {
            Object object;
            Serializable serializable;
            serializable = rep.getEffectiveSyntax((MIBSyntax)serializable).getSyntax();
            if (((MIBSyntax)serializable).hasEnums()) {
                if (((MIBSyntax)serializable).getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    return ((MIBSyntax)serializable).getBitsEnum(defaultValue);
                }
                object = ((MIBSyntax)serializable).getEnum(defaultValue);
                if (object == null) {
                    return null;
                }
                return new Long(SMI.parseLongConstant((String)object));
            }
            if (((MIBSyntax)serializable).getSyntax().equals("INTEGER") || ((MIBSyntax)serializable).getSyntax().equals("Integer32") || ((MIBSyntax)serializable).getSyntax().equals("Counter") || ((MIBSyntax)serializable).getSyntax().equals("Counter32") || ((MIBSyntax)serializable).getSyntax().equals("UInteger32") || ((MIBSyntax)serializable).getSyntax().equals("Unsigned32") || ((MIBSyntax)serializable).getSyntax().equals("Gauge") || ((MIBSyntax)serializable).getSyntax().equals("Gauge32") || ((MIBSyntax)serializable).getSyntax().equals("Counter64") || ((MIBSyntax)serializable).getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(defaultValue));
            }
            if (((MIBSyntax)serializable).getSyntax().equals("IpAddress") || ((MIBSyntax)serializable).getSyntax().equals("NetworkAddress") || ((MIBSyntax)serializable).getSyntax().equals("Opaque") || ((MIBSyntax)serializable).getSyntax().startsWith("OCTET STRING")) {
                return SMI.stringConstantToByteArray(defaultValue);
            }
            if (((MIBSyntax)serializable).getSyntax().equals("OBJECT-IDENTITY") || ((MIBSyntax)serializable).getSyntax().equals("OBJECT IDENTIFIER")) {
                void var2_2;
                if (defaultValue.indexOf(123) >= 0) {
                    object = new StringTokenizer("{ }");
                    serializable = new StringBuffer();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        ((StringBuffer)serializable).append(((StringTokenizer)object).nextToken());
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        ((StringBuffer)serializable).append('.');
                    }
                    return new ObjectID(((StringBuffer)serializable).toString());
                }
                object = ((MIBRepository)object).getObjectID((String)var2_2);
                return object;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Object getDefaultValue(MIBRepository rep) {
        return MIBObjectType.getDefaultValue(rep, this.getSyntax(), this.getDefaultValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setDefaultValue(String value) {
        void var1_1;
        this.defValue = var1_1;
    }

    @Override
    public final boolean hasIndexPart() {
        return this.indexPart != null;
    }

    public final MIBIndexPart getIndexPart() {
        return this.indexPart;
    }

    @Override
    public IIndexPart getIndex() {
        return this.getIndexPart();
    }

    /*
     * WARNING - void declaration
     */
    public final void setIndexPart(MIBIndexPart indexPart) {
        void var1_1;
        this.indexPart = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setIndexPart(SMIIndexPart indexPart) {
        void var1_1;
        this.indexPart = (MIBIndexPart)var1_1;
    }

    @Override
    public final boolean isTable() {
        return this.entries != null && this.entries.size() > 0;
    }

    public final boolean isTableSequence() {
        return this.syntax != null && this.syntax.getType() == 2;
    }

    /*
     * WARNING - void declaration
     */
    public void addTableEntry(String entry) {
        void var1_1;
        if (this.entries == null) {
            new Vector(5);
        }
        this.entries.addElement(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTableEntriesVector(Vector entries) {
        void var1_1;
        this.entries = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setTableEntries(String[] entries) {
        void var1_1;
        this.entries = MIBRepository.buildVector(var1_1);
    }

    public final Vector getTableEntriesVector() {
        return this.entries;
    }

    @Override
    public String[] getTableEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] objectArray = new String[this.entries.size()];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTableEntry(String oldName, String newName) {
        String string;
        int n2 = this.getTableEntriesVector().indexOf(oldName);
        if (n2 < 0) {
            return false;
        }
        this.getTableEntriesVector().set(n2, newName);
        n2 = this.getIndexPart().getIndexPartVector().indexOf(string);
        if (n2 >= 0) {
            void var2_2;
            this.getIndexPart().getIndexPartVector().set(n2, var2_2);
        }
        if ((string = this.getName()).length() > 0) {
            this.getSyntax().setSyntax(string.substring(0, 1).toUpperCase() + string.substring(1));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String getTableEntry(int i2) {
        void var1_1;
        return (String)this.entries.elementAt((int)var1_1);
    }

    public final int getTableLength() {
        return this.entries.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setColumnarObject(boolean co) {
        void var1_1;
        this.columnarObject = var1_1;
    }

    @Override
    public final boolean isColumnarObject() {
        return this.columnarObject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setUnits(String units) {
        void var1_1;
        this.units = var1_1;
    }

    @Override
    public final String getUnits() {
        return this.units;
    }

    @Override
    public final boolean hasUnits() {
        return this.units != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        void var2_2;
        Object object;
        Enumeration enumeration;
        Object object2 = (MIBObjectType)this.comparable(mode);
        StringBuffer stringBuffer = new StringBuffer();
        MIBObjectType.addNavigationLinks(this, mode, stringBuffer, rep, lineSeparator);
        if (this.hasComment()) {
            MIBObjectType.addComment(mode, stringBuffer, this.asn1Comment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        MIBObjectType.addObjectRef(null, mode, stringBuffer, this.name, object2 == null ? null : ((MIBObjectType)object2).name);
        MIBObjectType.addKeyWord(mode, stringBuffer, " OBJECT-TYPE");
        stringBuffer.append(lineSeparator);
        stringBuffer.append("\t");
        MIBObjectType.addKeyWord(mode, stringBuffer, "SYNTAX  ");
        if (this.syntax != null) {
            stringBuffer.append(this.syntax.toSMI(mode, rep, object2 == null ? null : ((MIBObjectType)object2).syntax, lineSeparator));
        }
        if (mode != 16 && this.hasUnits()) {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(mode, stringBuffer, "UNITS");
            boolean bl = false;
            if (this.units.contains(lineSeparator)) {
                stringBuffer.append(lineSeparator);
                bl = true;
            } else {
                stringBuffer.append("\t");
            }
            enumeration = null;
            if (object2 != null) {
                enumeration = ((MIBObjectType)object2).hasUnits() ? ((MIBObjectType)object2).units : "";
            }
            object = bl ? "\t\t" : "";
            MIBObjectType.addText(lineSeparator, mode, stringBuffer, MIBObjectType.formatLines((String)object, this.units), enumeration == null ? null : MIBObjectType.formatLines((String)object, (String)((Object)enumeration)));
            stringBuffer.append(lineSeparator);
        }
        this.toSmiAccess(mode, (int)var2_2, lineSeparator, (MIBObjectType)object2, stringBuffer);
        stringBuffer.append(this.getSMIDefBegin(mode, lineSeparator));
        this.toSMIIndexPart(mode, lineSeparator, (MIBObjectType)object2, stringBuffer);
        if (((mode & 1) > 0 || (mode & 2) > 0) && this.defValue != null) {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(mode, stringBuffer, "DEFVAL ");
            stringBuffer.append("{ ");
            String string = null;
            if (object2 != null) {
                string = ((MIBObjectType)object2).hasDefaultValue() ? ((MIBObjectType)object2).getDefaultValue() : "";
            }
            MIBObjectType.addString(mode, stringBuffer, this.defValue, string);
            stringBuffer.append(" }");
            stringBuffer.append(lineSeparator);
        }
        stringBuffer.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
        stringBuffer.append(lineSeparator);
        if (rep != null && this.entries != null) {
            stringBuffer.append(lineSeparator);
            stringBuffer.append(this.syntax.getSyntax());
            stringBuffer.append(" ::= ");
            MIBObjectType.addKeyWord(mode, stringBuffer, "SEQUENCE");
            stringBuffer.append(" {");
            stringBuffer.append(lineSeparator);
            int n2 = MIBObjectType.getMaxLength(this.entries.iterator());
            enumeration = null;
            if (object2 != null) {
                enumeration = ((MIBObjectType)object2).isTable() ? ((MIBObjectType)object2).entries.elements() : new Vector().elements();
            }
            if (this.entries.size() == 0) {
                stringBuffer.append(" }");
            }
            stringBuffer.append(lineSeparator);
            object = this.entries.elements();
            while (object.hasMoreElements()) {
                Object object3 = (String)object.nextElement();
                object2 = null;
                if (enumeration != null) {
                    object2 = enumeration.hasMoreElements() ? (String)enumeration.nextElement() : "";
                }
                stringBuffer.append("\t");
                MIBObjectType.addObjectLink(mode, stringBuffer, (String)object3, (String)object2);
                stringBuffer.append(MIBObjectType.space(n2 - ((String)object3).length() + 1));
                object3 = (MIBObjectType)rep.getObject((String)object3);
                if (object3 == null) {
                    stringBuffer.append("?");
                    if (object.hasMoreElements()) {
                        stringBuffer.append(",");
                        stringBuffer.append(lineSeparator);
                        continue;
                    }
                    stringBuffer.append(" }");
                    stringBuffer.append(lineSeparator);
                    continue;
                }
                if (((MIBObjectType)object3).getSyntax() != null) {
                    stringBuffer.append(((MIBObjectType)object3).getSyntax().getSyntax());
                }
                if (object.hasMoreElements()) {
                    stringBuffer.append(",");
                    stringBuffer.append(lineSeparator);
                    continue;
                }
                stringBuffer.append(" }");
                stringBuffer.append(lineSeparator);
            }
            stringBuffer.append(lineSeparator);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void toSMIIndexPart(int mode, String lineSeparator, MIBObjectType c2, StringBuffer buf) {
        if (this.indexPart != null) {
            void var2_2;
            void var1_1;
            buf.append('\t');
            String string = null;
            if (c2 != null) {
                void var3_3;
                string = c2.hasIndexPart() ? var3_3.getIndexPart().toSMI(mode, lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, this.indexPart.toSMI((int)var1_1, (String)var2_2), string);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void toSmiAccess(int mode, int smiversion, String lineSeparator, MIBObjectType c2, StringBuffer buf) {
        if (smiversion == 1) {
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "ACCESS  ");
            MIBObjectType.addString(mode, buf, this.access, c2 == null ? null : c2.access);
            buf.append(lineSeparator);
            return;
        }
        if (this.getAccess() != null) {
            void var3_3;
            void var1_1;
            buf.append('\t');
            MIBObjectType.addKeyWord(mode, buf, "MAX-ACCESS ");
            MIBObjectType.addString((int)var1_1, buf, this.access, c2 == null ? null : c2.access);
            buf.append((String)var3_3);
        }
    }

    @Override
    public boolean isScalar() {
        return !this.isTable() && !this.isColumnarObject() && SMI.isAccessible(this.getAccess());
    }

    @Override
    public boolean isStructural() {
        return !this.isTable() && !this.isColumnarObject() && !this.isScalar();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof MIBObjectType && super.equals(o2)) {
            MIBObjectType mIBObjectType;
            mIBObjectType = mIBObjectType;
            return MIBObjectType.saveCompare(this.syntax, mIBObjectType.syntax) && MIBObjectType.saveCompare(this.access, mIBObjectType.access) && MIBObjectType.saveCompare(this.defValue, mIBObjectType.defValue) && MIBObjectType.saveCompare(this.entries, mIBObjectType.entries) && MIBObjectType.saveCompare(this.indexPart, mIBObjectType.indexPart);
        }
        return false;
    }

    @Override
    public void freeUserObjects() {
        super.freeUserObjects();
        if (this.syntax != null) {
            this.syntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

