/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMIRequirementsSpec;
import com.agentpp.smi.ext.SMIVariation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBComplianceModule
implements SMIRequirementsSpec,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected String moduleName = null;
    protected Vector<String> mandatory = null;
    protected Vector variations = new Vector();
    protected transient Object userObject = null;

    public MIBComplianceModule() {
    }

    /*
     * WARNING - void declaration
     */
    public MIBComplianceModule(String moduleName) {
        void var1_1;
        this.moduleName = var1_1;
    }

    public MIBComplianceModule(MIBComplianceModule other) {
        Enumeration<Object> enumeration;
        if (other.moduleName != null) {
            this.moduleName = other.moduleName;
        }
        if (other.hasMandatory()) {
            this.mandatory = new Vector();
            enumeration = other.mandatory.elements();
            while (enumeration.hasMoreElements()) {
                this.mandatory.addElement(enumeration.nextElement().toString());
            }
        }
        if (other.hasVariations()) {
            Object object;
            enumeration = ((MIBComplianceModule)object).variations.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object instanceof MIBCondGroup) {
                    this.variations.addElement(new MIBCondGroup((MIBCondGroup)object));
                }
                if (!(object instanceof MIBException)) continue;
                this.variations.addElement(new MIBException((MIBException)object));
            }
        }
    }

    @Override
    public boolean hasMandatory() {
        return this.mandatory != null && this.mandatory.size() > 0;
    }

    public Vector getMandatoryVector() {
        return this.mandatory;
    }

    @Override
    public String[] getMandatory() {
        Object[] objectArray = new String[this.mandatory.size()];
        this.mandatory.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setMandatory(String[] mandatory) {
        void var1_1;
        this.mandatory = new Vector(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setMandatory(Vector<String> newMandatory) {
        void var1_1;
        this.mandatory = var1_1;
    }

    @Override
    public boolean hasVariations() {
        return this.variations != null && this.variations.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setVariations(SMIVariation[] variations) {
        void var1_1;
        this.variations = new Vector(Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setVariations(Vector newVariations) {
        void var1_1;
        this.variations = var1_1;
    }

    public final Vector getVariationsVector() {
        return this.variations;
    }

    @Override
    public final IVariation[] getVariations() {
        Object[] objectArray = new MIBVariation[this.variations.size()];
        this.variations.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public final boolean hasModuleName() {
        return this.moduleName != null && this.moduleName.length() > 0;
    }

    @Override
    public final String getModuleName() {
        return this.moduleName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setModuleName(String name) {
        void var1_1;
        this.moduleName = var1_1;
    }

    public String toSMI(int mode, MIBRepository rep, MIBComplianceModule c2, String lineSeparator) {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer(lineSeparator + "\t");
        MIBObject.addKeyWord(mode, stringBuffer, "MODULE ");
        if (this.hasModuleName()) {
            enumeration = null;
            if (c2 != null) {
                enumeration = c2.hasModuleName() ? c2.moduleName : "";
            }
            MIBObject.addString(mode, stringBuffer, this.moduleName, (String)((Object)enumeration));
        }
        stringBuffer.append(lineSeparator);
        if (this.hasMandatory()) {
            stringBuffer.append('\t');
            MIBObject.addKeyWord(mode, stringBuffer, "MANDATORY-GROUPS");
            stringBuffer.append(" {");
            stringBuffer.append(lineSeparator);
            enumeration = null;
            if (c2 != null) {
                enumeration = c2.hasMandatory() ? MIBObject.formatObjectRefs(mode, "\t\t\t", c2.mandatory.iterator(), lineSeparator) : "";
            }
            MIBObject.addString(mode, stringBuffer, MIBObject.formatObjectRefs(mode, "\t\t\t", this.mandatory.iterator(), lineSeparator), (String)((Object)enumeration));
            stringBuffer.append(" }");
            stringBuffer.append(lineSeparator);
        }
        if (this.variations.size() > 0) {
            Enumeration enumeration2;
            enumeration = null;
            if (c2 != null) {
                enumeration = c2.variations != null && c2.variations.size() > 0 ? ((MIBComplianceModule)((Object)enumeration2)).variations.elements() : new Vector().elements();
            }
            enumeration2 = this.variations.elements();
            while (enumeration2.hasMoreElements()) {
                MIBVariation mIBVariation = (MIBVariation)enumeration2.nextElement();
                MIBVariation mIBVariation2 = null;
                if (enumeration != null) {
                    mIBVariation2 = enumeration.hasMoreElements() ? (MIBVariation)enumeration.nextElement() : new MIBVariation();
                }
                stringBuffer.append(mIBVariation.toSMI(mode, rep, mIBVariation2, lineSeparator));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.moduleName;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserObject(Object userObject) {
        void var1_1;
        this.userObject = var1_1;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBComplianceModule) {
            MIBComplianceModule mIBComplianceModule;
            mIBComplianceModule = mIBComplianceModule;
            return MIBObject.saveCompare(this.mandatory, mIBComplianceModule.mandatory) && MIBObject.saveCompare(this.moduleName, mIBComplianceModule.moduleName) && MIBObject.saveCompare(this.variations, mIBComplianceModule.variations);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasVariations()) {
            for (MIBVariation mIBVariation : this.variations) {
                mIBVariation.freeUserObjects();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        void var1_1;
        this.mandatory = (Vector)objectInputStream.readObject();
        this.moduleName = (String)objectInputStream.readObject();
        this.variations = (Vector)var1_1.readObject();
    }
}

