/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class UserCodeParser {
    private static final String[][] DEFAULT_COMMENTS = new String[][]{{"//"}, {"/*", "*/"}, {"<!--", "-->"}, {"#--", "--#"}};
    private static final String[][] DEFAULT_USER_CODE_MARKER = new String[][]{{"--AgentGen BEGIN=", "--AgentGen END"}, {"|:AgenPro|=", "|AgenPro:|"}};
    private String[][] comments = DEFAULT_COMMENTS;
    private String[][] userCodeMarker = DEFAULT_USER_CODE_MARKER;
    private String lineSeparator = "\n";

    public Map<String, String> extractUserCode(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        String id = null;
        HashMap<String, String> userCodeMap = new HashMap<String, String>();
        StringBuilder buffer = new StringBuilder();
        int foundComment = -1;
        char[] commentStarters = this.buildCommentStarterArray(this.comments);
        try {
            while ((line = bufferedReader.readLine()) != null) {
                for (int i2 = 0; i2 < line.length(); ++i2) {
                    char c2 = line.charAt(i2);
                    if (Arrays.binarySearch(commentStarters, c2) < 0) continue;
                    int commentStart = 0;
                    int commentEnd = this.comments.length;
                    int commentOffset = 0;
                    if (foundComment >= 0) {
                        commentStart = foundComment;
                        commentEnd = foundComment + 1;
                    }
                    for (int commentIndex = commentStart; commentIndex < commentEnd; ++commentIndex) {
                        int pos;
                        String[] commentPair = this.comments[commentIndex];
                        String commentString = commentPair[commentOffset];
                        if (c2 != commentString.charAt(0) || (pos = line.indexOf(commentString, i2)) < 0) continue;
                        for (String[] marker : this.userCodeMarker) {
                            int posMarker = line.indexOf(marker[0], pos);
                            if (posMarker == pos + commentString.length()) {
                                int idPos = posMarker + marker[0].length();
                                if (commentPair.length == 1) {
                                    id = line.substring(idPos);
                                    i2 = line.length();
                                    line = "";
                                    foundComment = -1;
                                    continue;
                                }
                                int idEnd = line.indexOf(commentPair[1], idPos);
                                if (idEnd < 0) continue;
                                id = line.substring(idPos, idEnd);
                                line = line.substring(idEnd + commentPair[1].length());
                                i2 = 0;
                                foundComment = commentIndex;
                                continue;
                            }
                            if (id == null || (posMarker = line.indexOf(marker[1], pos)) != pos + commentString.length()) continue;
                            buffer.append(line.substring(0, pos));
                            String userCode = UserCodeParser.trimTrailing(buffer.toString());
                            if (userCode.trim().length() > 0) {
                                userCodeMap.put(id, userCode);
                            } else {
                                userCodeMap.put(id, "");
                            }
                            buffer = new StringBuilder();
                            id = null;
                            foundComment = -1;
                            i2 = 0;
                            line = line.substring(posMarker + marker[1].length());
                        }
                    }
                }
                if (id == null) continue;
                buffer.append(line);
                buffer.append(this.lineSeparator);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return userCodeMap;
    }

    public static String trimTrailing(String s2) {
        int cut;
        if (s2 == null) {
            return null;
        }
        for (cut = s2.length() - 1; cut >= 0 && s2.charAt(cut) <= ' '; --cut) {
        }
        if (cut < s2.length() - 1) {
            return s2.substring(0, cut + 1);
        }
        return s2;
    }

    private char[] buildCommentStarterArray(String[][] comments) {
        HashSet<Character> starters = new HashSet<Character>(comments.length);
        String[][] stringArray = comments;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String[] commentPair;
            for (String commentString : commentPair = stringArray[i2]) {
                starters.add(Character.valueOf(commentString.charAt(0)));
            }
        }
        char[] startCharArray = new char[starters.size()];
        Iterator startersIterator = starters.iterator();
        for (int i3 = 0; i3 < starters.size(); ++i3) {
            startCharArray[i3] = ((Character)startersIterator.next()).charValue();
        }
        Arrays.sort(startCharArray);
        return startCharArray;
    }
}

