/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableEditTransaction
extends AbstractUndoableEdit {
    private List<UndoableEdit> edits = new LinkedList<UndoableEdit>();

    public <E extends UndoableEdit> UndoableEditTransaction add(E edit) {
        this.edits.add(edit);
        return this;
    }

    public UndoableEditTransaction addAll(Collection<? extends UndoableEdit> editList) {
        this.edits.addAll(editList);
        return this;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        ListIterator<UndoableEdit> it = this.edits.listIterator(this.edits.size());
        while (it.hasPrevious()) {
            UndoableEdit edit = it.previous();
            edit.undo();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (UndoableEdit edit : this.edits) {
            edit.redo();
        }
    }

    public int size() {
        return this.edits.size();
    }
}

