/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.nio.BufferOverflowException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.snmp4j.smi.OctetString;

public class OctetStringField
extends JComponent {
    private JPasswordField octetStringTextField;
    private JComboBox<String> formatComboBox;
    private JLabel asciiRepresentation;
    private JPanel panel;
    private EditMode mode;
    private EditMode editMode;
    private int minLength;
    private int maxLength;
    private boolean emptyAllowed;

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.octetStringTextField = new JPasswordField();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.octetStringTextField, gbc);
        this.formatComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("___");
        defaultComboBoxModel1.addElement("TXT");
        defaultComboBoxModel1.addElement("HEX");
        defaultComboBoxModel1.addElement("OCT");
        defaultComboBoxModel1.addElement("BIN");
        defaultComboBoxModel1.addElement("DEC");
        this.formatComboBox.setModel(defaultComboBoxModel1);
        this.formatComboBox.setToolTipText("Select the text format for the input field on the left");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add(this.formatComboBox, gbc);
        this.asciiRepresentation = new JLabel();
        this.asciiRepresentation.setText("");
        this.asciiRepresentation.setToolTipText("Displays the ASCII representation of the field content below");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.panel.add((Component)this.asciiRepresentation, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    public OctetStringField() {
        this.$$$setupUI$$$();
        this.mode = EditMode.TXT;
        this.editMode = EditMode.TXT;
        this.minLength = -1;
        this.maxLength = -1;
        this.setHidePassword(false);
        this.octetStringTextField.setDocument(new MyTextDocument());
        this.setMode(EditMode.TXT);
        this.formatComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    if (e2.getItem().equals("___")) {
                        OctetStringField.this.setOctetString(new OctetString());
                        OctetStringField.this.mode = OctetStringField.this.editMode;
                        OctetStringField.this.formatComboBox.setSelectedIndex(OctetStringField.this.mode.ordinal() + 1);
                    } else {
                        OctetString octetString = OctetStringField.this.getOctetString();
                        OctetStringField.this.mode = EditMode.valueOf((String)e2.getItem());
                        OctetStringField.this.setOctetString(octetString);
                    }
                }
            }
        });
        this.add(this.panel);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l2) {
        this.octetStringTextField.addKeyListener(l2);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l2) {
        this.octetStringTextField.removeKeyListener(l2);
    }

    @Override
    public synchronized KeyListener[] getKeyListeners() {
        return this.octetStringTextField.getKeyListeners();
    }

    public JPasswordField getOctetStringTextField() {
        return this.octetStringTextField;
    }

    public void setMode(EditMode mode) {
        if (mode != null) {
            this.formatComboBox.setSelectedIndex(mode.ordinal() + 1);
            OctetString octetString = this.getOctetString();
            this.mode = mode;
            this.setOctetString(octetString);
        } else {
            this.mode = EditMode.TXT;
        }
    }

    public void setEditMode(EditMode mode) {
        this.editMode = mode;
        this.setMode(mode);
    }

    public EditMode getEditMode() {
        return this.editMode;
    }

    @Override
    public void setInputVerifier(InputVerifier inputVerifier) {
        this.octetStringTextField.setInputVerifier(new OctetStringInputVerifier(inputVerifier));
    }

    @Override
    public InputVerifier getInputVerifier() {
        return ((OctetStringInputVerifier)this.octetStringTextField.getInputVerifier()).proxy;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.octetStringTextField.setEnabled(enabled);
        this.formatComboBox.setEnabled(enabled);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public EditMode getMode() {
        return this.mode;
    }

    public void setHidePassword(boolean hidePassword) {
        OctetStringField.showSecrets(this.octetStringTextField, !hidePassword);
    }

    public static void showSecrets(JPasswordField passwordField, boolean showSecrets) {
        passwordField.setEchoChar(showSecrets ? (char)'\u0000' : '*');
        passwordField.enableInputMethods(showSecrets);
        passwordField.putClientProperty("JPasswordField.cutCopyAllowed", showSecrets);
    }

    public void setOctetString(OctetString octetString) {
        if (octetString == null) {
            this.octetStringTextField.setText(null);
        } else if (this.mode == EditMode.TXT) {
            if (!octetString.isPrintable()) {
                this.mode = EditMode.HEX;
                this.octetStringTextField.setText(null);
                this.formatComboBox.setSelectedIndex(this.mode.ordinal() + 1);
                this.octetStringTextField.setText(octetString.toString(this.mode.separator, this.mode.radix));
            } else {
                this.octetStringTextField.setText(new String(octetString.getValue()));
            }
        } else {
            this.octetStringTextField.setText(octetString.toString(this.mode.separator, this.mode.radix));
        }
    }

    public OctetString getOctetString() {
        char[] currentValue = this.octetStringTextField.getPassword();
        if (currentValue != null) {
            try {
                return this.mode == EditMode.TXT ? OctetString.fromCharArray(currentValue) : OctetString.fromCharArray(currentValue, this.mode.separator, this.mode.radix);
            }
            catch (BufferOverflowException boe) {
                this.mode = EditMode.TXT;
                this.formatComboBox.setSelectedIndex(this.mode.ordinal() + 1);
                return OctetString.fromCharArray(currentValue);
            }
        }
        return null;
    }

    public static enum EditMode {
        TXT("", 0, ' '),
        HEX("abcdefABCDEF0123456789:", 16, ':'),
        OCT("01234567:", 8, ':'),
        BIN("01:", 2, ':'),
        DEC("01234567890.", 10, '.');

        private String allowedCharacters;
        private int radix;
        private char separator;

        private EditMode(String allowedCharacters, int radix, char separator) {
            this.allowedCharacters = allowedCharacters;
            this.radix = radix;
            this.separator = separator;
        }

        public int getRadix() {
            return this.radix;
        }

        public char getSeparator() {
            return this.separator;
        }
    }

    protected class MyTextDocument
    extends PlainDocument {
        private static final long serialVersionUID = 5983188846429737402L;

        protected MyTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j2 = 0;
            if (source.length == 0) {
                return;
            }
            if (OctetStringField.this.mode.allowedCharacters.length() > 0) {
                for (int i2 = 0; i2 < result.length; ++i2) {
                    boolean ok;
                    boolean bl = ok = !Character.isISOControl(source[i2]) && OctetStringField.this.mode.allowedCharacters.indexOf(source[i2]) >= 0;
                    if (!ok) continue;
                    result[j2++] = source[i2];
                }
                super.insertString(offs, new String(result, 0, j2), a2);
            } else {
                super.insertString(offs, new String(source), a2);
            }
        }
    }

    public class OctetStringInputVerifier
    extends InputVerifier {
        private InputVerifier proxy;
        private Color nativeBackground;

        protected OctetStringInputVerifier(InputVerifier proxy) {
            this.proxy = proxy;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            try {
                OctetString os = OctetStringField.this.getOctetString();
                if (!(!OctetStringField.this.emptyAllowed && OctetStringField.this.minLength > 0 || os != null && os.length() != 0)) {
                    ok = true;
                } else {
                    if (OctetStringField.this.minLength >= 0 && os.length() < OctetStringField.this.minLength) {
                        ok = false;
                    }
                    if (OctetStringField.this.maxLength >= 0 && os.length() > OctetStringField.this.maxLength) {
                        ok = false;
                    }
                }
            }
            catch (Exception ex) {
                ok = false;
            }
            if (ok && this.proxy != null) {
                ok = this.proxy.verify(input);
            }
            if (this.nativeBackground == null) {
                this.nativeBackground = OctetStringField.this.getBackground();
            }
            input.setBackground(ok ? this.nativeBackground : Color.pink);
            return ok;
        }
    }
}

