/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.PopupFindAction;
import com.agentpp.util.Regex;
import java.text.ParseException;
import javax.swing.ListModel;
import javax.swing.text.Position;

public abstract class ListModelPopupFindAction
extends PopupFindAction {
    protected boolean useExactMatch;

    protected ListModelPopupFindAction(boolean matchCase) {
        super(matchCase);
    }

    public int matchNext(ListModel model, String searchPattern, int startIndex, Position.Bias bias) {
        Regex regex;
        int max;
        block12: {
            max = model.getSize();
            if (searchPattern == null) {
                throw new IllegalArgumentException();
            }
            regex = new Regex();
            try {
                if (!this.matchCase) {
                    searchPattern = "(?i)" + (String)searchPattern;
                }
                if (this.useExactMatch) {
                    regex.compileWithExactMatch((String)searchPattern);
                } else {
                    regex.compile((String)searchPattern);
                }
            }
            catch (ParseException e2) {
                regex = null;
                if (this.matchCase) break block12;
                searchPattern = ((String)searchPattern).toUpperCase();
            }
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            Object item;
            if ((item = model.getElementAt(index)) == null) continue;
            String text = item.toString();
            if (!this.matchCase && regex == null) {
                text = text.toUpperCase();
            }
            if (text != null) {
                if (regex == null && text.startsWith((String)searchPattern)) {
                    return index;
                }
                if (regex != null && regex.match(text)) {
                    return index;
                }
            }
            index = (index + increment + max) % max;
        } while (index != startIndex);
        return -1;
    }
}

