/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.InstantSearchListener;
import com.agentpp.commons.ui.PopupFindAction;
import com.agentpp.util.Regex;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class JTextComponentFindAction
extends PopupFindAction {
    private static final long serialVersionUID = 4745258630164184032L;

    public JTextComponentFindAction(boolean matchCase) {
        super(matchCase);
        this.createPopup();
    }

    @Override
    protected Point getPopupLocation(Rectangle visibleRectangle) {
        return new Point(visibleRectangle.x + this.comp.getWidth() - this.popupMenu.getPreferredSize().width, this.getMinY(visibleRectangle.y, this.popupMenu.getPreferredSize().height));
    }

    @Override
    protected boolean changed(JComponent comp, String text, Position.Bias bias) {
        JTextComponent textComponent = (JTextComponent)comp;
        return this.searchAgain(textComponent, text, bias == Position.Bias.Backward ? InstantSearchListener.Direction.up : (bias == Position.Bias.Forward ? InstantSearchListener.Direction.down : InstantSearchListener.Direction.undefined), this.matchCase);
    }

    public boolean search(JTextComponent textComponent, String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        textComponent.setSelectionStart(0);
        textComponent.setSelectionEnd(0);
        return this.searchAgain(textComponent, text, direction, caseSensitive);
    }

    public boolean searchAgain(JTextComponent textComponent, String text, InstantSearchListener.Direction direction, boolean caseSensitive) {
        if (text == null || text.trim().length() == 0) {
            return false;
        }
        Regex lastSearchExpression = new Regex();
        Object s2 = text;
        if (!caseSensitive) {
            s2 = "(?i)" + (String)s2;
        }
        try {
            lastSearchExpression.compileWithExactMatch((String)s2);
            return JTextComponentFindAction.selectNextMatch(lastSearchExpression, textComponent, direction);
        }
        catch (ParseException pex) {
            return false;
        }
    }

    public static boolean selectNextMatch(Regex regex, final JTextComponent textComponent, final InstantSearchListener.Direction direction) {
        try {
            if (regex == null || textComponent == null || textComponent.getDocument().getLength() <= 0) {
                return false;
            }
            try {
                String text;
                List<int[]> matches;
                final int offset = InstantSearchListener.Direction.up == direction || textComponent.getSelectionEnd() < 0 ? 0 : (InstantSearchListener.Direction.down == direction ? textComponent.getSelectionEnd() : textComponent.getSelectionStart());
                int endPos = textComponent.getDocument().getLength();
                if (InstantSearchListener.Direction.up == direction && textComponent.getSelectionStart() >= 0) {
                    endPos = textComponent.getSelectionStart();
                }
                if ((matches = regex.allMatchPositions(text = textComponent.getDocument().getText(offset, endPos - offset), direction == InstantSearchListener.Direction.up ? 0 : 1)).isEmpty()) {
                    return false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.getCaret().setSelectionVisible(true);
                        if (InstantSearchListener.Direction.up == direction) {
                            textComponent.setCaretPosition(((int[])matches.get(matches.size() - 1))[0] + offset);
                            textComponent.moveCaretPosition(((int[])matches.get(matches.size() - 1))[1] + offset);
                        } else {
                            textComponent.setCaretPosition(((int[])matches.get(0))[0] + offset);
                            textComponent.moveCaretPosition(((int[])matches.get(0))[1] + offset);
                        }
                    }
                });
                return true;
            }
            catch (BadLocationException e2) {
                e2.printStackTrace();
            }
        }
        catch (NullPointerException npx) {
            npx.printStackTrace();
        }
        return false;
    }
}

