/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.agentpp.commons.ui.InstantSearchListener;
import com.agentpp.commons.ui.ListSelectionPanel;
import com.agentpp.commons.util.LimitedHistory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;

public class InstantSearchPanel {
    private JPanel panel;
    private JButton buttonHistory;
    private JTextField textFieldSearch;
    private JButton buttonClear;
    private JButton buttonUp;
    private JButton buttonDown;
    private JPanel searchTextPanel;
    private JCheckBox checkBoxCaseSensitive;
    private InstantSearchListener searchListener;
    private ThreadPoolExecutor searcher;
    private BlockingQueue<Runnable> searchQueue;
    private Color textFieldBackground;
    private LimitedHistory<String> searchHistory;
    private Popup searchHistoryPopup;

    public InstantSearchPanel(final InstantSearchListener searchListener, int searchHistoryLimit) {
        this.$$$setupUI$$$();
        this.searchHistory = new LimitedHistory(searchHistoryLimit);
        this.textFieldBackground = this.textFieldSearch.getBackground();
        this.searchListener = searchListener;
        this.searchQueue = new LinkedBlockingQueue<Runnable>();
        this.searcher = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, this.searchQueue);
        this.textFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                final String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                if (searchString != null && searchString.trim().length() > 0) {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            if (searchListener.search(searchString, InstantSearchListener.Direction.down, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                                InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                            } else {
                                InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                            }
                        }
                    };
                    InstantSearchPanel.this.searchQueue.clear();
                    InstantSearchPanel.this.searcher.execute(task);
                }
            }
        });
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                InstantSearchPanel.this.searchHistory.add(searchString);
                if (searchListener.searchAgain(searchString, InstantSearchListener.Direction.down, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                    InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                } else {
                    InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                }
            }
        });
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String searchString = InstantSearchPanel.this.textFieldSearch.getText();
                InstantSearchPanel.this.searchHistory.add(searchString);
                if (searchListener.searchAgain(searchString, InstantSearchListener.Direction.up, InstantSearchPanel.this.checkBoxCaseSensitive.isSelected())) {
                    InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
                } else {
                    InstantSearchPanel.this.textFieldSearch.setBackground(Color.pink);
                }
            }
        });
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                InstantSearchPanel.this.textFieldSearch.setText("");
                InstantSearchPanel.this.textFieldSearch.setBackground(InstantSearchPanel.this.textFieldBackground);
            }
        });
        this.checkBoxCaseSensitive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
            }
        });
        this.buttonHistory.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (InstantSearchPanel.this.searchHistoryPopup != null) {
                    InstantSearchPanel.this.searchHistoryPopup.hide();
                    InstantSearchPanel.this.searchHistoryPopup = null;
                    return;
                }
                Point popupLocation = InstantSearchPanel.this.buttonHistory.getPopupLocation(e2);
                if (popupLocation == null) {
                    popupLocation = e2.getLocationOnScreen();
                }
                final ListSelectionPanel listSelectionPanel = new ListSelectionPanel();
                listSelectionPanel.setListData(InstantSearchPanel.this.searchHistory);
                InstantSearchPanel.this.searchHistoryPopup = PopupFactory.getSharedInstance().getPopup(InstantSearchPanel.this.panel, listSelectionPanel.getPanel(), popupLocation.x, popupLocation.y);
                listSelectionPanel.setListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e2) {
                        if (!e2.getValueIsAdjusting()) {
                            Popup popup = InstantSearchPanel.this.searchHistoryPopup;
                            if (popup != null) {
                                popup.hide();
                            }
                            InstantSearchPanel.this.textFieldSearch.setText(String.valueOf(listSelectionPanel.getSelectedItem()));
                        }
                    }
                });
                listSelectionPanel.getPanel().setFocusable(true);
                listSelectionPanel.setKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e2) {
                        Popup popup;
                        if (e2.getKeyCode() == 27 && (popup = InstantSearchPanel.this.searchHistoryPopup) != null) {
                            popup.hide();
                        }
                    }
                });
                InstantSearchPanel.this.textFieldSearch.setCaret(new DefaultCaret());
                InstantSearchPanel.this.searchHistoryPopup.show();
            }
        });
    }

    public void setSearchHistory(List<String> searchHistory) {
        this.searchHistory.addAll(searchHistory);
    }

    public List<String> getSearchHistory() {
        return this.searchHistory;
    }

    public void setText(String text) {
        this.textFieldSearch.setText(text);
    }

    public String getText() {
        return this.textFieldSearch.getText();
    }

    public void setMatchCase(boolean matchCase) {
        this.checkBoxCaseSensitive.setSelected(matchCase);
    }

    public boolean isMatchCase() {
        return this.checkBoxCaseSensitive.isSelected();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10), null, 0, 0, null, null));
        this.searchTextPanel = new JPanel();
        this.searchTextPanel.setLayout(new GridBagLayout());
        this.searchTextPanel.setBackground(UIManager.getColor("Button.background"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.panel.add((Component)this.searchTextPanel, gbc);
        this.buttonHistory = new JButton();
        this.buttonHistory.setBorderPainted(false);
        this.buttonHistory.setContentAreaFilled(false);
        this.buttonHistory.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/FindAgain16.gif")));
        this.buttonHistory.setText("");
        this.buttonHistory.setToolTipText("Search History");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.searchTextPanel.add((Component)this.buttonHistory, gbc);
        this.textFieldSearch = new JTextField();
        this.textFieldSearch.setColumns(12);
        this.textFieldSearch.setDropMode(DropMode.INSERT);
        this.textFieldSearch.setFocusAccelerator('F');
        this.textFieldSearch.setInheritsPopupMenu(false);
        this.textFieldSearch.setMargin(new Insets(2, 6, 2, 6));
        this.textFieldSearch.setMinimumSize(new Dimension(100, 20));
        this.textFieldSearch.setOpaque(true);
        this.textFieldSearch.setToolTipText("Enter search string");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.searchTextPanel.add((Component)this.textFieldSearch, gbc);
        this.buttonClear = new JButton();
        this.buttonClear.setBorderPainted(false);
        this.buttonClear.setContentAreaFilled(false);
        this.buttonClear.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Delete16.gif")));
        this.buttonClear.setText("");
        this.buttonClear.setToolTipText("Clear Search Text");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.searchTextPanel.add((Component)this.buttonClear, gbc);
        this.buttonUp = new JButton();
        this.buttonUp.setBorderPainted(false);
        this.buttonUp.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif")));
        this.buttonUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonUp.setText("");
        this.buttonUp.setToolTipText("Next Occurrence");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)this.buttonUp, gbc);
        this.buttonDown = new JButton();
        this.buttonDown.setBorderPainted(false);
        this.buttonDown.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif")));
        this.buttonDown.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDown.setText("");
        this.buttonDown.setToolTipText("Previous Occurrence");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)this.buttonDown, gbc);
        this.checkBoxCaseSensitive = new JCheckBox();
        this.checkBoxCaseSensitive.setActionCommand("MatchCase");
        this.checkBoxCaseSensitive.setLabel("Match Case");
        this.checkBoxCaseSensitive.setText("Match Case");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.panel.add((Component)this.checkBoxCaseSensitive, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

