/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class AutoCompletionJCStringCellEditor
extends JCStringCellEditor
implements DocumentListener {
    private final SortedSet<String> keywords;
    private Mode mode = Mode.INSERT;

    public AutoCompletionJCStringCellEditor(SortedSet<String> keywords) {
        this.keywords = keywords;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int code = keyEvent.getKeyCode();
        switch (code) {
            case 38: {
                this.updateText(this.getText(), this.getCaretPosition() - 1, -1);
                if (this.mode != Mode.COMPLETION) break;
                keyEvent.consume();
                keyEvent.setKeyCode(0);
                return;
            }
            case 40: {
                this.updateText(this.getText(), this.getCaretPosition() - 1, 1);
                if (this.mode != Mode.COMPLETION) break;
                keyEvent.consume();
                keyEvent.setKeyCode(0);
                return;
            }
        }
        super.keyPressed(keyEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.getText(0, pos + 1);
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
        }
        this.updateText(content, pos, 0);
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
    }

    @Override
    public void initialize(AWTEvent awtEvent, JCCellInfo jcCellInfo, Object o2) {
        this.getDocument().removeDocumentListener(this);
        this.getDocument().addDocumentListener(this);
        super.initialize(awtEvent, jcCellInfo, o2);
    }

    private void updateText(String content, int pos, int cycleOffset) {
        int wordStartPos;
        for (wordStartPos = pos; content != null && wordStartPos >= 0 && Character.isLetter(content.charAt(wordStartPos)); --wordStartPos) {
        }
        if (pos - wordStartPos < 1) {
            return;
        }
        String searchStart = content.substring(wordStartPos + 1);
        String prefix = content.length() > this.getCaretPosition() ? content.substring(wordStartPos + 1, Math.max(this.getCaretPosition(), 1)) : searchStart;
        SortedSet<String> tail = this.keywords.tailSet(searchStart);
        if (cycleOffset < 0) {
            SortedSet<String> headSet = this.keywords.headSet(searchStart);
            if (!headSet.isEmpty() && headSet.last().startsWith(prefix)) {
                String completion = headSet.last().substring(pos - wordStartPos);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1, false));
            }
        } else if (!tail.isEmpty()) {
            Iterator next = tail.iterator();
            String first = (String)next.next();
            while (cycleOffset-- > 0 && next.hasNext()) {
                first = (String)next.next();
            }
            if (first.startsWith(prefix)) {
                String completion = first.substring(pos - wordStartPos);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1, cycleOffset == 0));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }

    private class CompletionTask
    implements Runnable {
        private final String completion;
        private final int position;
        private final boolean moveForward;

        CompletionTask(String completion, int position, boolean moveForward) {
            this.completion = completion;
            this.position = position;
            this.moveForward = moveForward;
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder(AutoCompletionJCStringCellEditor.this.getText().substring(0, this.position));
            sb.insert(this.position, this.completion);
            AutoCompletionJCStringCellEditor.this.setText(sb.toString());
            AutoCompletionJCStringCellEditor.this.setCaretPosition(this.position + this.completion.length());
            AutoCompletionJCStringCellEditor.this.moveCaretPosition(this.position + (this.moveForward ? -1 : 0));
            AutoCompletionJCStringCellEditor.this.mode = this.moveForward ? Mode.INSERT : Mode.COMPLETION;
        }
    }
}

