/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class AutoCompletion
implements DocumentListener {
    private final JTextField textField;
    private final SortedSet<String> keywords;
    private Mode mode = Mode.INSERT;

    public AutoCompletion(final JTextField textField, SortedSet<String> keywords) {
        this.textField = textField;
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                int code = e2.getKeyCode();
                switch (code) {
                    case 38: {
                        AutoCompletion.this.updateText(textField.getText(), textField.getCaretPosition() - 1, -1);
                        break;
                    }
                    case 40: {
                        AutoCompletion.this.updateText(textField.getText(), textField.getCaretPosition() - 1, 1);
                        break;
                    }
                    case 9: {
                        if (textField.getSelectionStart() != textField.getCaretPosition()) break;
                        textField.moveCaretPosition(textField.getSelectionEnd());
                    }
                }
            }
        });
        this.keywords = keywords;
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.textField.getText(0, pos + 1);
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
        }
        this.updateText(content, pos, 0);
    }

    private void updateText(String content, int pos, int cycleOffset) {
        int wordStartPos;
        for (wordStartPos = pos; content != null && wordStartPos >= 0 && Character.isLetter(content.charAt(wordStartPos)); --wordStartPos) {
        }
        if (pos - wordStartPos < 2) {
            return;
        }
        String searchStart = content.substring(wordStartPos + 1);
        String prefix = content.length() > this.textField.getCaretPosition() ? content.substring(wordStartPos + 1, this.textField.getCaretPosition()) : searchStart;
        SortedSet<String> tail = this.keywords.tailSet(searchStart);
        if (cycleOffset < 0) {
            SortedSet<String> headSet = this.keywords.headSet(searchStart);
            if (!headSet.isEmpty() && headSet.last().startsWith(prefix)) {
                String completion = headSet.last().substring(pos - wordStartPos);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1, false));
            }
        } else if (!tail.isEmpty()) {
            Iterator next = tail.iterator();
            String first = (String)next.next();
            while (cycleOffset-- > 0 && next.hasNext()) {
                first = (String)next.next();
            }
            if (first.startsWith(prefix)) {
                String completion = first.substring(pos - wordStartPos);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1, cycleOffset == 0));
            }
        } else {
            this.mode = Mode.INSERT;
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }

    private class CompletionTask
    implements Runnable {
        private final String completion;
        private final int position;
        private final boolean moveForward;

        CompletionTask(String completion, int position, boolean moveForward) {
            this.completion = completion;
            this.position = position;
            this.moveForward = moveForward;
        }

        @Override
        public void run() {
            StringBuilder sb = new StringBuilder(AutoCompletion.this.textField.getText().substring(0, this.position));
            sb.insert(this.position, this.completion);
            AutoCompletion.this.textField.setText(sb.toString());
            AutoCompletion.this.textField.setCaretPosition(this.position + this.completion.length());
            AutoCompletion.this.textField.moveCaretPosition(this.position + (this.moveForward ? -1 : 0));
            AutoCompletion.this.mode = this.moveForward ? Mode.INSERT : Mode.COMPLETION;
        }
    }
}

