/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.ui;

import java.awt.Color;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AgentppStringField
extends JTextField {
    public static final String DECIMAL_DIGITS = "0123456789";
    public static final String ASCII_LETTERS_AND_DIGITS = "0123456789abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private String allowedCharacters = "";
    private int minLength = -1;
    private int maxLength = -1;
    private boolean emptyAllowed;

    public AgentppStringField(String allowedCharacters, int minLength, int maxLength, boolean emptyAllowed) {
        this.allowedCharacters = allowedCharacters;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.emptyAllowed = emptyAllowed;
        this.setDocument(new MyTextDocument());
    }

    public AgentppStringField(String text, String allowedCharacters, int minLength, int maxLength, boolean emptyAllowed) {
        super(text);
        this.allowedCharacters = allowedCharacters;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.emptyAllowed = emptyAllowed;
        this.setDocument(new MyTextDocument());
    }

    public AgentppStringField(int columns, String allowedCharacters, int minLength, int maxLength, boolean emptyAllowed) {
        super(columns);
        this.allowedCharacters = allowedCharacters;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.emptyAllowed = emptyAllowed;
        this.setDocument(new MyTextDocument());
    }

    public AgentppStringField(String text, int columns, String allowedCharacters, int minLength, int maxLength, boolean emptyAllowed) {
        super(text, columns);
        this.allowedCharacters = allowedCharacters;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.emptyAllowed = emptyAllowed;
        this.setDocument(new MyTextDocument());
    }

    protected class MyTextDocument
    extends PlainDocument {
        private static final long serialVersionUID = 5983188846429737402L;

        protected MyTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j2 = 0;
            if (source.length == 0) {
                return;
            }
            if (AgentppStringField.this.allowedCharacters.length() > 0) {
                for (int i2 = 0; i2 < result.length; ++i2) {
                    boolean ok;
                    boolean bl = ok = !Character.isISOControl(source[i2]) && AgentppStringField.this.allowedCharacters.indexOf(source[i2]) >= 0;
                    if (!ok) continue;
                    result[j2++] = source[i2];
                }
                super.insertString(offs, new String(result, 0, j2), a2);
            } else {
                super.insertString(offs, new String(source), a2);
            }
        }
    }

    public class StringInputVerifier
    extends InputVerifier {
        private final InputVerifier proxy;
        private Color nativeBackground;

        protected StringInputVerifier(InputVerifier proxy) {
            this.proxy = proxy;
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            try {
                String text = AgentppStringField.this.getText();
                if (!(!AgentppStringField.this.emptyAllowed && AgentppStringField.this.minLength > 0 || text != null && text.length() != 0)) {
                    ok = true;
                } else {
                    if (AgentppStringField.this.minLength >= 0 && text.length() < AgentppStringField.this.minLength) {
                        ok = false;
                    }
                    if (AgentppStringField.this.maxLength >= 0 && text.length() > AgentppStringField.this.maxLength) {
                        ok = false;
                    }
                }
            }
            catch (Exception ex) {
                ok = false;
            }
            if (ok && this.proxy != null) {
                ok = this.proxy.verify(input);
            }
            if (this.nativeBackground == null) {
                this.nativeBackground = AgentppStringField.this.getBackground();
            }
            input.setBackground(ok ? this.nativeBackground : Color.pink);
            return ok;
        }
    }
}

