/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.snmp.GenTarget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.util.TreeSet;
import java.util.function.BiFunction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

public class VariableLookup<V extends Comparable> {
    private JPanel panel;
    private JScrollPane scrollPane;
    private JList<V> variableList;
    private final DefaultListModel<V> listModel = new DefaultListModel();

    public VariableLookup(Snmp snmp, GenTarget target, OID[] columns, final BiFunction<OID, VariableBinding[], V> mapping, final int maxEntries) {
        this.$$$setupUI$$$();
        this.variableList.setModel(this.listModel);
        TableUtils tableUtils = new TableUtils(snmp, new DefaultPDUFactory(-91, target.getContextEngineID(), target.getContext()));
        tableUtils.getTable(target.getTarget(), columns, new TableListener(){
            private final TreeSet<V> values = new TreeSet();

            @Override
            public boolean next(TableEvent event) {
                if (!event.isError()) {
                    VariableBinding[] cols = event.getColumns();
                    Comparable variable = (Comparable)mapping.apply(event.getIndex(), cols);
                    if (variable != null) {
                        this.values.add(variable);
                    }
                }
                return this.values.size() < maxEntries;
            }

            @Override
            public void finished(TableEvent event) {
                this.next(event);
                VariableLookup.this.variableList.setValueIsAdjusting(true);
                for (Comparable value : this.values) {
                    VariableLookup.this.addListItem(value);
                }
                SwingUtilities.invokeLater(() -> {
                    VariableLookup.this.variableList.setValueIsAdjusting(false);
                    VariableLookup.this.variableList.updateUI();
                });
            }

            @Override
            public boolean isFinished() {
                return false;
            }
        }, null, null, null);
    }

    public void setKeyListener(KeyListener keyListener) {
        this.scrollPane.addKeyListener(keyListener);
    }

    public void setListSelectionListener(ListSelectionListener listSelectionListener) {
        this.variableList.removeListSelectionListener(listSelectionListener);
        this.variableList.addListSelectionListener(listSelectionListener);
    }

    public V getSelectedItem() {
        return (V)((Comparable)this.variableList.getSelectedValue());
    }

    public void addListItem(V item) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.listModel.addElement(item));
        } else {
            this.listModel.addElement(item);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.scrollPane, gbc);
        this.variableList = new JList();
        this.variableList.setSelectionMode(0);
        this.scrollPane.setViewportView(this.variableList);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

