/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.snmp.UsmUserEditorPanel;
import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.commons.ui.UIObjectUpdateListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.UserProfile;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.snmp4j.CertifiedTarget;
import org.snmp4j.DirectUserTarget;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class TargetEditorPanel {
    public static final int VERSION_TYPE_TLS = 4;
    public static final int VERSION_TYPE_USM = 3;
    public static final int VERSION_TYPE_DIRECT_USERV3 = 2;
    private JLabel targetNameLabel;
    private JTextField targetNameField;
    private JLabel transportLabel;
    private JComboBox<String> transportComboBox;
    private JButton addressLabel;
    private JTextField addressTextField;
    private JLabel versionLabel;
    private JComboBox versionComboBox;
    private JLabel timeoutLabel;
    private JLabel retriesLabel;
    private JLabel mibSetLabel;
    private JComboBox<String> mibSetComboBox;
    private JPanel versionSpecificFieldPanel;
    private JPanel securityModelSpecificPanel;
    private JPanel usmPanel;
    private JPanel communityBasedPanel;
    private JLabel communityLabel;
    private JPanel v3Panel;
    private JPanel localizedUserPanel;
    private JPanel tlsPanel;
    private JLabel userLabel;
    private JLabel securityNameLabel;
    private OctetStringField securityName;
    private JComboBox<String> userComboBox;
    private JLabel contextNameLabel;
    private JLabel contextEngineIdLabel;
    private OctetStringField contextEngineID;
    private OctetStringField contextName;
    private JButton securityEngineIdLabel;
    private OctetStringField securityEngineID;
    private JSpinner timeout;
    private JSpinner retries;
    private OctetStringField community;
    private JPanel panel;
    private JLabel authProtocolLabel;
    private JLabel privProtocolLabel;
    private JComboBox<String> authProtocol;
    private JComboBox<String> privProtocol;
    private JButton authKeyLabel;
    private JButton privKeyLabel;
    private OctetStringField authKey;
    private OctetStringField privKey;
    private JCheckBox showSecrets;
    private OctetString localizedUserEngineID;
    private GenTarget target;
    private Map<String, UserProfile> userList = new HashMap<String, UserProfile>();
    private UIObjectUpdateListener<GenTarget> updateListener;
    private UpdateInputVerifier updateInputVerifier = new UpdateInputVerifier();
    private volatile boolean updating;
    public static final String ACTION_DISCOVER_ENGINE_ID = "Discover Engine ID";
    public static final String ACTION_TEST_CONNECTIVITY = "Test Connectivity";
    public static final String ACTION_LOCALISE_AUTH_KEY = "Localize Authentication Key";
    public static final String ACTION_LOCALISE_PRIV_KEY = "Localize Privacy Key";
    private int tlsTransportTypesStartIndex = 2;

    public TargetEditorPanel() {
        this.$$$setupUI$$$();
        this.contextEngineID.setEditMode(OctetStringField.EditMode.HEX);
        this.securityEngineID.setEditMode(OctetStringField.EditMode.HEX);
        this.timeout.setModel(new SpinnerNumberModel((Number)5000, Integer.valueOf(1), null, (Number)1000));
        this.retries.setModel(new SpinnerNumberModel(1, 0, 100000, 1));
        this.targetNameField.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setInputVerifier(this.updateInputVerifier);
        this.securityEngineID.setInputVerifier(this.updateInputVerifier);
        this.contextName.setInputVerifier(this.updateInputVerifier);
        this.community.setInputVerifier(this.updateInputVerifier);
        this.mibSetComboBox.setInputVerifier(this.updateInputVerifier);
        this.timeout.setInputVerifier(this.updateInputVerifier);
        this.retries.setInputVerifier(this.updateInputVerifier);
        this.addressTextField.setInputVerifier(this.updateInputVerifier);
        this.versionComboBox.setInputVerifier(this.updateInputVerifier);
        this.transportComboBox.setInputVerifier(this.updateInputVerifier);
        this.contextEngineID.setMinLength(5);
        this.contextEngineID.setMaxLength(32);
        this.contextEngineID.setEmptyAllowed(true);
        this.securityEngineID.setMinLength(5);
        this.securityEngineID.setMaxLength(32);
        this.securityEngineID.setEmptyAllowed(true);
        this.contextEngineID.setEditMode(OctetStringField.EditMode.HEX);
        this.securityEngineID.setEditMode(OctetStringField.EditMode.HEX);
        this.setEnabled(false);
        this.versionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    switch (TargetEditorPanel.this.versionComboBox.getSelectedIndex()) {
                        case 0: 
                        case 1: {
                            TargetEditorPanel.this.showCommunityBased();
                            TargetEditorPanel.this.showTLS();
                            break;
                        }
                        case 2: {
                            TargetEditorPanel.this.showUserBased();
                            TargetEditorPanel.this.showLocalizedUser();
                            break;
                        }
                        case 3: {
                            TargetEditorPanel.this.showUserBased();
                            TargetEditorPanel.this.showUSM();
                            break;
                        }
                        case 4: {
                            int newIndex;
                            TargetEditorPanel.this.showUserBased();
                            TargetEditorPanel.this.showTLS();
                            if (!TargetEditorPanel.this.isNonTlsTransport() || (newIndex = TargetEditorPanel.this.transportComboBox.getSelectedIndex() + TargetEditorPanel.this.tlsTransportTypesStartIndex) >= TargetEditorPanel.this.transportComboBox.getItemCount()) break;
                            TargetEditorPanel.this.transportComboBox.setSelectedIndex(newIndex);
                        }
                    }
                }
                TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.versionComboBox);
            }
        });
        this.userComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    TargetEditorPanel.this.updateInputVerifier.verify(TargetEditorPanel.this.userComboBox);
                }
            }
        });
        this.showSecrets.addItemListener(new ShowSecretsAdapter(this));
        this.showSecrets.setSelected(false);
        this.setShowSecrets(false);
        this.authProtocol.addItem("");
        this.authProtocol.addItem("MD5");
        this.authProtocol.addItem("SHA-1");
        this.authProtocol.addItem("SHA224");
        this.authProtocol.addItem("SHA256");
        this.authProtocol.addItem("SHA384");
        this.authProtocol.addItem("SHA512");
        this.privProtocol.addItem("");
        this.privProtocol.addItem("DES");
        this.privProtocol.addItem("3DES");
        this.privProtocol.addItem("AES128");
        this.privProtocol.addItem("AES192");
        this.privProtocol.addItem("AES256");
        this.privProtocol.addItem("AES192-KeyExt3DES");
        this.privProtocol.addItem("AES256-KeyExt3DES");
        this.authKeyLabel.setActionCommand(ACTION_LOCALISE_AUTH_KEY);
        this.privKeyLabel.setActionCommand(ACTION_LOCALISE_PRIV_KEY);
        this.transportComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    switch (e2.getItem().toString().toLowerCase()) {
                        case "dtls": 
                        case "tls": {
                            TargetEditorPanel.this.versionComboBox.setEnabled(false);
                            TargetEditorPanel.this.versionComboBox.setSelectedIndex(4);
                            break;
                        }
                        default: {
                            TargetEditorPanel.this.versionComboBox.setEnabled(true);
                            if (TargetEditorPanel.this.versionComboBox.getSelectedIndex() != 4) break;
                            TargetEditorPanel.this.versionComboBox.setSelectedIndex(2);
                        }
                    }
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.targetNameField.setEnabled(enabled);
        this.contextEngineID.setEnabled(enabled);
        this.securityEngineID.setEnabled(enabled);
        this.contextName.setEnabled(enabled);
        this.community.setEnabled(enabled);
        this.mibSetComboBox.setEnabled(enabled);
        this.timeout.setEnabled(enabled);
        this.retries.setEnabled(enabled);
        this.addressTextField.setEnabled(enabled);
        this.versionComboBox.setEnabled(enabled && this.isNonTlsTransport());
        this.transportComboBox.setEnabled(enabled);
        this.userComboBox.setEnabled(enabled);
        this.addressLabel.setEnabled(enabled);
        this.securityEngineIdLabel.setEnabled(enabled);
    }

    private boolean isNonTlsTransport() {
        return this.transportComboBox.getSelectedIndex() < this.tlsTransportTypesStartIndex;
    }

    public void setUserList(Collection<UserProfile> userList) {
        this.userComboBox.removeAllItems();
        this.userComboBox.addItem(null);
        this.userList.clear();
        for (UserProfile userProfile : userList) {
            this.userList.put(userProfile.getName(), userProfile);
        }
        ArrayList<String> sortedUserList = new ArrayList<String>(this.userList.keySet());
        Collections.sort(sortedUserList);
        for (String userName : sortedUserList) {
            this.userComboBox.addItem(userName);
        }
    }

    public void addActionListener(ActionListener l2) {
        this.securityEngineIdLabel.addActionListener(l2);
        this.addressLabel.addActionListener(l2);
        this.authKeyLabel.addActionListener(l2);
        this.privKeyLabel.addActionListener(l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.securityEngineIdLabel.removeActionListener(l2);
        this.addressLabel.removeActionListener(l2);
        this.authKeyLabel.removeActionListener(l2);
        this.privKeyLabel.removeActionListener(l2);
    }

    public void setMibSetList(Collection<String> mibSetList) {
        this.mibSetComboBox.removeAllItems();
        for (String mibSet : mibSetList) {
            this.mibSetComboBox.addItem(mibSet);
        }
    }

    public void setTransportList(Collection<String> transportList) {
        this.transportComboBox.removeAllItems();
        for (String transportID : transportList) {
            this.transportComboBox.addItem(transportID);
        }
    }

    public void setTarget(GenTarget target) {
        this.updateFields(target);
        if (target == null || target.getVersion() == 3) {
            this.showUserBased();
            if (target != null && target.getTarget() instanceof CertifiedTarget) {
                this.showTLS();
            } else if (target != null && target.getTarget() instanceof DirectUserTarget) {
                this.showLocalizedUser();
            } else {
                this.showUSM();
            }
        } else {
            this.showCommunityBased();
            this.showTLS();
        }
        this.targetNameField.setBackground(Color.white);
        this.setEnabled(target != null);
    }

    private void showCommunityBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "Community Based");
    }

    private void showUserBased() {
        ((CardLayout)this.versionSpecificFieldPanel.getLayout()).show(this.versionSpecificFieldPanel, "SNMPv3");
    }

    private void showUSM() {
        ((CardLayout)this.securityModelSpecificPanel.getLayout()).show(this.securityModelSpecificPanel, "USM User");
    }

    private void showTLS() {
        ((CardLayout)this.securityModelSpecificPanel.getLayout()).show(this.securityModelSpecificPanel, "(D)TLS");
    }

    private void showLocalizedUser() {
        ((CardLayout)this.securityModelSpecificPanel.getLayout()).show(this.securityModelSpecificPanel, "Localized User");
    }

    public UIObjectUpdateListener<GenTarget> getUpdateListener() {
        return this.updateListener;
    }

    public void setUpdateListener(UIObjectUpdateListener<GenTarget> updateListener) {
        this.updateListener = updateListener;
    }

    public GenTarget getTarget() {
        return this.target;
    }

    public GenTarget updateTarget() {
        this.updateTarget(this.target);
        return this.target;
    }

    public OctetString getAuthKey() {
        return this.authKey.getOctetString();
    }

    public OctetString getPrivKey() {
        return this.privKey.getOctetString();
    }

    public OID getAuthenticationProtocol() {
        return UsmUserEditorPanel.getSecurityProtocol(Objects.requireNonNull(this.authProtocol.getSelectedItem()).toString());
    }

    public OID getPrivacyProtocol() {
        return UsmUserEditorPanel.getSecurityProtocol(Objects.requireNonNull(this.privProtocol.getSelectedItem()).toString());
    }

    public OctetString getEngineID() {
        return this.securityEngineID.getOctetString();
    }

    public void setAuthKey(OctetString authKey) {
        this.authKey.setOctetString(null);
        this.authKey.setEditMode(OctetStringField.EditMode.HEX);
        this.authKey.setOctetString(authKey);
    }

    public void setPrivKey(OctetString privKey) {
        this.privKey.setOctetString(null);
        this.privKey.setEditMode(OctetStringField.EditMode.HEX);
        this.privKey.setOctetString(privKey);
    }

    private void updateTarget(GenTarget target) {
        if (target == null) {
            return;
        }
        GenTarget orig = new GenTarget(target);
        target.setName(this.targetNameField.getText());
        target.setAddressString(this.addressTextField.getText());
        target.setAddressType((String)this.transportComboBox.getSelectedItem());
        target.setCommunity(this.community.getOctetString());
        target.setContext(this.contextName.getOctetString());
        target.setEngineID(this.securityEngineID.getOctetString());
        target.setMIBSet((String)this.mibSetComboBox.getSelectedItem());
        target.setContextEngineID(this.contextEngineID.getOctetString());
        target.setRetries((Integer)this.retries.getValue());
        target.setTimeout((Integer)this.timeout.getValue());
        target.setTargetType(GenTarget.TargetType.community);
        if (this.versionComboBox.getSelectedIndex() == 2) {
            UsmUser directUsmUser = new UsmUser(this.securityName.getOctetString(), UsmUserEditorPanel.getSecurityProtocol((String)this.authProtocol.getSelectedItem()), this.authKey.getOctetString(), UsmUserEditorPanel.getSecurityProtocol((String)this.privProtocol.getSelectedItem()), this.privKey.getOctetString(), this.getEngineID());
            UserProfile directUser = new UserProfile("", directUsmUser);
            target.setUser(directUser);
            target.setDirectUser(true);
        } else if (this.versionComboBox.getSelectedIndex() == 3) {
            target.setTargetType(GenTarget.TargetType.usmUser);
            target.setUser(this.userComboBox.getSelectedItem() == null ? null : this.userList.get(this.userComboBox.getSelectedItem()));
        } else if (this.versionComboBox.getSelectedIndex() == 4) {
            target.setTargetType(GenTarget.TargetType.certified);
            target.setUser(this.userComboBox.getSelectedItem() == null ? null : this.userList.get(this.userComboBox.getSelectedItem()));
        } else {
            target.setUser(null);
        }
        target.setVersion(TargetEditorPanel.getSnmpVersionFromIndex(this.versionComboBox.getSelectedIndex()));
        if (!target.equals(orig)) {
            target.setLastUpdated(Instant.now());
            target.setAddress(null);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private static int getSnmpVersionIndex(int snmpVersion, String addressType, boolean directUser) {
        int index = snmpVersion;
        if (index >= 3) {
            --index;
            if (addressType.toUpperCase().endsWith("TLS")) {
                index = 4;
            } else if (!directUser) {
                index = 3;
            }
        }
        return index;
    }

    private static int getSnmpVersionFromIndex(int snmpVersionIndex) {
        if (snmpVersionIndex >= 2) {
            return 3;
        }
        return snmpVersionIndex;
    }

    private void updateFields(GenTarget target) {
        this.updating = true;
        if (target != null) {
            this.userComboBox.setSelectedItem(target.getUser() == null ? null : target.getUser().getName());
            this.targetNameField.setText(target.getName());
            this.transportComboBox.setSelectedItem(target.getAddressType());
            this.addressTextField.setText(target.getAddressString());
            this.timeout.setValue(target.getTimeout());
            this.retries.setValue(target.getRetries());
            this.versionComboBox.setSelectedIndex(TargetEditorPanel.getSnmpVersionIndex(target.getVersion(), target.getAddressType(), target.isDirectUser()));
            this.mibSetComboBox.setSelectedItem(target.getMIBSet());
            this.community.setOctetString(target.getCommunity());
            this.contextName.setOctetString(target.getContext());
            this.contextEngineID.setOctetString(target.getContextEngineID());
            this.securityEngineID.setOctetString(target.getEngineID());
            if (target.getTarget() instanceof DirectUserTarget) {
                if (target.getUser() != null) {
                    UsmUser usmUser = target.getUser().getUser();
                    if (usmUser != null) {
                        this.securityName.setOctetString(usmUser.getSecurityName());
                        this.authKey.setOctetString(usmUser.getAuthenticationPassphrase());
                        this.authProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(usmUser.getAuthenticationProtocol()));
                        this.privKey.setOctetString(usmUser.getPrivacyPassphrase());
                        this.privProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(usmUser.getPrivacyProtocol()));
                        this.localizedUserEngineID = usmUser.getLocalizationEngineID();
                    } else {
                        this.resetDirectUserFields();
                    }
                }
            } else if (target.getUser() != null && target.getUser().getUser() != null) {
                this.securityName.setOctetString(target.getUser().getUser().getSecurityName());
                this.resetDirectUserFields();
            }
        } else {
            this.userComboBox.setSelectedItem(null);
            this.targetNameField.setText("");
            this.transportComboBox.setSelectedItem(null);
            this.addressTextField.setText("");
            this.timeout.setValue(0);
            this.retries.setValue(0);
            this.versionComboBox.setSelectedIndex(3);
            this.mibSetComboBox.setSelectedItem(null);
            this.community.setOctetString(new OctetString());
            this.contextName.setOctetString(new OctetString());
            this.contextEngineID.setOctetString(new OctetString());
            this.securityEngineID.setOctetString(new OctetString());
            this.resetDirectUserFields();
        }
        this.target = target;
        this.updating = false;
        this.targetNameField.requestFocusInWindow();
    }

    public void setEngineIdFieldContent(OctetString engineId) {
        this.securityEngineID.setOctetString(engineId);
    }

    private void resetDirectUserFields() {
        this.authKey.setOctetString(new OctetString());
        this.privKey.setOctetString(new OctetString());
        this.securityName.setOctetString(new OctetString());
        this.authProtocol.setSelectedItem(null);
        this.privProtocol.setSelectedItem(null);
    }

    private void createUIComponents() {
    }

    public void beginTargetNameEditing() {
        this.targetNameField.requestFocusInWindow();
        this.targetNameField.selectAll();
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.timeoutLabel = new JLabel();
        this.timeoutLabel.setText("Timeout:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.timeoutLabel, gbc);
        this.versionSpecificFieldPanel = new JPanel();
        this.versionSpecificFieldPanel.setLayout(new CardLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.panel.add((Component)this.versionSpecificFieldPanel, gbc);
        this.communityBasedPanel = new JPanel();
        this.communityBasedPanel.setLayout(new GridBagLayout());
        this.versionSpecificFieldPanel.add((Component)this.communityBasedPanel, "Community Based");
        this.community = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.communityBasedPanel.add((Component)this.community.$$$getRootComponent$$$(), gbc);
        this.communityLabel = new JLabel();
        this.communityLabel.setText("Community:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.communityBasedPanel.add((Component)this.communityLabel, gbc);
        this.v3Panel = new JPanel();
        this.v3Panel.setLayout(new GridBagLayout());
        this.versionSpecificFieldPanel.add((Component)this.v3Panel, "SNMPv3");
        this.contextNameLabel = new JLabel();
        this.contextNameLabel.setText("Context:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.contextNameLabel, gbc);
        this.contextName = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.contextName.$$$getRootComponent$$$(), gbc);
        this.securityEngineIdLabel = new JButton();
        this.securityEngineIdLabel.setActionCommand(ACTION_DISCOVER_ENGINE_ID);
        this.securityEngineIdLabel.setHorizontalAlignment(10);
        this.securityEngineIdLabel.setText("Engine ID:");
        this.securityEngineIdLabel.setToolTipText("Discover engine ID from target address. Use <Shift> to set own engine ID for traps");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.securityEngineIdLabel, gbc);
        this.securityEngineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.securityEngineID.$$$getRootComponent$$$(), gbc);
        this.contextEngineIdLabel = new JLabel();
        this.contextEngineIdLabel.setText("Context Engine ID:");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.contextEngineIdLabel, gbc);
        this.contextEngineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.v3Panel.add((Component)this.contextEngineID.$$$getRootComponent$$$(), gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 90;
        this.v3Panel.add((Component)spacer1, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.ipadx = 40;
        this.v3Panel.add((Component)spacer2, gbc);
        this.timeout = new JSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.timeout, gbc);
        this.retries = new JSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.retries, gbc);
        this.versionLabel = new JLabel();
        this.versionLabel.setText("Version:");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.versionLabel, gbc);
        this.versionComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("SNMPv1");
        defaultComboBoxModel1.addElement("SNMPv2c");
        defaultComboBoxModel1.addElement("SNMPv3 /direct");
        defaultComboBoxModel1.addElement("SNMPv3 /USM");
        defaultComboBoxModel1.addElement("SNMPv3 /(D)TLS");
        this.versionComboBox.setModel(defaultComboBoxModel1);
        this.versionComboBox.setToolTipText("Select target SNMP version and configuration type. Editable only for non-TLS based transports!");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.versionComboBox, gbc);
        this.transportLabel = new JLabel();
        this.transportLabel.setText("Transport:");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.transportLabel, gbc);
        this.transportComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add(this.transportComboBox, gbc);
        this.addressLabel = new JButton();
        this.addressLabel.setActionCommand(ACTION_TEST_CONNECTIVITY);
        this.addressLabel.setHorizontalAlignment(11);
        this.addressLabel.setText("Address:");
        this.addressLabel.setToolTipText("Test connectivity");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.addressLabel, gbc);
        this.addressTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.addressTextField, gbc);
        this.targetNameLabel = new JLabel();
        this.targetNameLabel.setText("Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.targetNameLabel, gbc);
        this.targetNameField = new JTextField();
        this.targetNameField.setEditable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.targetNameField, gbc);
        this.mibSetLabel = new JLabel();
        this.mibSetLabel.setText("MIB Set:");
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.mibSetLabel, gbc);
        this.mibSetComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add(this.mibSetComboBox, gbc);
        this.retriesLabel = new JLabel();
        this.retriesLabel.setText("Retries:");
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.retriesLabel, gbc);
        this.securityModelSpecificPanel = new JPanel();
        this.securityModelSpecificPanel.setLayout(new CardLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.panel.add((Component)this.securityModelSpecificPanel, gbc);
        this.localizedUserPanel = new JPanel();
        this.localizedUserPanel.setLayout(new GridBagLayout());
        this.securityModelSpecificPanel.add((Component)this.localizedUserPanel, "Localized User");
        this.securityName = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.securityName.$$$getRootComponent$$$(), gbc);
        JPanel spacer3 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.localizedUserPanel.add((Component)spacer3, gbc);
        JPanel spacer4 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.localizedUserPanel.add((Component)spacer4, gbc);
        this.securityNameLabel = new JLabel();
        this.securityNameLabel.setHorizontalTextPosition(2);
        this.securityNameLabel.setText("Security Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.securityNameLabel, gbc);
        this.authProtocolLabel = new JLabel();
        this.authProtocolLabel.setText("Authentication Protocol:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.authProtocolLabel, gbc);
        this.privProtocolLabel = new JLabel();
        this.privProtocolLabel.setText("Privacy Protocol:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.privProtocolLabel, gbc);
        this.authProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add(this.authProtocol, gbc);
        this.authKeyLabel = new JButton();
        this.authKeyLabel.setHorizontalAlignment(10);
        this.authKeyLabel.setHorizontalTextPosition(0);
        this.authKeyLabel.setText("Authentication Key:");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.authKeyLabel, gbc);
        this.privKeyLabel = new JButton();
        this.privKeyLabel.setHorizontalAlignment(10);
        this.privKeyLabel.setHorizontalTextPosition(11);
        this.privKeyLabel.setText("Privacy Key:");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.privKeyLabel, gbc);
        this.authKey = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.authKey.$$$getRootComponent$$$(), gbc);
        this.privKey = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.privKey.$$$getRootComponent$$$(), gbc);
        this.privProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add(this.privProtocol, gbc);
        this.showSecrets = new JCheckBox();
        this.showSecrets.setText("Show Keys");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.localizedUserPanel.add((Component)this.showSecrets, gbc);
        this.tlsPanel = new JPanel();
        this.tlsPanel.setLayout(new GridBagLayout());
        this.securityModelSpecificPanel.add((Component)this.tlsPanel, "(D)TLS");
        this.usmPanel = new JPanel();
        this.usmPanel.setLayout(new GridBagLayout());
        this.securityModelSpecificPanel.add((Component)this.usmPanel, "USM User");
        this.userLabel = new JLabel();
        this.userLabel.setText("USM User:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 5, 5, 5);
        this.usmPanel.add((Component)this.userLabel, gbc);
        this.userComboBox = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.usmPanel.add(this.userComboBox, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 10;
        gbc.fill = 2;
        gbc.ipady = 3;
        gbc.insets = new Insets(1, 0, 1, 0);
        this.panel.add((Component)separator1, gbc);
        JSeparator separator2 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 10;
        gbc.fill = 2;
        gbc.ipady = 3;
        gbc.insets = new Insets(1, 0, 1, 0);
        this.panel.add((Component)separator2, gbc);
        this.versionLabel.setLabelFor(this.versionComboBox);
        this.transportLabel.setLabelFor(this.transportComboBox);
        this.targetNameLabel.setLabelFor(this.targetNameField);
        this.mibSetLabel.setLabelFor(this.mibSetComboBox);
        this.authProtocolLabel.setLabelFor(this.authProtocol);
        this.privProtocolLabel.setLabelFor(this.privProtocol);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private void showSecrets_itemStateChanged(ItemEvent e2) {
        this.setShowSecrets(e2.getStateChange() == 1);
    }

    private void setShowSecrets(boolean showSecrets) {
        this.authKey.setHidePassword(!showSecrets);
        this.privKey.setHidePassword(!showSecrets);
    }

    private class UpdateInputVerifier
    extends InputVerifier {
        private UpdateInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean ok = true;
            if (!TargetEditorPanel.this.updating && TargetEditorPanel.this.target != null && TargetEditorPanel.this.updateListener != null) {
                try {
                    GenTarget target = TargetEditorPanel.this.getTarget();
                    if (target == null || !TargetEditorPanel.this.updateListener.uiObjectVerification(TargetEditorPanel.this, target, TargetEditorPanel.this.target)) {
                        ok = false;
                    } else {
                        TargetEditorPanel.this.updateTarget();
                        TargetEditorPanel.this.updateListener.uiObjectUpdated(TargetEditorPanel.this, TargetEditorPanel.this.target);
                    }
                }
                catch (IllegalArgumentException iax) {
                    ok = false;
                }
            }
            if (ok) {
                if (input.getBackground() == Color.pink) {
                    input.setBackground(Color.white);
                }
            } else if (input.getBackground() == Color.white) {
                input.setBackground(Color.pink);
            }
            return ok;
        }
    }

    class ShowSecretsAdapter
    implements ItemListener {
        private TargetEditorPanel adaptee;

        ShowSecretsAdapter(TargetEditorPanel adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            this.adaptee.showSecrets_itemStateChanged(e2);
        }
    }
}

