/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.common.table.TableUtils;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCTableModelDataSource;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiType;
import com.snmp4j.smibridge.SmiManagerBridge;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.snmp4j.model.mapper.VariableBindingMapper;
import org.snmp4j.model.snmp.proxy.ChangeSet;
import org.snmp4j.model.snmp.proxy.SnmpCommitListener;
import org.snmp4j.model.snmp.proxy.SnmpProxyColumn;
import org.snmp4j.model.snmp.proxy.SnmpProxyObject;
import org.snmp4j.model.snmp.proxy.SnmpTable;
import org.snmp4j.model.snmp.proxy.impl.SnmpColumn;
import org.snmp4j.model.snmp.proxy.impl.SnmpProxyObjectHelper;
import org.snmp4j.model.snmp.proxy.impl.SnmpTableImpl;
import org.snmp4j.model.snmp.proxy.impl.SnmpValueChange;
import org.snmp4j.model.snmp.proxy.impl.SnmpValuesChangeSet;
import org.snmp4j.model.snmp.spi.SnmpCell;
import org.snmp4j.model.snmp.spi.SnmpCellUpdateListener;
import org.snmp4j.model.snmp.spi.SnmpErrorStatus;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpDataEditor
implements SnmpCommitListener,
SnmpCellUpdateListener {
    private JButton buttonCommit;
    private JButton buttonUndo;
    private JButton buttonReload;
    private JCTable table;
    private JPanel panel;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JButton buttonRedo;
    private SnmpProxyObject snmpProxyObject;
    private final VariableBindingMapper variableBindingMapper;
    private SmiManagerBridge smiManager;
    private Stack<SnmpValuesChangeSet> redoStack = new Stack();
    private boolean isTable;
    private boolean editable;
    private JCCellStyle normalStyle;
    private JCCellStyle indexStyle;
    private JCCellStyle failureStyle;

    public SnmpDataEditor(final VariableBindingMapper variableBindingMapper) {
        this.$$$setupUI$$$();
        this.variableBindingMapper = variableBindingMapper;
        this.table.setSelectionPolicy(3);
        this.normalStyle = new JCCellStyle(this.table.getDefaultCellStyle());
        this.indexStyle = new JCCellStyle(this.normalStyle);
        this.indexStyle.setEditable(false);
        this.indexStyle.setBackground(Color.lightGray);
        this.failureStyle = new JCCellStyle(this.normalStyle);
        this.failureStyle.setBackground(Color.red);
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.snmpProxyObject instanceof SnmpTableImpl) {
                    SnmpTableImpl snmpTable = (SnmpTableImpl)SnmpDataEditor.this.snmpProxyObject;
                    List<VariableBinding> indexVbs = SnmpTableImpl.getIndexVariableTemplates(snmpTable.getIndexColumns());
                    String indexString = SnmpDataEditor.this.smiManager.getIndexStringFromVariables(snmpTable.getOID(), indexVbs);
                    while (indexString != null) {
                        indexString = JOptionPane.showInputDialog(SnmpDataEditor.this.getPanel(), "Row index value:", indexString);
                        if (indexString == null) continue;
                        try {
                            SnmpColumn firstColumn = (SnmpColumn)snmpTable.getColumns().get(0);
                            OID indexOID = new OID(firstColumn.getOID() + "." + indexString);
                            indexOID = new OID(indexOID.getValue(), firstColumn.getOID().size(), indexOID.size() - firstColumn.getOID().size());
                            List<VariableBinding> indexVBs = snmpTable.getIndexVariableBindings(indexOID);
                            ArrayList<VariableBinding> initialVBs = new ArrayList<VariableBinding>();
                            for (SnmpColumn snmpColumn : snmpTable.getColumns()) {
                                OID cellOID = new OID(snmpColumn.getOID().getValue(), indexOID.getValue());
                                SmiObjectType objectType = (SmiObjectType)SnmpDataEditor.this.smiManager.findSmiObject(snmpColumn.getOID());
                                VariableBinding vb = new VariableBinding(cellOID, objectType.createNewVariable());
                                initialVBs.add(vb);
                            }
                            Object newRow = snmpTable.getRowFactory().createProxyRow(indexOID, SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, indexVBs, snmpTable.getIndexColumns()), SnmpProxyObjectHelper.mapVBsToObjects(variableBindingMapper, initialVBs, snmpTable.getColumns()));
                            if (snmpTable.getRowNumber(newRow.getIndex()) < 0 || snmpTable.isEmpty()) {
                                snmpTable.insertRow(newRow);
                                break;
                            }
                            JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "A row with index '" + newRow.getIndex().toDottedString() + "' already exists.", "Duplicate Row Index", 2);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "The given row index could not be parsed. Please try again.", "Row Index Error", 0);
                        }
                    }
                } else {
                    SnmpDataEditor.this.table.setDataSource(new JCTableModelDataSource(new DefaultTableModel()));
                }
            }
        });
        this.buttonCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.commitChanges();
            }
        });
        this.buttonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.undo();
            }
        });
        this.buttonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                SnmpDataEditor.this.redo();
            }
        });
        this.buttonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.snmpProxyObject instanceof SnmpTable) {
                    SnmpTable snmpTable = (SnmpTable)SnmpDataEditor.this.snmpProxyObject;
                    boolean cancelReload = false;
                    if (snmpTable.getCommitter().getNumberOfPendingChanges() > 0 && JOptionPane.showConfirmDialog(SnmpDataEditor.this.getPanel(), "There are uncommitted changes. Do you want to commit them before reloading?", "Commit Changes?", 0) == 0) {
                        boolean bl = cancelReload = !SnmpDataEditor.this.commitChanges();
                    }
                    if (!cancelReload) {
                        SnmpDataEditor.this.reload(SnmpDataEditor.this.snmpProxyObject, variableBindingMapper);
                    } else {
                        JOptionPane.showMessageDialog(SnmpDataEditor.this.getPanel(), "Reload canceled because commit failed for at least one value", "Reload Canceled", 1);
                    }
                }
            }
        });
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (SnmpDataEditor.this.isTable) {
                    int[] rows = TableUtils.getSelectedRows(SnmpDataEditor.this.table);
                    boolean yesToAll = false;
                    for (int i2 = rows.length - 1; i2 >= 0; --i2) {
                        SnmpTable snmpTable = (SnmpTable)SnmpDataEditor.this.snmpProxyObject;
                        OID rowIndex = snmpTable.getRowIndex(rows[i2]);
                        int choice = 0;
                        if (!yesToAll) {
                            choice = JOptionPane.showOptionDialog(SnmpDataEditor.this.getPanel(), "Do you really want to remove row " + SnmpDataEditor.this.getIndexString(snmpTable.getOID(), rowIndex) + "? ", "Confirm Row Delete", 1, 3, null, new String[]{"Yes", "Yes to All", "No"}, "No");
                        }
                        switch (choice) {
                            case 1: {
                                yesToAll = true;
                            }
                            case 0: {
                                SnmpDataEditor.this.removeRow(snmpTable.getOID(), rowIndex);
                            }
                        }
                    }
                    SnmpDataEditor.this.commitChanges();
                }
                SnmpDataEditor.this.reload(SnmpDataEditor.this.snmpProxyObject, variableBindingMapper);
            }
        });
        this.table.setRowLabelDisplay(false);
        this.enableTabularButtons(false);
        this.updateUndoButtons();
    }

    public SmiManagerBridge getSmiManager() {
        return this.smiManager;
    }

    public void setSmiManager(SmiManagerBridge smiManager) {
        this.smiManager = smiManager;
    }

    public void removeRow(OID table, OID rowIndex) {
    }

    private String getIndexString(OID tableEntry, OID index) {
        StringBuilder buf = new StringBuilder();
        if (this.smiManager != null) {
            Variable[] variables = this.smiManager.getIndexVariables(tableEntry, index);
            for (int i2 = 0; i2 < variables.length; ++i2) {
                buf.append(variables[i2].toString());
                if (i2 + 1 >= variables.length) continue;
                buf.append(";");
            }
        }
        return buf.toString();
    }

    public void reload(SnmpProxyObject snmpProxy, VariableBindingMapper variableMapper) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            int i2;
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            int indexOffset = snmpTable.getIndexColumns().size();
            for (i2 = 0; i2 < indexOffset; ++i2) {
                this.table.setCellStyle(-997, i2, this.indexStyle);
            }
            for (i2 = 0; i2 < snmpTable.getColumnCount(); ++i2) {
                this.table.setCellStyle(-997, indexOffset + i2, this.normalStyle);
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean commitChanges() {
        boolean success = false;
        if (this.snmpProxyObject instanceof SnmpTable) {
            EditorCommitListener commitListener = new EditorCommitListener();
            ((SnmpTable)this.snmpProxyObject).getCommitter().commitChanges(commitListener);
            success = commitListener.isSuccess();
            ((SnmpTable)this.snmpProxyObject).getCommitter().removeAllChanges(this.snmpProxyObject);
        }
        this.updateUndoButtons();
        return success;
    }

    @Override
    public void commitSuccess(List<SnmpValuesChangeSet> valuesChangeSets) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            for (SnmpValuesChangeSet changeSet : valuesChangeSets) {
                for (SnmpValueChange change : changeSet.getChanges()) {
                    SnmpCell cell = snmpTable.getCell(change.getOid());
                    this.table.setCellStyle(cell.getRow(), cell.getColumn(), this.normalStyle);
                }
            }
        }
    }

    @Override
    public void commitFailure(List<SnmpValuesChangeSet> valuesChangeSets, SnmpErrorStatus errorStatus, int i2) {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            for (SnmpValuesChangeSet changeSet : valuesChangeSets) {
                for (SnmpValueChange change : changeSet.getChanges()) {
                    if (change.getChangeStatus() != ChangeSet.ChangeStatus.FAILURE) continue;
                    SnmpCell cell = snmpTable.getCell(change.getOid());
                    this.table.setCellStyle(cell.getRow(), cell.getColumn(), this.failureStyle);
                }
            }
        }
    }

    @Override
    public OctetString getContext() {
        return new OctetString();
    }

    @Override
    public void cellUpdated(int row, int col, SnmpValueChange change) {
        this.table.setCellStyle(row, col, this.normalStyle);
    }

    @Override
    public void cellUpdateFailed(int row, int col, SnmpValueChange change) {
        this.table.setCellStyle(row, col, this.failureStyle);
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.table = new JCTable();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.panel.add((Component)this.table, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        this.panel.add((Component)spacer1, gbc);
        this.buttonCommit = new JButton();
        this.buttonCommit.setText("Save");
        this.buttonCommit.setToolTipText("Commit changes to the agent and - if data synchronization is enabled - also to Properties");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonCommit, gbc);
        this.buttonUndo = new JButton();
        this.buttonUndo.setActionCommand("Undo");
        this.buttonUndo.setText("Undo");
        this.buttonUndo.setToolTipText("Undo the latest change of the simulation agent data ");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonUndo, gbc);
        this.buttonReload = new JButton();
        this.buttonReload.setText("Reload");
        this.buttonReload.setToolTipText("Reload data from the agent");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonReload, gbc);
        this.buttonAdd = new JButton();
        this.buttonAdd.setText("Add Row");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonAdd, gbc);
        this.buttonRemove = new JButton();
        this.buttonRemove.setText("Remove Row");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonRemove, gbc);
        this.buttonRedo = new JButton();
        this.buttonRedo.setText("Redo");
        this.buttonRedo.setToolTipText("Redo an undone change");
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.buttonRedo, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    public void undo() {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            SnmpValuesChangeSet changeSet = snmpTable.getCommitter().removeLastChangeSet(snmpTable);
            if (changeSet != null && snmpTable.undoChange(changeSet)) {
                this.redoStack.add(changeSet);
                this.table.updateUI();
            }
            this.updateUndoButtons();
        }
    }

    public void redo() {
        if (this.snmpProxyObject instanceof SnmpTable && !this.redoStack.empty()) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            SnmpValuesChangeSet changeSet = this.redoStack.pop();
            if (changeSet != null && !snmpTable.doChange(changeSet)) {
                this.redoStack.add(changeSet);
            }
            this.updateUndoButtons();
        }
    }

    private void enableTabularButtons(boolean isTable) {
        boolean enabled = isTable && this.editable;
        this.buttonAdd.setEnabled(enabled);
        this.buttonReload.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonCommit.setEnabled(this.editable);
    }

    public SnmpProxyObject getSnmpProxyObject() {
        return this.snmpProxyObject;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public void setSnmpProxyObject(SnmpProxyObject snmpProxyObject) {
        this.redoStack.clear();
        this.snmpProxyObject = snmpProxyObject;
        if (snmpProxyObject instanceof SnmpTable && this.smiManager != null) {
            SnmpTable snmpTable = (SnmpTable)snmpProxyObject;
            snmpTable.setCellUpdateListener(this);
            JCTableModelDataSource tableModelDataSource = new JCTableModelDataSource(snmpTable);
            this.table.setDataSource(tableModelDataSource);
            ((SnmpTable)snmpProxyObject).addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e2) {
                    SnmpDataEditor.this.updateUndoButtons();
                }
            });
            SmiObject smiObject = this.smiManager.findSmiObject(snmpProxyObject.getOID());
            this.isTable = smiObject instanceof SmiObjectType && smiObject.getType().equals((Object)SmiType.OBJECT_TYPE_TABLE_ENTRY);
            this.enableButtons(true);
            this.enableTabularButtons(this.isTable);
            if (this.isTable) {
                int width;
                int c2 = 0;
                for (SnmpProxyColumn column : snmpTable.getIndexColumns()) {
                    width = Math.min(Math.max(column.getMaxWidth(), snmpTable.getColumnName(c2).length()), 20);
                    this.table.setPixelWidth(c2, -999);
                    this.table.setCharWidth(c2, width);
                    this.table.setCellStyle(-997, c2, this.indexStyle);
                    ++c2;
                }
                for (SnmpProxyColumn column : snmpTable.getColumns()) {
                    width = Math.min(Math.max(column.getMaxWidth(), snmpTable.getColumnName(c2).length()), 25);
                    this.table.setPixelWidth(c2, -999);
                    this.table.setCharWidth(c2, width);
                    this.table.setCellStyle(-997, c2, this.normalStyle);
                    ++c2;
                }
            } else {
                this.table.setPixelWidth(0, this.panel.getWidth() - 15);
                this.table.setCellStyle(0, 0, this.normalStyle);
            }
            tableModelDataSource.fireDataReset();
        } else {
            JCTableModelDataSource tableModelDataSource = new JCTableModelDataSource(new DefaultTableModel());
            this.table.setDataSource(tableModelDataSource);
            this.enableTabularButtons(false);
            tableModelDataSource.fireDataReset();
            this.enableButtons(false);
        }
    }

    private void enableButtons(boolean enabled) {
        this.buttonReload.setEnabled(enabled);
        this.buttonUndo.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonRedo.setEnabled(enabled);
        this.buttonCommit.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
    }

    private void updateUndoButtons() {
        if (this.snmpProxyObject instanceof SnmpTable) {
            SnmpTable snmpTable = (SnmpTable)this.snmpProxyObject;
            boolean pendingChanges = snmpTable.getCommitter().getNumberOfPendingChanges() > 0;
            this.buttonUndo.setEnabled(pendingChanges);
            this.buttonRedo.setEnabled(!this.redoStack.empty());
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void createUIComponents() {
    }

    private class EditorCommitListener
    implements SnmpCommitListener {
        private boolean success = true;

        private EditorCommitListener() {
        }

        @Override
        public void commitSuccess(List<SnmpValuesChangeSet> committedChanges) {
            SnmpDataEditor.this.commitSuccess(committedChanges);
        }

        @Override
        public void commitFailure(List<SnmpValuesChangeSet> failedChanges, SnmpErrorStatus errorStatus, int errorIndex) {
            this.success = false;
            SnmpDataEditor.this.commitFailure(failedChanges, errorStatus, errorIndex);
        }

        @Override
        public OctetString getContext() {
            return new OctetString();
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

