/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.snmp.GenTarget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.TreeSet;
import java.util.function.BiFunction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;

public class OctetStringLookup {
    private JList<DisplayOctetString> list;
    private JComboBox<String> octetStringMode;
    private JScrollPane scrollPane;
    private JPanel panel;
    private final DefaultListModel<DisplayOctetString> listModel = new DefaultListModel();
    private OctetStringField.EditMode mode = OctetStringField.EditMode.TXT;

    public OctetStringLookup(Snmp snmp, GenTarget target, OID[] columns, final BiFunction<OID, VariableBinding[], OctetString> mapping, final int maxEntries) {
        this.$$$setupUI$$$();
        this.list.setModel(this.listModel);
        TableUtils tableUtils = new TableUtils(snmp, new DefaultPDUFactory(-91, target.getContextEngineID(), target.getContext()));
        tableUtils.getTable(target.getTarget(), columns, new TableListener(){
            private TreeSet<OctetString> values = new TreeSet();

            @Override
            public boolean next(TableEvent event) {
                if (!event.isError()) {
                    VariableBinding[] cols = event.getColumns();
                    OctetString octetString = (OctetString)mapping.apply(event.getIndex(), cols);
                    if (octetString != null) {
                        this.values.add(octetString);
                    }
                }
                return this.values.size() < maxEntries;
            }

            @Override
            public void finished(TableEvent event) {
                this.next(event);
                OctetStringLookup.this.list.setValueIsAdjusting(true);
                for (OctetString value : this.values) {
                    OctetStringLookup.this.addListItem(value);
                }
                SwingUtilities.invokeLater(() -> {
                    OctetStringLookup.this.list.setValueIsAdjusting(false);
                    OctetStringLookup.this.list.updateUI();
                });
            }

            @Override
            public boolean isFinished() {
                return false;
            }
        }, null, null, null);
        this.octetStringMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    OctetStringLookup.this.mode = OctetStringField.EditMode.valueOf(e2.getItem().toString());
                    OctetStringLookup.this.list.updateUI();
                }
            }
        });
    }

    public OctetStringField.EditMode getMode() {
        return this.mode;
    }

    public void setMode(OctetStringField.EditMode mode) {
        this.mode = mode;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.scrollPane.addKeyListener(keyListener);
    }

    public void setListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.removeListSelectionListener(listSelectionListener);
        this.list.addListSelectionListener(listSelectionListener);
    }

    public OctetString getSelectedItem() {
        OctetString displayOctetString = this.list.getSelectedValue();
        if (displayOctetString != null) {
            return new OctetString(displayOctetString);
        }
        return null;
    }

    public void addListItem(OctetString item) {
        DisplayOctetString displayOctetString = new DisplayOctetString(item);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.listModel.addElement(displayOctetString));
        } else {
            this.listModel.addElement(displayOctetString);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void createUIComponents() {
        this.panel = new JPanel();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.scrollPane, gbc);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.scrollPane.setViewportView(this.list);
        this.octetStringMode = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel1 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel1.addElement("TXT");
        defaultComboBoxModel1.addElement("HEX");
        defaultComboBoxModel1.addElement("OCT");
        defaultComboBoxModel1.addElement("BIN");
        defaultComboBoxModel1.addElement("DEC");
        this.octetStringMode.setModel(defaultComboBoxModel1);
        this.octetStringMode.setToolTipText("Select the display encoding of the OCTET STRINGs in the list");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add(this.octetStringMode, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    class DisplayOctetString
    extends OctetString {
        private static final long serialVersionUID = 1637472998126381802L;

        public DisplayOctetString(OctetString other) {
            super(other);
        }

        @Override
        public String toString() {
            if (OctetStringLookup.this.mode == OctetStringField.EditMode.TXT) {
                if (!this.isPrintable()) {
                    return this.toString(OctetStringField.EditMode.HEX.getSeparator(), OctetStringField.EditMode.HEX.getRadix());
                }
                return new String(this.getValue());
            }
            return this.toString(OctetStringLookup.this.mode.getSeparator(), OctetStringLookup.this.mode.getRadix());
        }
    }
}

