/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.snmp.UsmUserEditorPanel;
import com.agentpp.commons.ui.OctetStringField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.snmp4j.Snmp;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class KeyLocalizerPanel
implements ActionListener {
    public static final String ACTION_LOCALIZE = "Localize";
    public static final String ACTION_SHOW_SECRETS = "Show Secrets";
    private JLabel authProtocolLabel;
    private JLabel privProtocolLabel;
    private OctetStringField passphrase;
    private JLabel passphraseLabel;
    private JComboBox<String> privProtocol;
    private JComboBox<String> authProtocol;
    private JButton localiseButton;
    private JLabel localizedKeyLabel;
    private OctetStringField localizedKey;
    private JLabel engineIdLabel;
    private OctetStringField engineID;
    private JPanel panel;
    private JLabel hintLabel;
    private JCheckBox showSecrets;
    private JCheckBox advancedMode;
    private Snmp session;

    public KeyLocalizerPanel(Snmp snmpSession) {
        this();
        this.session = snmpSession;
    }

    private void createUIComponents() {
        this.panel = new JPanel();
    }

    public KeyLocalizerPanel() {
        DefaultComboBoxModel<String> authProtocolModel = new DefaultComboBoxModel<String>();
        this.$$$setupUI$$$();
        authProtocolModel.addElement("");
        authProtocolModel.addElement("MD5");
        authProtocolModel.addElement("SHA-1");
        authProtocolModel.addElement("SHA224");
        authProtocolModel.addElement("SHA256");
        authProtocolModel.addElement("SHA384");
        authProtocolModel.addElement("SHA512");
        this.authProtocol.setModel(authProtocolModel);
        DefaultComboBoxModel<String> privProtocolModel = new DefaultComboBoxModel<String>();
        privProtocolModel.addElement("");
        privProtocolModel.addElement("DES");
        privProtocolModel.addElement("3DES");
        privProtocolModel.addElement("AES128");
        privProtocolModel.addElement("AES192");
        privProtocolModel.addElement("AES256");
        privProtocolModel.addElement("AES192-KeyExt3DES");
        privProtocolModel.addElement("AES256-KeyExt3DES");
        this.privProtocol.setModel(privProtocolModel);
        this.localiseButton.addActionListener(this);
        this.localiseButton.setActionCommand(ACTION_LOCALIZE);
        this.showSecrets.addItemListener(new ShowSecretsAdapter(this));
        this.localizedKey.setEditMode(OctetStringField.EditMode.HEX);
        this.passphrase.setHidePassword(true);
        this.localizedKey.setHidePassword(true);
        this.setAdvancedMode(false);
        this.advancedMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    KeyLocalizerPanel.this.setAdvancedMode(true);
                } else if (e2.getStateChange() == 2) {
                    KeyLocalizerPanel.this.setAdvancedMode(false);
                }
            }
        });
    }

    private void setAdvancedMode(boolean advancedMode) {
        this.authProtocol.setEnabled(advancedMode);
        this.privProtocol.setEnabled(advancedMode);
        this.engineID.setEnabled(advancedMode);
        this.localizedKey.setEnabled(advancedMode);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void setEngineId(OctetString engineId) {
        if (engineId == null || engineId.length() == 0) {
            this.setAdvancedMode(true);
        }
        this.engineID.setOctetString(engineId);
    }

    public void setAuthProtocol(OID authProtocol) {
        this.authProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(authProtocol));
    }

    public void setPrivProtocol(OID privProtocol) {
        this.privProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(privProtocol));
    }

    public void setPassphrase(OctetString passphrase) {
        this.passphrase.setOctetString(passphrase);
    }

    public OctetString getLocalizedKey() {
        return this.localizedKey.getOctetString();
    }

    public void setLocalizedKey(OctetString localizedKey) {
        this.localizedKey.setOctetString(localizedKey);
    }

    public Snmp getSession() {
        return this.session;
    }

    public void setSession(Snmp session) {
        this.session = session;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals(ACTION_LOCALIZE)) {
            this.localizeKey();
        }
    }

    public void localizeKey() {
        OctetString key = KeyLocalizerPanel.localizeKey(this.session, this.panel, this.engineID.getOctetString(), UsmUserEditorPanel.getSecurityProtocol((String)this.authProtocol.getSelectedItem()), UsmUserEditorPanel.getSecurityProtocol((String)this.privProtocol.getSelectedItem()), this.passphrase.getOctetString());
        if (key != null) {
            this.localizedKey.setOctetString(key);
        }
    }

    public void checkLocalization() {
        OctetString key = this.localizedKey.getOctetString();
        if (key == null || key.length() == 0) {
            this.localizeKey();
        }
    }

    public static OctetString localizeKey(Snmp session, JComponent parent, OctetString engineID, OID authenticationProtocol, OID privacyProtocol, OctetString passphrase) {
        OctetString localizedKey = null;
        AuthenticationProtocol authProtocol = session.getUSM().getSecurityProtocols().getAuthenticationProtocol(authenticationProtocol);
        PrivacyProtocol privProtocol = session.getUSM().getSecurityProtocols().getPrivacyProtocol(privacyProtocol);
        if (authenticationProtocol == null || authProtocol == null) {
            JOptionPane.showMessageDialog(parent, "Please select a authentication protocol before localising any keys", "No Supported Authentication Protocol", 0);
            return null;
        }
        if (privacyProtocol == null && (passphrase == null || passphrase.length() == 0)) {
            JOptionPane.showMessageDialog(parent, "Please enter a authentication passphrase in the authentication key field before trying to localise the passphrase!", "No Authentication Passphrase", 0);
            return null;
        }
        if (privProtocol == null && privacyProtocol != null) {
            JOptionPane.showMessageDialog(parent, "Please select a supported privacy protocol before localising a privacy passphrase", "Privacy Protocol Not Supported", 0);
            return null;
        }
        if (privProtocol != null && (passphrase == null || passphrase.length() < 8)) {
            JOptionPane.showMessageDialog(parent, "Please enter a passphrase with at least 8 characters!", "No Passphrase", 0);
            return null;
        }
        if (!passphrase.isPrintable() && JOptionPane.showConfirmDialog(parent, "The passphrase seems to be already a key (i.e. it is not a printable string)!\nDo you want to localise it anyway?", "No Passphrase Given?", 0, 2) == 1) {
            return null;
        }
        if (engineID == null || engineID.length() == 0) {
            JOptionPane.showMessageDialog(parent, "Please enter the engine ID of the target SNMP engine for the localization!", "Engine ID Missing", 0);
            return null;
        }
        byte[] k2 = KeyLocalizerPanel.localizeKey(session, engineID.getValue(), authenticationProtocol, privacyProtocol, passphrase);
        if (k2 != null) {
            localizedKey = new OctetString(k2);
        }
        return localizedKey;
    }

    private static byte[] localizeKey(Snmp session, byte[] engineID, OID authProtocol, OID privProtocol, OctetString passphrase) {
        if (privProtocol == null) {
            return session.getUSM().getSecurityProtocols().passwordToKey(authProtocol, passphrase, engineID);
        }
        return session.getUSM().getSecurityProtocols().passwordToKey(privProtocol, authProtocol, passphrase, engineID);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new GridBagLayout());
        this.authProtocolLabel = new JLabel();
        this.authProtocolLabel.setText("Authentication Protocol:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authProtocolLabel, gbc);
        this.privProtocolLabel = new JLabel();
        this.privProtocolLabel.setText("Privacy Protocol:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privProtocolLabel, gbc);
        this.passphraseLabel = new JLabel();
        this.passphraseLabel.setText("Passphrase:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.passphraseLabel, gbc);
        this.passphrase = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.passphrase.$$$getRootComponent$$$(), gbc);
        this.privProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add(this.privProtocol, gbc);
        this.authProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add(this.authProtocol, gbc);
        this.localiseButton = new JButton();
        this.localiseButton.setText(ACTION_LOCALIZE);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.localiseButton, gbc);
        this.localizedKeyLabel = new JLabel();
        this.localizedKeyLabel.setText("Localized Key:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.localizedKeyLabel, gbc);
        this.localizedKey = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.localizedKey.$$$getRootComponent$$$(), gbc);
        this.engineIdLabel = new JLabel();
        this.engineIdLabel.setText("Engine ID:");
        this.engineIdLabel.setVerticalAlignment(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.engineIdLabel, gbc);
        this.engineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.engineID.$$$getRootComponent$$$(), gbc);
        this.hintLabel = new JLabel();
        this.hintLabel.setText("Provide empty privacy protocol for authentication passphrase localization:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.hintLabel, gbc);
        this.showSecrets = new JCheckBox();
        this.showSecrets.setText(ACTION_SHOW_SECRETS);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.showSecrets, gbc);
        this.advancedMode = new JCheckBox();
        this.advancedMode.setText("Advanced Edit Mode");
        this.advancedMode.setToolTipText("Enable editing of fields taken over from target");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.advancedMode, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private void showSecrets_itemStateChanged(ItemEvent e2) {
        boolean showSecrets = e2.getStateChange() == 1;
        this.passphrase.setHidePassword(!showSecrets);
        this.localizedKey.setHidePassword(!showSecrets);
    }

    class ShowSecretsAdapter
    implements ItemListener {
        private KeyLocalizerPanel adaptee;

        ShowSecretsAdapter(KeyLocalizerPanel adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            this.adaptee.showSecrets_itemStateChanged(e2);
        }
    }
}

