/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.commons.snmp;

import com.agentpp.commons.snmp.OctetStringLookup;
import com.agentpp.commons.snmp.UsmUserEditorPanel;
import com.agentpp.commons.ui.OctetStringField;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.Operations;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.snmp4j.Snmp;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class DirectUsmUserEditor {
    private JButton securityNameLabel;
    private OctetStringField securityName;
    private JButton engineIdLabel;
    private OctetStringField engineID;
    private JLabel authProtocolLabel;
    private JComboBox authProtocol;
    private OctetStringField authPassphrase;
    private JLabel privacyLabel;
    private JComboBox privProtocol;
    private OctetStringField privPassphrase;
    private JPanel panel = new JPanel();
    private JLabel newTargetNameLabel;
    private JTextField newTargetName;
    private JCheckBox copyVacmGroup;
    private JLabel accessLabel;
    private Color textFieldBackground;
    private Snmp snmp;
    private GenTarget target;
    private Function<String, Boolean> targetNameValidator;
    private boolean noAuthAllowed;

    public DirectUsmUserEditor(final Snmp snmp, final GenTarget target, final Function<String, Boolean> targetNameValidator, boolean noAuthAllowed) {
        this.snmp = snmp;
        this.target = target;
        this.targetNameValidator = targetNameValidator;
        this.noAuthAllowed = noAuthAllowed;
        this.$$$setupUI$$$();
        this.engineID.setMinLength(5);
        this.engineID.setMaxLength(32);
        this.engineID.setEmptyAllowed(true);
        this.engineID.setEditMode(OctetStringField.EditMode.HEX);
        this.securityName.setMinLength(1);
        this.securityName.setMaxLength(32);
        DefaultComboBoxModel<String> authProtocolModel = new DefaultComboBoxModel<String>();
        if (noAuthAllowed) {
            authProtocolModel.addElement("");
        }
        authProtocolModel.addElement("MD5");
        authProtocolModel.addElement("SHA-1");
        authProtocolModel.addElement("SHA224");
        authProtocolModel.addElement("SHA256");
        authProtocolModel.addElement("SHA384");
        authProtocolModel.addElement("SHA512");
        this.authProtocol.setModel(authProtocolModel);
        DefaultComboBoxModel<String> privProtocolModel = new DefaultComboBoxModel<String>();
        privProtocolModel.addElement("");
        privProtocolModel.addElement("DES");
        privProtocolModel.addElement("3DES");
        privProtocolModel.addElement("AES128");
        privProtocolModel.addElement("AES192");
        privProtocolModel.addElement("AES256");
        privProtocolModel.addElement("AES192-KeyExt3DES");
        privProtocolModel.addElement("AES256-KeyExt3DES");
        this.privProtocol.setModel(privProtocolModel);
        this.textFieldBackground = this.newTargetName.getBackground();
        OID authProtocolOID = target.getUser().getUser().getAuthenticationProtocol();
        this.setAuthProtocol(authProtocolOID);
        OID privProtocolOID = target.getUser().getUser().getPrivacyProtocol();
        this.setPrivProtocol(privProtocolOID);
        this.securityName.setOctetString(target.getUser().getUser().getSecurityName());
        this.engineID.setOctetString(target.getEngineID());
        this.newTargetName.setText(target.getName());
        this.authPassphrase.setToolTipText("Enter here the authentication password/secret text (min. 8 characters)");
        this.privPassphrase.setToolTipText("Enter here the privacy password/secret text (min. 8 characters)");
        this.checkPassphraseStatus(this.authPassphrase, true);
        this.checkPassphraseStatus(this.privPassphrase, true);
        this.engineIdLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                OctetString lookupResult;
                OctetStringLookup octetStringLookup = new OctetStringLookup(snmp, target, new OID[]{Operations.usmUserSecurityName}, new BiFunction<OID, VariableBinding[], OctetString>(){

                    @Override
                    public OctetString apply(OID rowIndex, VariableBinding[] vbs) {
                        try {
                            return OctetString.fromIndex(rowIndex, 0, false);
                        }
                        catch (RuntimeException ex) {
                            return null;
                        }
                    }
                }, 100);
                octetStringLookup.setMode(OctetStringField.EditMode.HEX);
                if (JOptionPane.showConfirmDialog(DirectUsmUserEditor.this.getPanel(), octetStringLookup.getPanel(), "Select Engine ID", 2, -1, null) == 0 && (lookupResult = octetStringLookup.getSelectedItem()) != null) {
                    DirectUsmUserEditor.this.engineID.setOctetString(lookupResult);
                }
            }
        });
        this.securityNameLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                OctetString lookupResult;
                OctetStringLookup octetStringLookup = new OctetStringLookup(snmp, target, new OID[]{Operations.usmUserSecurityName}, new BiFunction<OID, VariableBinding[], OctetString>(){

                    @Override
                    public OctetString apply(OID rowIndex, VariableBinding[] vbs) {
                        try {
                            return (OctetString)vbs[0].getVariable();
                        }
                        catch (RuntimeException ex) {
                            return null;
                        }
                    }
                }, 100);
                if (JOptionPane.showConfirmDialog(DirectUsmUserEditor.this.getPanel(), octetStringLookup.getPanel(), "Select Security Name", 2, -1, null) == 0 && (lookupResult = octetStringLookup.getSelectedItem()) != null) {
                    DirectUsmUserEditor.this.securityName.setOctetString(lookupResult);
                }
            }
        });
        this.newTargetName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                super.keyReleased(e2);
                String newTarget = DirectUsmUserEditor.this.newTargetName.getText();
                DirectUsmUserEditor.this.checkNewTargetName(newTarget, target, targetNameValidator);
                DirectUsmUserEditor.this.statusChanged(DirectUsmUserEditor.this.isValid());
            }
        });
        this.authProtocol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                DirectUsmUserEditor.this.checkPassphraseStatus(e2, DirectUsmUserEditor.this.authPassphrase);
                DirectUsmUserEditor.this.statusChanged(DirectUsmUserEditor.this.isValid());
            }
        });
        this.privProtocol.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                DirectUsmUserEditor.this.checkPassphraseStatus(e2, DirectUsmUserEditor.this.privPassphrase);
                DirectUsmUserEditor.this.statusChanged(DirectUsmUserEditor.this.isValid());
            }
        });
        this.authPassphrase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                DirectUsmUserEditor.this.checkPassphraseStatus(DirectUsmUserEditor.this.authPassphrase, DirectUsmUserEditor.this.isAuthProtocolSelected());
                DirectUsmUserEditor.this.statusChanged(DirectUsmUserEditor.this.isValid());
            }
        });
        this.privPassphrase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                DirectUsmUserEditor.this.checkPassphraseStatus(DirectUsmUserEditor.this.privPassphrase, DirectUsmUserEditor.this.isPrivProtocolSelected());
                DirectUsmUserEditor.this.statusChanged(DirectUsmUserEditor.this.isValid());
            }
        });
    }

    private boolean checkNewTargetName(String newTarget, GenTarget target, Function<String, Boolean> targetNameValidator) {
        if (newTarget != null && newTarget.trim().length() != 0 && !newTarget.equals(target.getName()) && !targetNameValidator.apply(newTarget.trim()).booleanValue()) {
            this.newTargetName.setBackground(Color.pink);
            return false;
        }
        this.newTargetName.setBackground(this.textFieldBackground);
        return true;
    }

    private boolean checkPassphraseStatus(OctetStringField passphrase, boolean protocolActive) {
        if (!(protocolActive && passphrase.getOctetString().length() >= 8 || !protocolActive && passphrase.getOctetString().length() == 0)) {
            passphrase.getOctetStringTextField().setBackground(Color.pink);
            return false;
        }
        passphrase.getOctetStringTextField().setBackground(this.textFieldBackground);
        return true;
    }

    private void checkPassphraseStatus(ItemEvent e2, OctetStringField passphrase) {
        if (e2.getStateChange() == 1) {
            if (e2.getItem().toString().length() > 0 && passphrase.getOctetString().length() < 8) {
                passphrase.getOctetStringTextField().setBackground(Color.pink);
            } else {
                passphrase.getOctetStringTextField().setBackground(this.textFieldBackground);
            }
        }
    }

    public void statusChanged(boolean isValid) {
    }

    private boolean isAuthProtocolSelected() {
        return !this.noAuthAllowed || this.authProtocol.getSelectedIndex() > 0;
    }

    private boolean isPrivProtocolSelected() {
        return this.privProtocol.getSelectedIndex() > 0;
    }

    public boolean isValid() {
        return this.checkPassphraseStatus(this.authPassphrase, this.isAuthProtocolSelected()) && this.checkPassphraseStatus(this.privPassphrase, this.isPrivProtocolSelected()) && this.checkNewTargetName(this.newTargetName.getText(), this.target, this.targetNameValidator);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public OctetString getAuthPassphrase() {
        return this.authPassphrase.getOctetString();
    }

    public OctetString getPrivPassphrase() {
        return this.privPassphrase.getOctetString();
    }

    public void setSecurityName(OctetString securityName) {
        this.securityName.setOctetString(securityName);
    }

    public OID getAuthenticationProtocolOID() {
        return UsmUserEditorPanel.getSecurityProtocol((String)this.authProtocol.getSelectedItem());
    }

    public OID getPrivacyProtocolOID() {
        return UsmUserEditorPanel.getSecurityProtocol((String)this.privProtocol.getSelectedItem());
    }

    public void setAuthProtocol(OID authProtocol) {
        this.authProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(authProtocol));
    }

    public void setPrivProtocol(OID privProtocol) {
        this.privProtocol.setSelectedItem(UsmUserEditorPanel.getSecurityProtocolName(privProtocol));
    }

    public String getNewTargetName() {
        String result = this.newTargetName.getText();
        if (result != null && result.trim().length() == 0) {
            return null;
        }
        return result;
    }

    public boolean isCopyVacmGroup() {
        return this.copyVacmGroup.isSelected();
    }

    public OctetString getEngineID() {
        return this.engineID.getOctetString();
    }

    private void createUIComponents() {
    }

    public OctetString getSecurityName() {
        return this.securityName.getOctetString();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout(new GridBagLayout());
        this.securityNameLabel = new JButton();
        this.securityNameLabel.setText("Security Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 5, 10, 5);
        this.panel.add((Component)this.securityNameLabel, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this.panel.add((Component)spacer1, gbc);
        this.engineIdLabel = new JButton();
        this.engineIdLabel.setText("Engine ID:");
        this.engineIdLabel.setToolTipText("Engine ID (own=empty or remote)");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 5, 10, 5);
        this.panel.add((Component)this.engineIdLabel, gbc);
        this.engineID = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.engineID.$$$getRootComponent$$$(), gbc);
        this.authProtocolLabel = new JLabel();
        this.authProtocolLabel.setText("Authentication:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.authProtocolLabel, gbc);
        this.authProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.panel.add((Component)this.authProtocol, gbc);
        this.securityName = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.securityName.$$$getRootComponent$$$(), gbc);
        this.privacyLabel = new JLabel();
        this.privacyLabel.setText("Privacy:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.privacyLabel, gbc);
        this.privProtocol = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 5, 10);
        this.panel.add((Component)this.privProtocol, gbc);
        this.newTargetNameLabel = new JLabel();
        this.newTargetNameLabel.setText("New Target Name:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.newTargetNameLabel, gbc);
        this.newTargetName = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.newTargetName, gbc);
        JPanel spacer2 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.fill = 3;
        this.panel.add((Component)spacer2, gbc);
        this.copyVacmGroup = new JCheckBox();
        this.copyVacmGroup.setSelected(true);
        this.copyVacmGroup.setText("Copy VACM group from operational user");
        this.copyVacmGroup.setToolTipText("Set the same acccess rights than current user (uncheck to disable access)");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.copyVacmGroup, gbc);
        this.accessLabel = new JLabel();
        this.accessLabel.setText("Access:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.panel.add((Component)this.accessLabel, gbc);
        this.authPassphrase = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 10, 10);
        this.panel.add((Component)this.authPassphrase.$$$getRootComponent$$$(), gbc);
        this.privPassphrase = new OctetStringField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 10, 10);
        this.panel.add((Component)this.privPassphrase.$$$getRootComponent$$$(), gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

